/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.electrolytegen;

import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.turretmod.api.electrolytegen.IElectrolyteRecipe;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public final class ElectrolyteRecipe
implements IElectrolyteRecipe {
    private final float efficiency;
    private final int procTime;
    private final NonNullList<Ingredient> ingredient;
    private final ItemStack trash;
    private final ItemStack treasure;
    private final ResourceLocation id;
    private final float trashChance;
    private final float treasureChance;

    public ElectrolyteRecipe(ResourceLocation id, @Nonnull Ingredient ingredient, @Nonnull ItemStack trash, @Nonnull ItemStack treasure, float efficiency, int processTime) {
        this(id, ingredient, trash, treasure, efficiency, processTime, 0.2f, 0.02f);
    }

    public ElectrolyteRecipe(ResourceLocation id, @Nonnull Ingredient ingredient, @Nonnull ItemStack trash, @Nonnull ItemStack treasure, float efficiency, int processTime, float trashChance, float treasureChance) {
        this.id = id;
        this.ingredient = NonNullList.func_191197_a((int)1, (Object)ingredient);
        this.efficiency = efficiency;
        this.procTime = processTime;
        this.trash = trash;
        this.treasure = treasure;
        this.trashChance = trashChance;
        this.treasureChance = treasureChance;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public float getEfficiency() {
        return this.efficiency;
    }

    @Override
    public int getProcessTime() {
        return this.procTime;
    }

    @Override
    public boolean matches(IInventory inv, World worldIn) {
        int max = inv.func_70302_i_();
        for (int i = 0; i < max; ++i) {
            for (ItemStack stack : ((Ingredient)this.ingredient.get(0)).func_193365_a()) {
                if (!ItemStackUtils.areEqualNbtFit((ItemStack)stack, (ItemStack)inv.func_70301_a(i), (boolean)false, (boolean)true, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack getCraftingResult(IInventory inv) {
        return this.trash.func_77946_l();
    }

    @Override
    public ItemStack getTreasureResult(IInventory inv) {
        return this.treasure.func_77946_l();
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.trash;
    }

    @Override
    public NonNullList<Ingredient> getIngredients() {
        return this.ingredient;
    }

    @Override
    public String getGroup() {
        return "electrolytegen";
    }

    @Override
    public float getTrashChance() {
        return this.trashChance;
    }

    @Override
    public float getTreasureChance() {
        return this.treasureChance;
    }
}

