/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.electrolytegen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import de.sanandrew.mods.sanlib.lib.util.JsonUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.api.TmrConstants;
import de.sanandrew.mods.turretmod.api.electrolytegen.IElectrolyteManager;
import de.sanandrew.mods.turretmod.registry.electrolytegen.ElectrolyteRecipe;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.logging.log4j.Level;

public class ElectrolyteRecipeLoader {
    public static void initialize(IElectrolyteManager registry) {
        TmrConstants.LOG.log(Level.INFO, "Initializing Electrolyte Generator recipes...");
        long prevTime = System.nanoTime();
        Loader.instance().getActiveModList().forEach(mod -> ElectrolyteRecipeLoader.loadJsonRecipes(mod, registry));
        long timeDelta = (System.nanoTime() - prevTime) / 1000000L;
        TmrConstants.LOG.log(Level.INFO, String.format("Initializing Electrolyte Generator recipes done in %d ms. Found %d recipes.", timeDelta, registry.getFuels().size()));
    }

    private static void loadJsonRecipes(ModContainer mod, IElectrolyteManager registry) {
        String modId = mod.getModId();
        MiscUtils.findFiles((ModContainer)mod, (String)("assets/" + modId + '/' + "sapturretmod" + "/recipes/electrolytegen/"), null, (root, file) -> ElectrolyteRecipeLoader.processJson(modId, root, file, registry));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean processJson(String modId, Path root, Path file, IElectrolyteManager registry) {
        if (!file.toString().endsWith(".json")) {
            return true;
        }
        try (BufferedReader reader = Files.newBufferedReader(file);){
            JsonObject json = (JsonObject)JsonUtils.fromJson((Reader)reader, JsonObject.class);
            ResourceLocation id = MiscUtils.getPathedRL((String)modId, (Path)root, (Path)file);
            if (json == null) {
                throw new JsonSyntaxException("Cannot read valid JSON");
            }
            if (json.isJsonNull()) {
                registry.removeFuel(id);
                boolean bl = true;
                return bl;
            }
            JsonContext context = new JsonContext(modId);
            Ingredient electrolyte = CraftingHelper.getIngredient((JsonElement)json.get("electrolyte"), (JsonContext)context);
            ItemStack trash = ItemStack.field_190927_a;
            ItemStack treasure = ItemStack.field_190927_a;
            JsonElement elem = json.get("trash");
            if (elem != null && !elem.isJsonNull()) {
                trash = JsonUtils.getItemStack((JsonElement)elem);
            }
            if ((elem = json.get("treasure")) != null && !elem.isJsonNull()) {
                treasure = JsonUtils.getItemStack((JsonElement)elem);
            }
            registry.registerFuel(new ElectrolyteRecipe(id, electrolyte, trash, treasure, JsonUtils.getFloatVal((JsonElement)json.get("efficiency")), JsonUtils.getIntVal((JsonElement)json.get("ticksProcessing")), JsonUtils.getFloatVal((JsonElement)json.get("trashChance"), (float)0.2f), JsonUtils.getFloatVal((JsonElement)json.get("treasureChance"), (float)0.02f)));
            return true;
        }
        catch (JsonParseException e) {
            TmrConstants.LOG.log(Level.WARN, String.format("Parsing error loading electrolyte generator recipe from %s", file), (Throwable)e);
            return true;
        }
        catch (IOException e) {
            TmrConstants.LOG.log(Level.WARN, String.format("Couldn't read recipe from %s", file), (Throwable)e);
        }
        return true;
    }
}

