/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.projectile;

import com.google.common.base.Strings;
import de.sanandrew.mods.sanlib.lib.util.config.Category;
import de.sanandrew.mods.sanlib.lib.util.config.Range;
import de.sanandrew.mods.sanlib.lib.util.config.Value;
import de.sanandrew.mods.turretmod.api.ammo.IProjectile;
import de.sanandrew.mods.turretmod.api.ammo.IProjectileInst;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.registry.ammo.Ammunitions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;

@Category(value="crossbow bolt")
public class CrossbowBolt
implements IProjectile {
    private static final ResourceLocation ID = new ResourceLocation("sapturretmod", "crossbowbolt");
    @Value(comment="Base damage this projectile can deal to a target.", range=@Range(minD=0.0, maxD=1024.0))
    public static float damage = 4.0f;
    @Value(comment="Multiplier applied to the speed with which this projectile travels.", range=@Range(minD=0.0, maxD=256.0))
    public static float speed = 1.0f;
    @Value(comment="How much this projectile curves down/up. negative values let it go up, whereas positive values go down.", range=@Range(minD=-10.0, maxD=10.0))
    public static float arc = 0.4f;
    @Value(comment="Horizontal knockback strength this projectile can apply. Vanilla arrows have a value of 0.1.", range=@Range(minD=0.0, maxD=256.0))
    public static float knockbackH = 0.01f;
    @Value(comment="Vertical (y) knockback strength this projectile can apply. Vanilla arrows have a value of 0.1.", range=@Range(minD=0.0, maxD=256.0))
    public static float knockbackV = 0.1f;
    @Value(comment="How much more inaccurate this projectile's trajectory vector becomes. Higher values result in less accuracy.", range=@Range(minD=0.0, maxD=10.0))
    public static double scatter = 0.1;

    @Override
    @Nonnull
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public float getArc() {
        return arc;
    }

    @Override
    public SoundEvent getRicochetSound() {
        return SoundEvents.field_187731_t;
    }

    @Override
    public float getSpeed() {
        return speed;
    }

    @Override
    public float getDamage() {
        return damage;
    }

    @Override
    public float getKnockbackHorizontal() {
        return knockbackH;
    }

    @Override
    public float getKnockbackVertical() {
        return knockbackV;
    }

    @Override
    public double getScatterValue() {
        return scatter;
    }

    @Override
    public void onDamageEntityPost(@Nullable ITurretInst turret, @Nonnull IProjectileInst projectile, Entity target, DamageSource damageSrc) {
        String subtype;
        if (target instanceof EntityLivingBase && projectile.getAmmunition() == Ammunitions.TIPPED_BOLT && !Strings.isNullOrEmpty((String)(subtype = projectile.getAmmunitionSubtype()))) {
            PotionType potion = (PotionType)PotionType.field_185176_a.func_82594_a((Object)new ResourceLocation(subtype));
            for (PotionEffect effect : potion.func_185170_a()) {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(effect.func_188419_a(), Math.max(effect.func_76459_b() / 8, 1), effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e()));
            }
        }
    }
}

