/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.projectile;

import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.sanlib.lib.util.config.Category;
import de.sanandrew.mods.sanlib.lib.util.config.Range;
import de.sanandrew.mods.sanlib.lib.util.config.Value;
import de.sanandrew.mods.turretmod.api.ammo.IProjectile;
import de.sanandrew.mods.turretmod.api.ammo.IProjectileInst;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurretProjectile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import org.apache.commons.lang3.mutable.MutableFloat;

@Category(value="flame")
public class Flame
implements IProjectile {
    static final ResourceLocation ID1 = new ResourceLocation("sapturretmod", "flame.normal");
    static final ResourceLocation ID2 = new ResourceLocation("sapturretmod", "flame.pure");
    @Value(comment="Base damage this projectile can deal to a target.", range=@Range(minD=0.0, maxD=1024.0))
    public static float damage = 0.55f;
    @Value(comment="Multiplier applied to the speed with which this projectile travels.", range=@Range(minD=0.0, maxD=256.0))
    public static float speed = 0.6f;
    @Value(comment="How much this projectile curves down/up. negative values let it go up, whereas positive values go down.", range=@Range(minD=-10.0, maxD=10.0))
    public static float arc = -0.15f;
    @Value(comment="Horizontal knockback strength this projectile can apply. Vanilla arrows have a value of 0.1.", range=@Range(minD=0.0, maxD=256.0))
    public static float knockbackH = 0.0f;
    @Value(comment="Vertical (y) knockback strength this projectile can apply. Vanilla arrows have a value of 0.1.", range=@Range(minD=0.0, maxD=256.0))
    public static float knockbackV = 0.0f;
    @Value(comment="How much more inaccurate this projectile's trajectory vector becomes. Higher values result in less accuracy.", range=@Range(minD=0.0, maxD=10.0))
    public static double scatter = 0.1;
    @Value(comment="How much damage this projectile looses after successfully hitting an entity. If the damage reaches 0, the projectile is killed.", range=@Range(minD=0.0, maxD=1024.0))
    public static float damageReduction = 0.5f;
    @Value(comment="Wether or not purifying flames cause fire on blocks hit.")
    public static boolean purifyingFireBlocks = true;
    @Value(comment="How high in percent the chance is of purifying flames causing fire on blocks hit.", range=@Range(minD=0.0, maxD=100.0))
    public static float purifyingFireBlocksChance = 1.0f;
    private final boolean purifying;
    private final ResourceLocation id;

    Flame(ResourceLocation id) {
        this.id = id;
        this.purifying = id.equals((Object)ID2);
    }

    @Override
    @Nonnull
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public void onCreate(@Nullable ITurretInst turret, @Nonnull IProjectileInst projectile) {
        if (turret != null) {
            Entity projEntity = projectile.get();
            float rotXZ = -turret.get().field_70759_as / 180.0f * (float)Math.PI;
            float rotY = -(turret.get().field_70125_A - 2.5f) / 180.0f * (float)Math.PI - 0.1f;
            projEntity.field_70165_t += Math.sin(rotXZ) * (double)0.7f * Math.cos(rotY);
            projEntity.field_70163_u += Math.sin(rotY) * (double)0.6f;
            projEntity.field_70161_v += Math.cos(rotXZ) * (double)0.7f * Math.cos(rotY);
            projEntity.func_70107_b(projEntity.field_70165_t, projEntity.field_70163_u, projEntity.field_70161_v);
        }
    }

    @Override
    public float getArc() {
        return arc;
    }

    @Override
    public float getSpeed() {
        return speed;
    }

    @Override
    public float getDamage() {
        return damage;
    }

    @Override
    public float getKnockbackHorizontal() {
        return knockbackH;
    }

    @Override
    public float getKnockbackVertical() {
        return knockbackV;
    }

    @Override
    public double getScatterValue() {
        return scatter;
    }

    @Override
    public SoundEvent getRicochetSound() {
        return SoundEvents.field_187646_bt;
    }

    @Override
    public DamageSource getCustomDamageSrc(@Nullable ITurretInst turret, @Nonnull IProjectileInst projectile, Entity target, IProjectile.TargetType type) {
        DamageSource ds = EntityTurretProjectile.getDamageSource(turret, projectile, type);
        if (!this.purifying) {
            ds.func_76361_j();
        }
        return ds;
    }

    @Override
    public boolean onHit(@Nullable ITurretInst turret, @Nonnull IProjectileInst projectile, RayTraceResult hitObj) {
        if (hitObj.field_72313_a != RayTraceResult.Type.ENTITY) {
            BlockPos fire;
            Entity projEntity = projectile.get();
            if (this.purifying && purifyingFireBlocks && hitObj.field_72313_a == RayTraceResult.Type.BLOCK && !projEntity.field_70170_p.field_72995_K && (double)MiscUtils.RNG.randomFloat() * 100.0 < (double)purifyingFireBlocksChance && projEntity.field_70170_p.func_175623_d(fire = hitObj.func_178782_a().func_177972_a(hitObj.field_178784_b))) {
                projEntity.field_70170_p.func_180501_a(fire, Blocks.field_150480_ab.func_176223_P(), 11);
            }
            return true;
        }
        float lastDmg = projectile.getLastCausedDamage();
        hitObj.field_72308_g.func_70015_d(10);
        return lastDmg >= 0.0f && lastDmg - damageReduction <= 0.0f;
    }

    @Override
    public boolean onDamageEntityPre(@Nullable ITurretInst turret, @Nonnull IProjectileInst projectile, Entity target, DamageSource damageSrc, MutableFloat damage) {
        if (projectile.getLastDamagedEntity() == target) {
            return false;
        }
        float lastDmg = projectile.getLastCausedDamage();
        if (lastDmg > 0.0f) {
            damage.setValue(lastDmg - damageReduction);
        }
        return true;
    }
}

