/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.projectile;

import de.sanandrew.mods.sanlib.lib.util.config.Category;
import de.sanandrew.mods.sanlib.lib.util.config.Range;
import de.sanandrew.mods.sanlib.lib.util.config.Value;
import de.sanandrew.mods.turretmod.api.ammo.IProjectile;
import javax.annotation.Nonnull;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;

@Category(value="harpoon")
public class Harpoon
implements IProjectile {
    private static final ResourceLocation ID = new ResourceLocation("sapturretmod", "harpoon");
    @Value(comment="Base damage this projectile can deal to a target.", range=@Range(minD=0.0, maxD=1024.0))
    public static float damage = 6.0f;
    @Value(comment="Multiplier applied to the speed with which this projectile travels.", range=@Range(minD=0.0, maxD=256.0))
    public static float speed = 1.0f;
    @Value(comment="How much this projectile curves down/up. negative values let it go up, whereas positive values go down.", range=@Range(minD=-10.0, maxD=10.0))
    public static float arc = 0.4f;
    @Value(comment="Horizontal knockback strength this projectile can apply. Vanilla arrows have a value of 0.1.", range=@Range(minD=0.0, maxD=256.0))
    public static float knockbackH = 0.01f;
    @Value(comment="Vertical (y) knockback strength this projectile can apply. Vanilla arrows have a value of 0.1.", range=@Range(minD=0.0, maxD=256.0))
    public static float knockbackV = 0.1f;
    @Value(comment="How much more inaccurate this projectile's trajectory vector becomes. Higher values result in less accuracy.", range=@Range(minD=0.0, maxD=10.0))
    public static double scatter = 0.1;

    @Override
    @Nonnull
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public float getArc() {
        return arc;
    }

    @Override
    public SoundEvent getRicochetSound() {
        return SoundEvents.field_187731_t;
    }

    @Override
    public float getSpeed() {
        return speed;
    }

    @Override
    public float getDamage() {
        return damage;
    }

    @Override
    public float getKnockbackHorizontal() {
        return knockbackH;
    }

    @Override
    public float getKnockbackVertical() {
        return knockbackV;
    }

    @Override
    public double getScatterValue() {
        return scatter;
    }

    @Override
    public float getSpeedMultiplierLiquid(float viscosity) {
        return 2.0f - viscosity;
    }
}

