/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.projectile;

import de.sanandrew.mods.sanlib.lib.util.config.Category;
import de.sanandrew.mods.sanlib.lib.util.config.Range;
import de.sanandrew.mods.sanlib.lib.util.config.Value;
import de.sanandrew.mods.turretmod.api.ammo.IProjectile;
import de.sanandrew.mods.turretmod.api.ammo.IProjectileInst;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurretProjectile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import org.apache.commons.lang3.mutable.MutableFloat;

@Category(value="laser")
public class Laser
implements IProjectile {
    static final ResourceLocation ID1 = new ResourceLocation("sapturretmod", "laser.normal");
    static final ResourceLocation ID2 = new ResourceLocation("sapturretmod", "laser.pure");
    @Value(comment="Base damage this projectile can deal to a target.", range=@Range(minD=0.0, maxD=1024.0))
    public static float damage = 2.0f;
    @Value(comment="Multiplier applied to the speed with which this projectile travels.", range=@Range(minD=0.0, maxD=256.0))
    public static float speed = 20.0f;
    @Value(comment="How much this projectile curves down/up. negative values let it go up, whereas positive values go down.", range=@Range(minD=-10.0, maxD=10.0))
    public static float arc = 0.0f;
    @Value(comment="Horizontal knockback strength this projectile can apply. Vanilla arrows have a value of 0.1.", range=@Range(minD=0.0, maxD=256.0))
    public static float knockbackH = 0.0f;
    @Value(comment="Vertical (y) knockback strength this projectile can apply. Vanilla arrows have a value of 0.1.", range=@Range(minD=0.0, maxD=256.0))
    public static float knockbackV = 0.0f;
    @Value(comment="How much more inaccurate this projectile's trajectory vector becomes. Higher values result in less accuracy.", range=@Range(minD=0.0, maxD=10.0))
    public static double scatter = 0.0;
    @Value(comment="How long an entity hit with this projectile is set on fire in seconds. 0 disables this.", range=@Range(minI=0))
    public static int fireTime = 2;
    private final boolean isBlue;
    private final ResourceLocation id;

    Laser(ResourceLocation id) {
        this.id = id;
        this.isBlue = id.equals((Object)ID2);
    }

    @Override
    @Nonnull
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public float getArc() {
        return arc;
    }

    @Override
    public float getSpeed() {
        return speed;
    }

    @Override
    public float getDamage() {
        return damage;
    }

    @Override
    public float getKnockbackHorizontal() {
        return knockbackH;
    }

    @Override
    public float getKnockbackVertical() {
        return knockbackV;
    }

    @Override
    public SoundEvent getRicochetSound() {
        return SoundEvents.field_187646_bt;
    }

    @Override
    public double getScatterValue() {
        return scatter;
    }

    @Override
    public DamageSource getCustomDamageSrc(@Nullable ITurretInst turret, @Nonnull IProjectileInst projectile, Entity target, IProjectile.TargetType type) {
        DamageSource ds = EntityTurretProjectile.getDamageSource(turret, projectile, type);
        if (!this.isBlue) {
            ds.func_76361_j();
        }
        return ds;
    }

    @Override
    public boolean onDamageEntityPre(@Nullable ITurretInst turret, @Nonnull IProjectileInst projectile, Entity target, DamageSource damageSrc, MutableFloat damage) {
        boolean flammable;
        boolean bl = flammable = !target.func_70045_F();
        if (!this.isBlue) {
            return flammable;
        }
        if (flammable) {
            damage.setValue(damage.floatValue() * 1.25f);
        }
        return true;
    }

    @Override
    public void onDamageEntityPost(@Nullable ITurretInst turret, @Nonnull IProjectileInst projectile, Entity target, DamageSource damageSrc) {
        if (fireTime > 0) {
            target.func_70015_d(fireTime);
        }
    }
}

