/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.projectile;

import de.sanandrew.mods.sanlib.lib.util.config.Category;
import de.sanandrew.mods.sanlib.lib.util.config.Range;
import de.sanandrew.mods.sanlib.lib.util.config.Value;
import de.sanandrew.mods.turretmod.api.ammo.IProjectile;
import de.sanandrew.mods.turretmod.api.ammo.IProjectileInst;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.registry.Sounds;
import de.sanandrew.mods.turretmod.registry.turret.TurretMinigun;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;

@Category(value="minigun pebble")
public class MinigunPebble
implements IProjectile {
    private static final ResourceLocation ID = new ResourceLocation("sapturretmod", "pebble.minigun");
    @Value(comment="Base damage this projectile can deal to a target.", range=@Range(minD=0.0, maxD=1024.0))
    public static float damage = 0.9f;
    @Value(comment="Multiplier applied to the speed with which this projectile travels.", range=@Range(minD=0.0, maxD=256.0))
    public static float speed = 3.0f;
    @Value(comment="How much this projectile curves down/up. negative values let it go up, whereas positive values go down.", range=@Range(minD=-10.0, maxD=10.0))
    public static float arc = 0.001f;
    @Value(comment="Horizontal knockback strength this projectile can apply. Vanilla arrows have a value of 0.1.", range=@Range(minD=0.0, maxD=256.0))
    public static float knockbackH = 0.0f;
    @Value(comment="Vertical (y) knockback strength this projectile can apply. Vanilla arrows have a value of 0.1.", range=@Range(minD=0.0, maxD=256.0))
    public static float knockbackV = 0.0f;
    @Value(comment="How much more inaccurate this projectile's trajectory vector becomes. Higher values result in less accuracy.", range=@Range(minD=0.0, maxD=10.0))
    public static double scatter = 0.01f;

    @Override
    @Nonnull
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public void onCreate(@Nullable ITurretInst turret, @Nonnull IProjectileInst projectile) {
        if (turret != null) {
            TurretMinigun.MyRAM ram = turret.getRAM(TurretMinigun.MyRAM::new);
            float shift = (ram.isLeftShot ? 45.0f : -45.0f) / 180.0f * (float)Math.PI;
            float rotXZ = -turret.get().field_70759_as / 180.0f * (float)Math.PI;
            float rotY = -(turret.get().field_70125_A - 7.5f) / 180.0f * (float)Math.PI - 0.1f;
            Entity projEntity = projectile.get();
            projEntity.field_70165_t += Math.sin(rotXZ + shift) * (double)0.7f * Math.cos(rotY);
            projEntity.field_70163_u += Math.sin(rotY) * (double)0.6f;
            projEntity.field_70161_v += Math.cos(rotXZ + shift) * (double)0.7f * Math.cos(rotY);
            projEntity.func_70107_b(projEntity.field_70165_t, projEntity.field_70163_u, projEntity.field_70161_v);
        }
    }

    @Override
    public float getArc() {
        return arc;
    }

    @Override
    public SoundEvent getRicochetSound() {
        return Sounds.RICOCHET_BULLET;
    }

    @Override
    public float getSpeed() {
        return speed;
    }

    @Override
    public float getDamage() {
        return damage;
    }

    @Override
    public float getKnockbackHorizontal() {
        return knockbackH;
    }

    @Override
    public float getKnockbackVertical() {
        return knockbackV;
    }

    @Override
    public double getScatterValue() {
        return scatter;
    }
}

