/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.projectile;

import de.sanandrew.mods.turretmod.api.ammo.IProjectile;
import de.sanandrew.mods.turretmod.api.ammo.IProjectileRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;

public final class ProjectileRegistry
implements IProjectileRegistry {
    public static final ProjectileRegistry INSTANCE = new ProjectileRegistry();
    private static final IProjectile NULL_PROJ = new IProjectile(){

        @Override
        @Nonnull
        public ResourceLocation getId() {
            return new ResourceLocation("null");
        }

        @Override
        public float getSpeed() {
            return 0.0f;
        }

        @Override
        public float getArc() {
            return 0.0f;
        }

        @Override
        public float getDamage() {
            return 0.0f;
        }

        @Override
        public float getKnockbackHorizontal() {
            return 0.0f;
        }

        @Override
        public float getKnockbackVertical() {
            return 0.0f;
        }

        @Override
        public SoundEvent getRicochetSound() {
            return null;
        }

        @Override
        public double getScatterValue() {
            return 0.0;
        }

        @Override
        public boolean isValid() {
            return false;
        }
    };
    private final Map<ResourceLocation, IProjectile> projectiles = new HashMap<ResourceLocation, IProjectile>();
    private final Collection<IProjectile> projList = Collections.unmodifiableCollection(this.projectiles.values());

    private ProjectileRegistry() {
    }

    @Override
    @Nonnull
    public IProjectile getObject(ResourceLocation id) {
        return this.projectiles.getOrDefault(id, NULL_PROJ);
    }

    @Override
    @Nonnull
    public IProjectile getObject(ItemStack stack) {
        return NULL_PROJ;
    }

    @Override
    @Nonnull
    public IProjectile getDefaultObject() {
        return NULL_PROJ;
    }

    @Override
    public void register(@Nonnull IProjectile obj) {
        this.projectiles.put(obj.getId(), obj);
    }

    @Override
    @Nonnull
    public Collection<IProjectile> getObjects() {
        return this.projList;
    }
}

