/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.repairkit;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.turretmod.api.TmrConstants;
import de.sanandrew.mods.turretmod.api.repairkit.IRepairKit;
import de.sanandrew.mods.turretmod.api.repairkit.IRepairKitRegistry;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import de.sanandrew.mods.turretmod.item.ItemRepairKit;
import java.security.InvalidParameterException;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public final class RepairKitRegistry
implements IRepairKitRegistry {
    public static final RepairKitRegistry INSTANCE = new RepairKitRegistry();
    private final BiMap<ResourceLocation, IRepairKit> repairKitMap = HashBiMap.create();
    private final NonNullList<IRepairKit> repairKitList = NonNullList.func_191196_a();
    private static final IRepairKit NULL_TYPE = new IRepairKit(){

        @Override
        public ResourceLocation getId() {
            return new ResourceLocation("null");
        }

        @Override
        public float getHealAmount() {
            return 0.0f;
        }

        @Override
        public boolean isApplicable(ITurretInst turret) {
            return false;
        }

        @Override
        public boolean isValid() {
            return false;
        }
    };

    private RepairKitRegistry() {
    }

    @Override
    public void register(IRepairKit obj) {
        if (obj == null) {
            TmrConstants.LOG.log(Level.ERROR, "Cannot register NULL as Repair Kit!", (Throwable)new InvalidParameterException());
            return;
        }
        if (this.repairKitMap.containsKey((Object)obj.getId())) {
            TmrConstants.LOG.log(Level.ERROR, String.format("The UUID of the Repair Kit %s is already registered! Use another UUID. JUST DO IT!", obj.getId()), (Throwable)new InvalidParameterException());
            return;
        }
        this.repairKitMap.put((Object)obj.getId(), (Object)obj);
        this.repairKitList.add((Object)obj);
        ItemRegistry.TURRET_REPAIRKITS.put(obj.getId(), new ItemRepairKit(obj));
    }

    @Override
    @Nonnull
    public IRepairKit getDefaultObject() {
        return NULL_TYPE;
    }

    @Override
    public NonNullList<IRepairKit> getObjects() {
        return NonNullList.func_193580_a((Object)NULL_TYPE, (Object[])this.repairKitMap.values().toArray(new IRepairKit[0]));
    }

    @Override
    @Nonnull
    public IRepairKit getObject(ResourceLocation id) {
        return (IRepairKit)this.repairKitMap.getOrDefault((Object)id, (Object)NULL_TYPE);
    }

    @Override
    @Nonnull
    public IRepairKit getObject(@Nonnull ItemStack stack) {
        if (ItemStackUtils.isValid((ItemStack)stack) && stack.func_77973_b() instanceof ItemRepairKit) {
            return ((ItemRepairKit)stack.func_77973_b()).kit;
        }
        return NULL_TYPE;
    }

    @Override
    public ItemStack getItem(ResourceLocation id) {
        if (!((IRepairKit)this.repairKitMap.getOrDefault((Object)id, (Object)NULL_TYPE)).isValid()) {
            throw new IllegalArgumentException("Cannot get repair kit item with invalid type!");
        }
        return new ItemStack((Item)ItemRegistry.TURRET_REPAIRKITS.get(id), 1);
    }
}

