/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.turret;

import de.sanandrew.mods.sanlib.lib.util.config.Category;
import de.sanandrew.mods.sanlib.lib.util.config.Range;
import de.sanandrew.mods.sanlib.lib.util.config.Value;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.turret.IVariant;
import de.sanandrew.mods.turretmod.api.turret.IVariantHolder;
import de.sanandrew.mods.turretmod.registry.Resources;
import de.sanandrew.mods.turretmod.registry.Sounds;
import de.sanandrew.mods.turretmod.registry.turret.variant.SingleItemVariants;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockPlanks;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;

@Category(value="cryolator")
public class TurretCryolator
implements ITurret,
IVariantHolder {
    private static final ResourceLocation ID = new ResourceLocation("sapturretmod", "turret_cryolator");
    private static AxisAlignedBB rangeBB;
    @Value(comment="Maximum health this turret has.", range=@Range(minD=0.1, maxD=1024.0), reqWorldRestart=true)
    public static float maxHealth;
    @Value(comment="Maximum capacity of ammo rounds this turret can hold.", range=@Range(minI=1, maxI=32767), reqWorldRestart=true)
    public static int maxAmmoCapacity;
    @Value(comment="Maximum tick time between shots. 20 ticks = 1 second.", range=@Range(minI=1), reqWorldRestart=true)
    public static int maxReloadTicks;
    @Value(comment="Horizontal length of half the edge of the targeting box. The total edge length is [value * 2], with the turret centered in it.", range=@Range(minD=1.0), reqMcRestart=true)
    public static double rangeH;
    @Value(comment="Vertical length of the edge of the targeting box, from the turret upwards.", range=@Range(minD=1.0), reqMcRestart=true)
    public static double rangeU;
    @Value(comment="Vertical length of the edge of the targeting box, from the turret downwards.", range=@Range(minD=1.0), reqMcRestart=true)
    public static double rangeD;
    public static final SingleItemVariants VARIANTS;

    @Override
    public ResourceLocation getStandardTexture(ITurretInst turretInst) {
        return turretInst.getVariant().getTexture();
    }

    @Override
    public ResourceLocation getGlowTexture(ITurretInst turretInst) {
        return Resources.TURRET_T1_CRYOLATOR_GLOW.resource;
    }

    @Override
    public AxisAlignedBB getRangeBB(ITurretInst turretInst) {
        if (rangeBB == null) {
            rangeBB = new AxisAlignedBB(-rangeH, -rangeD, -rangeH, rangeH, rangeU, rangeH);
        }
        return rangeBB;
    }

    @Override
    public SoundEvent getShootSound(ITurretInst turretInst) {
        return Sounds.SHOOT_CRYOLATOR;
    }

    @Override
    public int getTier() {
        return 1;
    }

    @Override
    public float getHealth() {
        return maxHealth;
    }

    @Override
    public int getAmmoCapacity() {
        return maxAmmoCapacity;
    }

    @Override
    public int getReloadTicks() {
        return maxReloadTicks;
    }

    @Override
    @Nonnull
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public IVariant getVariant(ResourceLocation id) {
        return VARIANTS.getOrDefault(id);
    }

    @Override
    public boolean isDefaultVariant(IVariant variant) {
        return VARIANTS.isDefaultVariant(variant);
    }

    @Override
    public void registerVariant(IVariant variant) {
        VARIANTS.register(variant);
    }

    static {
        maxHealth = 20.0f;
        maxAmmoCapacity = 256;
        maxReloadTicks = 20;
        rangeH = 16.0;
        rangeU = 16.0;
        rangeD = 8.0;
        VARIANTS = new SingleItemVariants();
        String txPath = Resources.TURRET_T1_CRYOLATOR.resource.func_110623_a();
        for (BlockPlanks.EnumType plank : BlockPlanks.EnumType.values()) {
            VARIANTS.register(new ItemStack(Blocks.field_150344_f, 1, plank.func_176839_a()), txPath, plank.func_176610_l());
        }
    }
}

