/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.turret;

import de.sanandrew.mods.sanlib.lib.util.config.Category;
import de.sanandrew.mods.sanlib.lib.util.config.Range;
import de.sanandrew.mods.sanlib.lib.util.config.Value;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.registry.Resources;
import de.sanandrew.mods.turretmod.registry.Sounds;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;

@Category(value="flamethrower")
public class TurretFlamethrower
implements ITurret {
    private static final ResourceLocation ID = new ResourceLocation("sapturretmod", "turret_flamethrower");
    private static AxisAlignedBB rangeBB;
    @Value(comment="Maximum health this turret has.", range=@Range(minD=0.1, maxD=1024.0), reqWorldRestart=true)
    public static float health;
    @Value(comment="Capacity of ammo rounds this turret can hold.", range=@Range(minI=1, maxI=32767), reqWorldRestart=true)
    public static int ammoCapacity;
    @Value(comment="Maximum tick time between shots. 20 ticks = 1 second.", range=@Range(minI=1), reqWorldRestart=true)
    public static int reloadTicks;
    @Value(comment="Horizontal length of half the edge of the targeting box. The total edge length is [value * 2], with the turret centered in it.", range=@Range(minD=1.0), reqMcRestart=true)
    public static double rangeH;
    @Value(comment="Vertical length of the edge of the targeting box, from the turret upwards.", range=@Range(minD=1.0), reqMcRestart=true)
    public static double rangeU;
    @Value(comment="Vertical length of the edge of the targeting box, from the turret downwards.", range=@Range(minD=1.0), reqMcRestart=true)
    public static double rangeD;

    @Override
    public ResourceLocation getStandardTexture(ITurretInst turretInst) {
        return Resources.TURRET_T3_FTHROWER.resource;
    }

    @Override
    public ResourceLocation getGlowTexture(ITurretInst turretInst) {
        return Resources.TURRET_T3_FTHROWER_GLOW.resource;
    }

    @Override
    public AxisAlignedBB getRangeBB(ITurretInst turretInst) {
        if (rangeBB == null) {
            rangeBB = new AxisAlignedBB(-rangeH, -rangeD, -rangeH, rangeH, rangeU, rangeH);
        }
        return rangeBB;
    }

    @Override
    public SoundEvent getShootSound(ITurretInst turretInst) {
        return turretInst.get().func_70681_au().nextBoolean() ? Sounds.SHOOT_FLAMETHROWER : null;
    }

    @Override
    public int getTier() {
        return 3;
    }

    @Override
    public float getHealth() {
        return health;
    }

    @Override
    public int getAmmoCapacity() {
        return ammoCapacity;
    }

    @Override
    public int getReloadTicks() {
        return reloadTicks;
    }

    @Override
    @Nonnull
    public ResourceLocation getId() {
        return ID;
    }

    static {
        health = 40.0f;
        ammoCapacity = 4096;
        reloadTicks = 1;
        rangeH = 8.0;
        rangeU = 4.0;
        rangeD = 2.0;
    }
}

