/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.turret;

import de.sanandrew.mods.sanlib.lib.util.config.Category;
import de.sanandrew.mods.sanlib.lib.util.config.Range;
import de.sanandrew.mods.sanlib.lib.util.config.Value;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.turret.IVariant;
import de.sanandrew.mods.turretmod.api.turret.IVariantHolder;
import de.sanandrew.mods.turretmod.registry.Resources;
import de.sanandrew.mods.turretmod.registry.turret.variant.SingleItemVariants;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;

@Category(value="harpoon")
public class TurretHarpoon
implements ITurret,
IVariantHolder {
    private static final ResourceLocation ID = new ResourceLocation("sapturretmod", "turret_harpoon");
    private static AxisAlignedBB rangeBB;
    @Value(comment="Maximum health this turret has.", range=@Range(minD=0.1, maxD=1024.0), reqWorldRestart=true)
    public static float health;
    @Value(comment="Capacity of ammo rounds this turret can hold.", range=@Range(minI=1, maxI=32767), reqWorldRestart=true)
    public static int ammoCapacity;
    @Value(comment="Maximum tick time between shots. 20 ticks = 1 second.", range=@Range(minI=1), reqWorldRestart=true)
    public static int reloadTicks;
    @Value(comment="Horizontal length of half the edge of the targeting box. The total edge length is [value * 2], with the turret centered in it.", range=@Range(minD=1.0), reqMcRestart=true)
    public static double rangeH;
    @Value(comment="Vertical length of the edge of the targeting box, from the turret upwards.", range=@Range(minD=1.0), reqMcRestart=true)
    public static double rangeU;
    @Value(comment="Vertical length of the edge of the targeting box, from the turret downwards.", range=@Range(minD=1.0), reqMcRestart=true)
    public static double rangeD;
    public static final SingleItemVariants VARIANTS;

    @Override
    public ResourceLocation getStandardTexture(ITurretInst turretInst) {
        return turretInst.getVariant().getTexture();
    }

    @Override
    public ResourceLocation getGlowTexture(ITurretInst turretInst) {
        return Resources.TURRET_T1_HARPOON_GLOW.resource;
    }

    @Override
    public AxisAlignedBB getRangeBB(ITurretInst turretInst) {
        if (rangeBB == null) {
            rangeBB = new AxisAlignedBB(-rangeH, -rangeD, -rangeH, rangeH, rangeU, rangeH);
        }
        return rangeBB;
    }

    @Override
    public SoundEvent getShootSound(ITurretInst turretInst) {
        return SoundEvents.field_187578_au;
    }

    @Override
    public int getTier() {
        return 1;
    }

    @Override
    public float getHealth() {
        return health;
    }

    @Override
    public int getAmmoCapacity() {
        return ammoCapacity;
    }

    @Override
    public int getReloadTicks() {
        return reloadTicks;
    }

    @Override
    @Nonnull
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public ITurret.AttackType getAttackType() {
        return ITurret.AttackType.WATER;
    }

    @Override
    public boolean isBuoy() {
        return true;
    }

    @Override
    public float getEyeHeight(float height) {
        return height * 0.155f;
    }

    @Override
    public IVariant getVariant(ResourceLocation id) {
        return VARIANTS.getOrDefault(id);
    }

    @Override
    public void registerVariant(IVariant variant) {
        VARIANTS.register(variant);
    }

    @Override
    public boolean isDefaultVariant(IVariant variant) {
        return VARIANTS.isDefaultVariant(variant);
    }

    static {
        health = 20.0f;
        ammoCapacity = 256;
        reloadTicks = 20;
        rangeH = 16.0;
        rangeU = 4.0;
        rangeD = 8.0;
        VARIANTS = new SingleItemVariants();
        String txPath = Resources.TURRET_T1_HARPOON.resource.func_110623_a();
        VARIANTS.register(new ItemStack(Blocks.field_150405_ch), txPath, "terracotta");
        for (EnumDyeColor clr : EnumDyeColor.values()) {
            String clrName = clr.func_176610_l();
            String glazedName = String.format("%s_glazed_terracotta", clrName);
            VARIANTS.register(new ItemStack(Blocks.field_150406_ce, 1, clr.func_176765_a()), txPath, String.format("%s_terracotta", clrName));
            VARIANTS.register(new ItemStack(Objects.requireNonNull(Block.func_149684_b((String)glazedName))), txPath, glazedName);
        }
    }
}

