/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.turret;

import de.sanandrew.mods.sanlib.lib.Tuple;
import de.sanandrew.mods.sanlib.lib.util.config.Category;
import de.sanandrew.mods.sanlib.lib.util.config.Range;
import de.sanandrew.mods.sanlib.lib.util.config.Value;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.turret.ITurretRAM;
import de.sanandrew.mods.turretmod.api.turret.IVariant;
import de.sanandrew.mods.turretmod.api.turret.IVariantHolder;
import de.sanandrew.mods.turretmod.registry.EnumEffect;
import de.sanandrew.mods.turretmod.registry.Resources;
import de.sanandrew.mods.turretmod.registry.Sounds;
import de.sanandrew.mods.turretmod.registry.turret.variant.SingleItemVariants;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;

@Category(value="minigun")
public class TurretMinigun
implements ITurret,
IVariantHolder {
    private static final ResourceLocation ID = new ResourceLocation("sapturretmod", "turret_minigun");
    private static AxisAlignedBB rangeBB;
    @Value(comment="Maximum health this turret has.", range=@Range(minD=0.1, maxD=1024.0), reqWorldRestart=true)
    public static float health;
    @Value(comment="Capacity of ammo rounds this turret can hold.", range=@Range(minI=1, maxI=32767), reqWorldRestart=true)
    public static int ammoCapacity;
    @Value(comment="Maximum tick time between shots. 20 ticks = 1 second.", range=@Range(minI=1), reqWorldRestart=true)
    public static int reloadTicks;
    @Value(comment="Horizontal length of half the edge of the targeting box. The total edge length is [value * 2], with the turret centered in it.", range=@Range(minD=1.0), reqMcRestart=true)
    public static double rangeH;
    @Value(comment="Vertical length of the edge of the targeting box, from the turret upwards.", range=@Range(minD=1.0), reqMcRestart=true)
    public static double rangeU;
    @Value(comment="Vertical length of the edge of the targeting box, from the turret downwards.", range=@Range(minD=1.0), reqMcRestart=true)
    public static double rangeD;
    public static final SingleItemVariants VARIANTS;
    private static final ResourceLocation MELON_VARIANT;

    @Override
    public void onUpdate(ITurretInst turretInst) {
        EntityLiving turretL = turretInst.get();
        MyRAM ram = turretInst.getRAM(MyRAM::new);
        ram.prevBarrelLeft = ram.barrelLeft;
        ram.prevBarrelRight = ram.barrelRight;
        ram.barrelLeft = ram.barrelLeft < ram.maxBarrelLeft ? (ram.barrelLeft += 90.0f / (float)turretInst.getTargetProcessor().getMaxShootTicks() * 2.0f) : ram.maxBarrelLeft;
        ram.barrelRight = ram.barrelRight < ram.maxBarrelRight ? (ram.barrelRight += 90.0f / (float)turretInst.getTargetProcessor().getMaxShootTicks() * 2.0f) : ram.maxBarrelRight;
        if (turretInst.wasShooting()) {
            if (ram.isLeftShot) {
                ram.maxBarrelRight += 90.0f;
                ram.isLeftShot = false;
            } else {
                ram.maxBarrelLeft += 90.0f;
                ram.isLeftShot = true;
            }
            if (turretL.field_70170_p.field_72995_K) {
                EnumEffect.MINIGUN_SMOKE.addEffect((Entity)turretL, new Tuple(new Object[]{Float.valueOf(turretL.field_70759_as), Float.valueOf(turretL.field_70125_A - 7.5f), ram.isLeftShot}));
            }
        }
    }

    @Override
    public ResourceLocation getStandardTexture(ITurretInst turretInst) {
        return (turretInst.get().func_145818_k_() && turretInst.get().func_95999_t().equalsIgnoreCase("silverchiren") ? VARIANTS.getOrDefault(MELON_VARIANT) : turretInst.getVariant()).getTexture();
    }

    @Override
    public ResourceLocation getGlowTexture(ITurretInst turretInst) {
        return Resources.TURRET_T2_MINIGUN_GLOW.resource;
    }

    @Override
    public AxisAlignedBB getRangeBB(ITurretInst turretInst) {
        if (rangeBB == null) {
            rangeBB = new AxisAlignedBB(-rangeH, -rangeD, -rangeH, rangeH, rangeU, rangeH);
        }
        return rangeBB;
    }

    @Override
    public SoundEvent getShootSound(ITurretInst turretInst) {
        return Sounds.SHOOT_MINIGUN;
    }

    @Override
    @Nonnull
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public int getTier() {
        return 2;
    }

    @Override
    public IVariant getVariant(ResourceLocation id) {
        return VARIANTS.getOrDefault(id);
    }

    @Override
    public void registerVariant(IVariant variant) {
        VARIANTS.register(variant);
    }

    @Override
    public boolean isDefaultVariant(IVariant variant) {
        return VARIANTS.isDefaultVariant(variant);
    }

    @Override
    public float getHealth() {
        return health;
    }

    @Override
    public int getAmmoCapacity() {
        return ammoCapacity;
    }

    @Override
    public int getReloadTicks() {
        return reloadTicks;
    }

    @Override
    public ITurret.AttackType getAttackType() {
        return ITurret.AttackType.AIR;
    }

    static {
        health = 30.0f;
        ammoCapacity = 512;
        reloadTicks = 3;
        rangeH = 20.0;
        rangeU = 20.0;
        rangeD = 4.0;
        VARIANTS = new SingleItemVariants();
        String txPath = Resources.TURRET_T2_MINIGUN.resource.func_110623_a();
        VARIANTS.register(new ItemStack((Block)Blocks.field_150333_U, 1, 0), txPath, "stone");
        VARIANTS.register(new ItemStack((Block)Blocks.field_150333_U, 1, 1), txPath, "sandstone");
        VARIANTS.register(new ItemStack((Block)Blocks.field_150333_U, 1, 3), txPath, "cobblestone");
        VARIANTS.register(new ItemStack((Block)Blocks.field_150333_U, 1, 4), txPath, "bricks");
        VARIANTS.register(new ItemStack((Block)Blocks.field_150333_U, 1, 5), txPath, "stonebrick");
        VARIANTS.register(new ItemStack((Block)Blocks.field_180389_cP, 1, 0), txPath, "red_sandstone");
        IVariant melon = VARIANTS.buildVariant(ItemStack.field_190927_a, "sapturretmod", txPath, "melon");
        VARIANTS.register(melon);
        MELON_VARIANT = melon.getId();
    }

    public static final class MyRAM
    implements ITurretRAM {
        public float barrelLeft = 0.0f;
        public float barrelRight = 0.0f;
        public float prevBarrelLeft = 0.0f;
        public float prevBarrelRight = 0.0f;
        float maxBarrelLeft = 0.0f;
        float maxBarrelRight = 0.0f;
        public boolean isLeftShot = false;
    }
}

