/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.turret;

import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.turretmod.api.TmrConstants;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.turret.ITurretRegistry;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import de.sanandrew.mods.turretmod.item.ItemTurret;
import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import org.apache.logging.log4j.Level;

public final class TurretRegistry
implements ITurretRegistry {
    public static final TurretRegistry INSTANCE = new TurretRegistry();
    private static final ITurret NULL_TYPE = new EmptyTurret();
    private final Map<ResourceLocation, ITurret> turretFromRL = new HashMap<ResourceLocation, ITurret>();
    private final Map<Class<? extends ITurret>, ITurret> turretFromClass = new HashMap<Class<? extends ITurret>, ITurret>();
    private final Collection<ITurret> turrets = Collections.unmodifiableCollection(this.turretFromRL.values());

    private TurretRegistry() {
    }

    @Override
    public Collection<ITurret> getObjects() {
        return this.turrets;
    }

    @Override
    public ITurret getObject(ResourceLocation id) {
        return this.turretFromRL.getOrDefault(id, NULL_TYPE);
    }

    @Override
    public ITurret getType(Class<? extends ITurret> clazz) {
        return this.turretFromClass.getOrDefault(clazz, NULL_TYPE);
    }

    @Override
    public void register(ITurret obj) {
        if (obj == null) {
            TmrConstants.LOG.log(Level.ERROR, "Cannot register NULL as turret!", (Throwable)new InvalidParameterException());
            return;
        }
        if (this.turretFromRL.containsKey(obj.getId())) {
            TmrConstants.LOG.log(Level.ERROR, String.format("The turret %s is already registered!", obj.getId()), (Throwable)new InvalidParameterException());
            return;
        }
        this.turretFromRL.put(obj.getId(), obj);
        this.turretFromClass.put(obj.getClass(), obj);
        ItemRegistry.TURRET_PLACERS.put(obj.getId(), new ItemTurret(obj));
    }

    @Override
    @Nonnull
    public ITurret getDefaultObject() {
        return NULL_TYPE;
    }

    @Override
    @Nonnull
    public ItemStack getItem(ResourceLocation id) {
        if (!this.getObject(id).isValid()) {
            throw new IllegalArgumentException("Cannot get turret item with invalid type!");
        }
        return new ItemStack((Item)ItemRegistry.TURRET_PLACERS.get(id), 1);
    }

    @Override
    @Nonnull
    public ItemStack getItem(ITurretInst turretInst) {
        ItemStack stack = this.getItem(turretInst.getTurret().getId());
        new ItemTurret.TurretStats(turretInst).updateData(stack);
        return stack;
    }

    @Override
    public ITurret getObject(@Nonnull ItemStack stack) {
        if (ItemStackUtils.isValid((ItemStack)stack) && stack.func_77973_b() instanceof ItemTurret) {
            return ((ItemTurret)stack.func_77973_b()).turret;
        }
        return NULL_TYPE;
    }

    private static class EmptyTurret
    implements ITurret {
        private static final AxisAlignedBB BB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

        private EmptyTurret() {
        }

        @Override
        @Nonnull
        public ResourceLocation getId() {
            return new ResourceLocation("null");
        }

        @Override
        public ResourceLocation getStandardTexture(ITurretInst turretInst) {
            return null;
        }

        @Override
        public ResourceLocation getGlowTexture(ITurretInst turretInst) {
            return null;
        }

        @Override
        public SoundEvent getShootSound(ITurretInst turretInst) {
            return null;
        }

        @Override
        public AxisAlignedBB getRangeBB(ITurretInst turretInst) {
            return BB;
        }

        @Override
        public int getTier() {
            return 0;
        }

        @Override
        public float getHealth() {
            return 0.0f;
        }

        @Override
        public int getAmmoCapacity() {
            return 0;
        }

        @Override
        public int getReloadTicks() {
            return 0;
        }

        @Override
        public boolean isValid() {
            return false;
        }
    }
}

