/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.turret;

import de.sanandrew.mods.sanlib.lib.Tuple;
import de.sanandrew.mods.sanlib.lib.util.config.Category;
import de.sanandrew.mods.sanlib.lib.util.config.Range;
import de.sanandrew.mods.sanlib.lib.util.config.Value;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.turret.ITurretRAM;
import de.sanandrew.mods.turretmod.api.turret.IVariant;
import de.sanandrew.mods.turretmod.api.turret.IVariantHolder;
import de.sanandrew.mods.turretmod.registry.EnumEffect;
import de.sanandrew.mods.turretmod.registry.Resources;
import de.sanandrew.mods.turretmod.registry.Sounds;
import de.sanandrew.mods.turretmod.registry.turret.variant.DualItemVariants;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;

@Category(value="shotgun")
public class TurretShotgun
implements ITurret,
IVariantHolder {
    private static final ResourceLocation ID = new ResourceLocation("sapturretmod", "turret_shotgun");
    private static AxisAlignedBB rangeBB;
    @Value(comment="Maximum health this turret has.", range=@Range(minD=0.1, maxD=1024.0), reqWorldRestart=true)
    public static float health;
    @Value(comment="Capacity of ammo rounds this turret can hold.", range=@Range(minI=1, maxI=32767), reqWorldRestart=true)
    public static int ammoCapacity;
    @Value(comment="Maximum tick time between shots. 20 ticks = 1 second.", range=@Range(minI=1), reqWorldRestart=true)
    public static int reloadTicks;
    @Value(comment="Horizontal length of half the edge of the targeting box. The total edge length is [value * 2], with the turret centered in it.", range=@Range(minD=1.0), reqMcRestart=true)
    public static double rangeH;
    @Value(comment="Vertical length of the edge of the targeting box, from the turret upwards.", range=@Range(minD=1.0), reqMcRestart=true)
    public static double rangeU;
    @Value(comment="Vertical length of the edge of the targeting box, from the turret downwards.", range=@Range(minD=1.0), reqMcRestart=true)
    public static double rangeD;
    public static final DualItemVariants VARIANTS;

    @Override
    public void onUpdate(ITurretInst turretInst) {
        EntityLiving turretL = turretInst.get();
        if (turretL.field_70170_p.field_72995_K) {
            MyRAM ram = turretInst.getRAM(MyRAM::new);
            ram.prevBarrelPos = ram.barrelPos;
            ram.barrelPos = ram.barrelPos < 1.0f ? (ram.barrelPos += 1.1999999f / (float)turretInst.getTargetProcessor().getMaxShootTicks()) : 1.0f;
            if (turretInst.wasShooting()) {
                ram.barrelPos = 0.0f;
                EnumEffect.SHOTGUN_SMOKE.addEffect((Entity)turretL, new Tuple(new Object[]{Float.valueOf(turretL.field_70759_as), Float.valueOf(turretL.field_70125_A)}));
            }
        }
    }

    @Override
    public ResourceLocation getStandardTexture(ITurretInst turretInst) {
        return turretInst.getVariant().getTexture();
    }

    @Override
    public ResourceLocation getGlowTexture(ITurretInst turretInst) {
        return Resources.TURRET_T1_SHOTGUN_GLOW.resource;
    }

    @Override
    public AxisAlignedBB getRangeBB(ITurretInst turretInst) {
        if (rangeBB == null) {
            rangeBB = new AxisAlignedBB(-rangeH, -rangeD, -rangeH, rangeH, rangeU, rangeH);
        }
        return rangeBB;
    }

    @Override
    public SoundEvent getShootSound(ITurretInst turretInst) {
        return Sounds.SHOOT_SHOTGUN;
    }

    @Override
    public int getTier() {
        return 1;
    }

    @Override
    public float getHealth() {
        return health;
    }

    @Override
    public int getAmmoCapacity() {
        return ammoCapacity;
    }

    @Override
    public int getReloadTicks() {
        return reloadTicks;
    }

    @Override
    @Nonnull
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public IVariant getVariant(ResourceLocation id) {
        return VARIANTS.getOrDefault(id);
    }

    @Override
    public void registerVariant(IVariant variant) {
        VARIANTS.register(variant);
    }

    @Override
    public boolean isDefaultVariant(IVariant variant) {
        return VARIANTS.isDefaultVariant(variant);
    }

    static {
        health = 20.0f;
        ammoCapacity = 256;
        reloadTicks = 20;
        rangeH = 16.0;
        rangeU = 8.0;
        rangeD = 4.0;
        VARIANTS = new DualItemVariants();
        String txPath = Resources.TURRET_T1_SHOTGUN.resource.func_110623_a();
        for (BlockPlanks.EnumType pType : BlockPlanks.EnumType.values()) {
            int logMeta = pType.func_176839_a();
            ItemStack log = new ItemStack(logMeta < 4 ? Blocks.field_150364_r : Blocks.field_150363_s, 1, logMeta - (logMeta < 4 ? 0 : 4));
            VARIANTS.register(new ItemStack(Blocks.field_150348_b, 1, 0), log, txPath, "stone", pType.func_176610_l());
            for (BlockStoneBrick.EnumType sType : BlockStoneBrick.EnumType.values()) {
                ItemStack brick = new ItemStack(Blocks.field_150417_aV, 1, sType.func_176612_a());
                VARIANTS.register(brick, log, txPath, sType.func_176610_l(), pType.func_176610_l());
            }
        }
    }

    public static class MyRAM
    implements ITurretRAM {
        public float barrelPos = 1.0f;
        public float prevBarrelPos = 1.0f;
    }
}

