/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.turret.forcefield;

import de.sanandrew.mods.sanlib.lib.ColorObj;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.api.turret.IForcefieldProvider;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.turret.ITurretRAM;
import de.sanandrew.mods.turretmod.api.turret.IUpgradeProcessor;
import de.sanandrew.mods.turretmod.api.turret.TurretAttributes;
import de.sanandrew.mods.turretmod.registry.turret.forcefield.ForcefieldRecovery;
import de.sanandrew.mods.turretmod.registry.turret.forcefield.TurretForcefield;
import de.sanandrew.mods.turretmod.registry.upgrades.Upgrades;
import de.sanandrew.mods.turretmod.registry.upgrades.shield.ShieldColorizer;
import de.sanandrew.mods.turretmod.util.TmrUtils;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;

public final class Forcefield
implements ITurretRAM,
IForcefieldProvider {
    static final ColorObj CRIT_COLOR = new ColorObj(0x40FF0000);
    private static final float[] CRIT_CLR_HSL = CRIT_COLOR.calcHSL();
    float value;
    float recovery;
    final ITurretInst turretInst;
    private float prevValue;
    private float attackTime;
    private ColorObj baseColor = new ColorObj(0x40FFFFFF);
    private boolean cullFaces = false;
    private float[] baseColorHsl = this.baseColor.calcHSL();
    private float[] hslDiff = this.getHslDiff();

    Forcefield(ITurretInst turretInst) {
        this.turretInst = turretInst;
        this.prevValue = 0.0f;
        this.value = 0.0f;
        this.attackTime = 0.0f;
        this.recovery = 0.0f;
    }

    public void recalcBaseColor() {
        ShieldColorizer colorizer = (ShieldColorizer)this.turretInst.getUpgradeProcessor().getUpgradeInstance(Upgrades.SHIELD_COLORIZER.getId());
        if (colorizer != null) {
            this.baseColor = new ColorObj(colorizer.getColor());
            this.cullFaces = colorizer.doCullFaces();
        } else {
            this.baseColor = new ColorObj(0x40FFFFFF);
            this.cullFaces = false;
        }
        this.baseColorHsl = this.baseColor.calcHSL();
        this.hslDiff = this.getHslDiff();
    }

    private float[] getHslDiff() {
        return new float[]{MiscUtils.wrap360((float)(this.baseColorHsl[0] - CRIT_CLR_HSL[0])), this.baseColorHsl[1] - CRIT_CLR_HSL[1], this.baseColorHsl[2] - CRIT_CLR_HSL[2]};
    }

    public void damage(float dmg) {
        if (dmg <= 0.0f) {
            return;
        }
        if (this.value < dmg) {
            this.value = 0.0f;
            return;
        }
        this.value -= dmg;
    }

    public float getMaxValue() {
        IUpgradeProcessor upgProc = this.turretInst.getUpgradeProcessor();
        return upgProc.hasUpgrade(Upgrades.SHIELD_STRENGTH_II) ? TurretForcefield.shieldValueThird : (upgProc.hasUpgrade(Upgrades.SHIELD_STRENGTH_I) ? TurretForcefield.shieldValueSecond : TurretForcefield.shieldValueFirst);
    }

    private float getCritValue() {
        return this.getMaxValue() / 10.0f;
    }

    public float getValue() {
        return this.value;
    }

    public boolean isInRecovery() {
        return this.recovery > 0.0f && this.turretInst.isActive();
    }

    public float getRecovery() {
        return this.recovery;
    }

    @Override
    public boolean isShieldActive() {
        return this.value > 0.0f && this.turretInst.isActive();
    }

    @Override
    public AxisAlignedBB getShieldBoundingBox() {
        return this.turretInst.getRangeBB();
    }

    @Override
    public int getShieldColor() {
        float critVal = this.getCritValue();
        if (this.value < critVal) {
            return this.getCritColor(this.value / critVal);
        }
        return MathHelper.func_76141_d((float)Math.max((float)this.baseColor.alpha(), 64.0f * this.attackTime)) << 24 | this.baseColor.getColorInt() & 0xFFFFFF;
    }

    @Override
    public boolean cullShieldFaces() {
        return this.cullFaces;
    }

    void onTick() {
        if (this.attackTime > 0.0f) {
            this.attackTime -= 0.1f;
        }
        if (this.prevValue > this.value) {
            this.attackTime = 1.0f;
        }
        this.prevValue = this.value;
        float maxVal = this.getMaxValue();
        if (this.turretInst.isActive() && this.turretInst.getTargetProcessor().hasAmmo() && this.value < maxVal) {
            double speedMulti = this.turretInst.get().func_110148_a(TurretAttributes.MAX_RELOAD_TICKS).func_111126_e();
            if (this.value <= 0.0f) {
                int prevRecoveryPerc = MathHelper.func_76141_d((float)(this.recovery * 100.0f));
                this.recovery = (float)((double)this.recovery + (double)TurretForcefield.shieldRecoveryPerTick * (2.0 - speedMulti));
                if (prevRecoveryPerc != MathHelper.func_76141_d((float)(this.recovery * 100.0f))) {
                    this.turretInst.getTargetProcessor().decrAmmo();
                }
            } else if ((long)this.turretInst.get().field_70173_aa % Math.round(40.0 * speedMulti) == 0L) {
                this.value += 1.0f;
                if (this.value > maxVal) {
                    this.value = maxVal;
                }
                this.turretInst.getTargetProcessor().decrAmmo();
            }
        }
        if (this.recovery >= 1.0f) {
            this.value = TurretForcefield.maxShieldRecoveryValue;
            this.recovery = 0.0f;
        }
        if (this.value > maxVal) {
            this.value = maxVal;
        }
        if (this.turretInst.get().field_70170_p.field_72995_K) {
            if (this.isInRecovery() && !TmrUtils.INSTANCE.hasForcefield((Entity)this.turretInst.get(), ForcefieldRecovery.class)) {
                TmrUtils.INSTANCE.addForcefield((Entity)this.turretInst.get(), new ForcefieldRecovery(this));
            }
            if (this.isShieldActive() && !TmrUtils.INSTANCE.hasForcefield((Entity)this.turretInst.get(), this.getClass())) {
                TmrUtils.INSTANCE.addForcefield((Entity)this.turretInst.get(), this);
            }
        }
    }

    int getCritColor(float relation) {
        float alpha = CRIT_COLOR.fAlpha() + (this.baseColor.fAlpha() - CRIT_COLOR.fAlpha()) * relation;
        float[] hslDif = (float[])this.hslDiff.clone();
        hslDif[0] = MiscUtils.wrap360((float)(CRIT_CLR_HSL[0] + (hslDif[0] > 180.0f ? -(360.0f - hslDif[0]) : hslDif[0]) * relation));
        hslDif[1] = CRIT_CLR_HSL[1] + hslDif[1] * relation;
        hslDif[2] = CRIT_CLR_HSL[2] + hslDif[2] * relation;
        return ColorObj.fromHSLA((float)hslDif[0], (float)hslDif[1], (float)hslDif[2], (float)alpha).getColorInt();
    }
}

