/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.turret.forcefield;

import de.sanandrew.mods.turretmod.api.turret.ITargetProcessor;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.registry.EnumEffect;
import de.sanandrew.mods.turretmod.registry.turret.forcefield.Forcefield;
import de.sanandrew.mods.turretmod.registry.turret.forcefield.TurretForcefield;
import de.sanandrew.mods.turretmod.registry.upgrades.Upgrades;
import de.sanandrew.mods.turretmod.util.TmrUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityLlamaSpit;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;

public class ForcefieldHandler {
    public static final List<Function<Entity, Entity>> PROJ_GET_OWNER = new ArrayList<Function<Entity, Entity>>();
    private static final WeakHashMap<ITurretInst, WeakHashMap<Entity, Integer>> ALREADY_PUSHED = new WeakHashMap();

    public static void onTargeting(ITurretInst turretInst, ITargetProcessor processor) {
        Forcefield shield = (Forcefield)turretInst.getRAM(null);
        EntityLiving turretL = turretInst.get();
        boolean hasPushed = false;
        ArrayList<Entity> recognizedEntities = new ArrayList<Entity>();
        if (processor.canShoot()) {
            if (shield != null && shield.getValue() > 0.0f) {
                for (Entity target : processor.getValidTargetList()) {
                    double dZ;
                    double dY;
                    double dX;
                    if (ForcefieldHandler.knockBackEntity(turretInst, target, dX = turretInst.get().field_70165_t - target.field_70165_t, dY = turretInst.get().field_70163_u - target.field_70163_u, dZ = turretInst.get().field_70161_v - target.field_70161_v)) {
                        if (target instanceof EntityCreature) {
                            TmrUtils.INSTANCE.setEntityTarget((EntityCreature)target, processor.getTurretInst());
                        }
                        hasPushed = true;
                        shield.damage(TurretForcefield.shieldDamagePerEntity);
                        turretInst.updateState();
                        if (shield.getValue() <= 0.0f) break;
                    }
                    recognizedEntities.add(target);
                }
            }
            if (shield != null && shield.getValue() > 0.0f && turretInst.getUpgradeProcessor().hasUpgrade(Upgrades.SHIELD_PROJECTILE)) {
                for (Entity projectile : turretL.field_70170_p.func_72872_a(Entity.class, processor.getAdjustedRange(true))) {
                    Optional<Entity> opOwner = PROJ_GET_OWNER.stream().map(func -> (Entity)func.apply(projectile)).filter(owner -> owner != null && processor.isEntityTargeted((Entity)owner)).findFirst();
                    if (!opOwner.isPresent()) continue;
                    if (ForcefieldHandler.knockBackProjectile(turretInst, projectile)) {
                        Entity owner2 = opOwner.get();
                        if (owner2 instanceof EntityCreature) {
                            TmrUtils.INSTANCE.setEntityTarget((EntityCreature)owner2, processor.getTurretInst());
                        }
                        hasPushed = true;
                        shield.damage(TurretForcefield.shieldDamagePerProjectile);
                        turretInst.updateState();
                        if (shield.getValue() <= 0.0f) break;
                    }
                    recognizedEntities.add(projectile);
                }
            }
        }
        if (recognizedEntities.size() > 0) {
            if (hasPushed) {
                processor.setShot(true);
                processor.getTurretInst().updateState();
            } else if (!processor.isShooting()) {
                processor.decrInitShootTicks();
            }
        } else {
            processor.resetInitShootTicks();
        }
        if (ALREADY_PUSHED.containsKey(turretInst)) {
            ALREADY_PUSHED.get(turretInst).entrySet().removeIf(entry -> entry.getKey() == null || (Integer)entry.getValue() < turretInst.get().field_70173_aa || !recognizedEntities.contains(entry.getKey()));
        }
        ALREADY_PUSHED.entrySet().removeIf(entry -> entry.getKey() == null || ((WeakHashMap)entry.getValue()).isEmpty());
    }

    public static void onExplosion(ITurretInst turretInst, AxisAlignedBB explosionBB, List<BlockPos> blocksAffected, List<Entity> entitiesAffected) {
        AxisAlignedBB turretBB = turretInst.getTargetProcessor().getAdjustedRange(true);
        if (turretBB.func_72326_a(explosionBB)) {
            blocksAffected.removeIf(blockPos -> {
                Forcefield shield;
                if (turretInst.get().field_70170_p.func_180495_p(blockPos).func_185904_a() != Material.field_151579_a && turretBB.func_72326_a(new AxisAlignedBB(blockPos)) && (shield = (Forcefield)turretInst.getRAM(null)) != null && shield.isShieldActive()) {
                    shield.damage(TurretForcefield.shieldDamagePerExplodedBlock);
                    return true;
                }
                return false;
            });
            entitiesAffected.removeIf(entity -> {
                Forcefield shield;
                if (turretBB.func_72326_a(entity.func_174813_aQ()) && !turretInst.getTargetProcessor().isEntityTargeted((Entity)entity) && (shield = (Forcefield)turretInst.getRAM(null)) != null && shield.isShieldActive()) {
                    shield.damage(TurretForcefield.shieldDamagePerExplodedEntity);
                    return true;
                }
                return false;
            });
            turretInst.updateState();
        }
    }

    private static boolean knockBackProjectile(ITurretInst turretInst, Entity projectile) {
        int ticksPushed = ALREADY_PUSHED.containsKey(turretInst) ? ALREADY_PUSHED.get(turretInst).getOrDefault(projectile, -1) : -1;
        boolean hasPushed = false;
        if (ticksPushed < 0) {
            projectile.field_70127_C = 0.0f;
            projectile.field_70126_B = 0.0f;
            projectile.func_70016_h(-projectile.field_70159_w, projectile.field_70181_x, -projectile.field_70179_y);
            projectile.field_70133_I = true;
            ALREADY_PUSHED.computeIfAbsent(turretInst, inst -> new WeakHashMap()).put(projectile, turretInst.get().field_70173_aa + 20);
            hasPushed = true;
        } else if (ticksPushed < turretInst.get().field_70173_aa) {
            projectile.func_70106_y();
            EnumEffect.PROJECTILE_DEATH.addEffect(projectile);
            hasPushed = true;
        }
        return hasPushed;
    }

    private static boolean knockBackEntity(ITurretInst turretInst, Entity entity, double xRatio, double yRatio, double zRatio) {
        boolean hasBeenPushed;
        float strength = 1.0f;
        boolean bl = hasBeenPushed = ALREADY_PUSHED.containsKey(turretInst) && ALREADY_PUSHED.get(turretInst).getOrDefault(entity, -1) > turretInst.get().field_70173_aa;
        if (hasBeenPushed) {
            return false;
        }
        entity.field_70160_al = true;
        double avgRatio = Math.sqrt(xRatio * xRatio + yRatio * yRatio + zRatio * zRatio) * 1.0;
        entity.field_70181_x /= 2.0;
        entity.field_70159_w = -xRatio / avgRatio * 1.0;
        entity.field_70181_x = Math.abs(yRatio) < (double)0.1f ? 0.4 : -yRatio * 2.0 / avgRatio * 1.0;
        entity.field_70179_y = -zRatio / avgRatio * 1.0;
        if (entity.field_70122_E) {
            entity.field_70181_x /= 2.0;
            entity.field_70181_x += 1.0;
            if (entity.field_70181_x > 0.4) {
                entity.field_70181_x = 0.4;
            }
        }
        if (entity.field_70170_p instanceof WorldServer) {
            ((WorldServer)entity.field_70170_p).func_73039_n().func_151247_a((Entity)turretInst.get(), (Packet)new SPacketEntityVelocity(entity));
        }
        ALREADY_PUSHED.computeIfAbsent(turretInst, inst -> new WeakHashMap()).put(entity, turretInst.get().field_70173_aa + 20);
        return true;
    }

    static {
        PROJ_GET_OWNER.add(proj -> {
            if (proj instanceof EntityArrow) {
                return ((EntityArrow)proj).field_70250_c;
            }
            if (proj instanceof EntityThrowable) {
                return ((EntityThrowable)proj).func_85052_h();
            }
            if (proj instanceof EntityLlamaSpit) {
                return ((EntityLlamaSpit)proj).field_190539_a;
            }
            if (proj instanceof EntityFireball) {
                return ((EntityFireball)proj).field_70235_a;
            }
            return null;
        });
    }
}

