/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.turret.forcefield;

import de.sanandrew.mods.sanlib.lib.util.config.Category;
import de.sanandrew.mods.sanlib.lib.util.config.Range;
import de.sanandrew.mods.sanlib.lib.util.config.Value;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.turret.IUpgradeProcessor;
import de.sanandrew.mods.turretmod.api.turret.TurretAttributes;
import de.sanandrew.mods.turretmod.registry.Resources;
import de.sanandrew.mods.turretmod.registry.turret.forcefield.Forcefield;
import de.sanandrew.mods.turretmod.registry.upgrades.Upgrades;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;

@Category(value="forcefield")
public class TurretForcefield
implements ITurret {
    private static final ResourceLocation ID = new ResourceLocation("sapturretmod", "turret_forcefield");
    private static AxisAlignedBB rangeBB1;
    private static AxisAlignedBB rangeBB2;
    private static AxisAlignedBB rangeBB3;
    @Value(comment="Maximum health this turret has.", range=@Range(minD=0.1, maxD=1024.0), reqWorldRestart=true)
    public static float health;
    @Value(comment="Capacity of ammo rounds this turret can hold.", range=@Range(minI=1, maxI=32767), reqWorldRestart=true)
    public static int ammoCapacity;
    @Value(comment="Maximum tick time between shots. 20 ticks = 1 second.", range=@Range(minI=1), reqWorldRestart=true)
    public static int reloadTicks;
    @Value(comment="Horizontal length of half the edge of the targeting box without upgrades. The total edge length is [value * 2], with the turret centered in it.", range=@Range(minD=1.0), reqMcRestart=true)
    public static double rangeFirstH;
    @Value(comment="Vertical length of the edge of the targeting box without upgrades, from the turret upwards.", range=@Range(minD=1.0), reqMcRestart=true)
    public static double rangeFirstU;
    @Value(comment="Vertical length of the edge of the targeting box without upgrades, from the turret downwards.", range=@Range(minD=1.0), reqMcRestart=true)
    public static double rangeFirstD;
    @Value(comment="Horizontal length of half the edge of the targeting box with shield strength 1 upgrade. The total edge length is [value * 2], with the turret centered in it.", range=@Range(minD=1.0), reqMcRestart=true)
    public static double rangeSecondH;
    @Value(comment="Vertical length of the edge of the targeting box with shield strength 1 upgrade, from the turret upwards.", range=@Range(minD=1.0), reqMcRestart=true)
    public static double rangeSecondU;
    @Value(comment="Vertical length of the edge of the targeting box with shield strength 1 upgrade, from the turret downwards.", range=@Range(minD=1.0), reqMcRestart=true)
    public static double rangeSecondD;
    @Value(comment="Horizontal length of half the edge of the targeting box with shield strength 2 upgrade. The total edge length is [value * 2], with the turret centered in it.", range=@Range(minD=1.0), reqMcRestart=true)
    public static double rangeThirdH;
    @Value(comment="Vertical length of the edge of the targeting box with shield strength 2 upgrade, from the turret upwards.", range=@Range(minD=1.0), reqMcRestart=true)
    public static double rangeThirdU;
    @Value(comment="Vertical length of the edge of the targeting box with shield strength 2 upgrade, from the turret downwards.", range=@Range(minD=1.0), reqMcRestart=true)
    public static double rangeThirdD;
    @Value(comment="How much damage does the shield take when pushing out enemies.", range=@Range(minD=0.0))
    public static float shieldDamagePerEntity;
    @Value(comment="How much damage does the shield take when pushing out enemy projectiles.", range=@Range(minD=0.0))
    public static float shieldDamagePerProjectile;
    @Value(comment="How much damage does the shield take when protecting a block by enemy explosions.", range=@Range(minD=0.0))
    public static float shieldDamagePerExplodedBlock;
    @Value(comment="How much damage does the shield take when protecting an entity by enemy explosions.", range=@Range(minD=0.0))
    public static float shieldDamagePerExplodedEntity;
    @Value(comment="To which value a destroyed shield needs to recover to in order to re-activate.", range=@Range(minD=0.0))
    public static float maxShieldRecoveryValue;
    @Value(comment="How much a shield regenerates every tick. 20 ticks = 1 second.", range=@Range(minD=0.0))
    public static float shieldRecoveryPerTick;
    @Value(comment="Value of the shield without upgrades.", range=@Range(minD=0.0), reqMcRestart=true)
    public static float shieldValueFirst;
    @Value(comment="Value of the shield with shield strength 1 upgrade.", range=@Range(minD=0.0), reqMcRestart=true)
    public static float shieldValueSecond;
    @Value(comment="Value of the shield with shield strength 2 upgrade.", range=@Range(minD=0.0), reqMcRestart=true)
    public static float shieldValueThird;

    @Override
    public void applyEntityAttributes(ITurretInst turretInst) {
        turretInst.get().func_110148_a(TurretAttributes.MAX_INIT_SHOOT_TICKS).func_111128_a(0.0);
    }

    @Override
    public void onUpdate(ITurretInst turretInst) {
        Forcefield shield = turretInst.getRAM(() -> new Forcefield(turretInst));
        shield.onTick();
    }

    @Override
    public void writeSpawnData(ITurretInst turretInst, ByteBuf buf) {
        Forcefield shield = turretInst.getRAM(() -> new Forcefield(turretInst));
        buf.writeFloat(shield.value);
        buf.writeFloat(shield.recovery);
    }

    @Override
    public void readSpawnData(ITurretInst turretInst, ByteBuf buf) {
        Forcefield shield = turretInst.getRAM(() -> new Forcefield(turretInst));
        shield.value = buf.readFloat();
        shield.recovery = buf.readFloat();
    }

    @Override
    public void writeSyncData(ITurretInst turretInst, ObjectOutputStream stream) throws IOException {
        Forcefield shield = turretInst.getRAM(() -> new Forcefield(turretInst));
        stream.writeFloat(shield.value);
        stream.writeFloat(shield.recovery);
    }

    @Override
    public void readSyncData(ITurretInst turretInst, ObjectInputStream stream) throws IOException {
        Forcefield shield = turretInst.getRAM(() -> new Forcefield(turretInst));
        shield.value = stream.readFloat();
        shield.recovery = stream.readFloat();
    }

    @Override
    public void onSave(ITurretInst turretInst, NBTTagCompound nbt) {
        Forcefield shield = turretInst.getRAM(() -> new Forcefield(turretInst));
        nbt.func_74776_a("shieldValue", shield.value);
        nbt.func_74776_a("shieldRecovery", shield.recovery);
    }

    @Override
    public void onLoad(ITurretInst turretInst, NBTTagCompound nbt) {
        Forcefield shield = turretInst.getRAM(() -> new Forcefield(turretInst));
        shield.value = nbt.func_74760_g("shieldValue");
        shield.recovery = nbt.func_74760_g("shieldRecovery");
    }

    @Override
    public ResourceLocation getStandardTexture(ITurretInst turretInst) {
        return Resources.TURRET_T2_FORCEFIELD.resource;
    }

    @Override
    public ResourceLocation getGlowTexture(ITurretInst turretInst) {
        return Resources.TURRET_T2_FORCEFIELD_GLOW.resource;
    }

    @Override
    public AxisAlignedBB getRangeBB(ITurretInst turretInst) {
        if (rangeBB1 == null) {
            rangeBB1 = new AxisAlignedBB(-rangeFirstH, -rangeFirstD, -rangeFirstH, rangeFirstH, rangeFirstU, rangeFirstH);
        }
        if (rangeBB2 == null) {
            rangeBB2 = new AxisAlignedBB(-rangeSecondH, -rangeSecondD, -rangeSecondH, rangeSecondH, rangeSecondU, rangeSecondH);
        }
        if (rangeBB3 == null) {
            rangeBB3 = new AxisAlignedBB(-rangeThirdH, -rangeThirdD, -rangeThirdH, rangeThirdH, rangeThirdU, rangeThirdH);
        }
        if (turretInst == null) {
            return rangeBB1;
        }
        IUpgradeProcessor upgProc = turretInst.getUpgradeProcessor();
        return upgProc.hasUpgrade(Upgrades.SHIELD_STRENGTH_II) ? rangeBB3 : (upgProc.hasUpgrade(Upgrades.SHIELD_STRENGTH_I) ? rangeBB2 : rangeBB1);
    }

    @Override
    public SoundEvent getShootSound(ITurretInst turretInst) {
        return null;
    }

    @Override
    public int getTier() {
        return 2;
    }

    @Override
    public boolean canSeeThroughBlocks() {
        return true;
    }

    @Override
    public float getDeactiveHeadPitch() {
        return 0.0f;
    }

    @Override
    public float getHealth() {
        return health;
    }

    @Override
    public int getAmmoCapacity() {
        return ammoCapacity;
    }

    @Override
    public int getReloadTicks() {
        return reloadTicks;
    }

    @Override
    public ITurret.AttackType getAttackType() {
        return ITurret.AttackType.ALL;
    }

    @Override
    @Nonnull
    public ResourceLocation getId() {
        return ID;
    }

    static {
        health = 30.0f;
        ammoCapacity = 512;
        reloadTicks = 1;
        rangeFirstH = 8.0;
        rangeFirstU = 8.0;
        rangeFirstD = 2.0;
        rangeSecondH = 16.0;
        rangeSecondU = 16.0;
        rangeSecondD = 2.0;
        rangeThirdH = 24.0;
        rangeThirdU = 24.0;
        rangeThirdD = 2.0;
        shieldDamagePerEntity = 1.0f;
        shieldDamagePerProjectile = 0.5f;
        shieldDamagePerExplodedBlock = 0.5f;
        shieldDamagePerExplodedEntity = 1.0f;
        maxShieldRecoveryValue = 100.0f;
        shieldRecoveryPerTick = 5.0E-4f;
        shieldValueFirst = 100.0f;
        shieldValueSecond = 150.0f;
        shieldValueThird = 250.0f;
    }
}

