/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.turret.variant;

import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import de.sanandrew.mods.sanlib.lib.util.LangUtils;
import de.sanandrew.mods.turretmod.api.turret.IVariant;
import de.sanandrew.mods.turretmod.registry.turret.variant.VariantContainer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class DualItemVariants
extends VariantContainer.ItemVariants<Table<Long, Long, IVariant>> {
    @Override
    public Table<Long, Long, IVariant> buildVariantMap() {
        return TreeBasedTable.create();
    }

    public void register(ItemStack base, ItemStack frame, String textureBase, String baseName, String frameName) {
        IVariant variant = this.buildVariant(base, frame, "sapturretmod", textureBase, baseName, frameName);
        super.register(variant);
        ((Table)this.variantMap).put((Object)this.getIdFromStack(base), (Object)this.getIdFromStack(frame), (Object)variant);
    }

    public IVariant get(ItemStack base, ItemStack frame) {
        return this.get(this.getIdFromStack(base), this.getIdFromStack(frame));
    }

    @Override
    public IVariant get(IInventory inv) {
        long base = -2L;
        long frame = -2L;
        int max = inv.func_70302_i_();
        for (int i = 0; i < max; ++i) {
            ItemStack slotStack = inv.func_70301_a(i);
            if (base != -1L) {
                base = this.checkType(base, this.getBaseId(slotStack));
            }
            if (frame != -1L) {
                frame = this.checkType(frame, this.getFrameId(slotStack));
            }
            if (base == -1L && frame == -1L) break;
        }
        return this.get(Math.max(base, 0L), Math.max(frame, 0L));
    }

    public IVariant get(long baseHash, long frameHash) {
        return (IVariant)((Table)this.variantMap).get((Object)baseHash, (Object)frameHash);
    }

    @Override
    public long checkType(long currType, long newType) {
        if (currType >= 0L && newType >= 0L && currType != newType) {
            return -1L;
        }
        return newType >= 0L ? newType : currType;
    }

    protected long getBaseId(ItemStack stack) {
        long id = this.getIdFromStack(stack);
        if (((Table)this.variantMap).containsRow((Object)id)) {
            return id;
        }
        return -1L;
    }

    protected long getFrameId(ItemStack stack) {
        long id = this.getIdFromStack(stack);
        if (((Table)this.variantMap).containsColumn((Object)id)) {
            return id;
        }
        return -1L;
    }

    public IVariant buildVariant(final ItemStack base, final ItemStack frame, String modId, String textureBase, String baseName, String frameName) {
        ResourceLocation id = new ResourceLocation(modId, String.format("%s_%s", baseName, frameName));
        ResourceLocation texture = new ResourceLocation(modId, String.format(textureBase, baseName, frameName));
        return new VariantContainer.Variant(id, texture){
            private final String langKeyBase;
            private final String langKeyFrame;
            {
                super(id, texture);
                this.langKeyBase = base.func_77977_a() + ".name";
                this.langKeyFrame = frame.func_77977_a() + ".name";
            }

            @Override
            public String getTranslatedName() {
                return String.format("%s / %s", LangUtils.translate((String)this.langKeyBase, (Object[])new Object[0]), LangUtils.translate((String)this.langKeyFrame, (Object[])new Object[0]));
            }
        };
    }
}

