/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.turret.variant;

import de.sanandrew.mods.sanlib.lib.util.LangUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.api.turret.IVariant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class VariantContainer {
    private IVariant defaultVariant;
    final Map<ResourceLocation, IVariant> variants = new HashMap<ResourceLocation, IVariant>();

    public void register(IVariant variant) {
        this.variants.put(variant.getId(), variant);
        if (this.defaultVariant == null) {
            this.defaultVariant = variant;
        }
    }

    public IVariant get(ResourceLocation id) {
        return this.variants.get(id);
    }

    public IVariant getOrDefault(ResourceLocation id) {
        return (IVariant)MiscUtils.defIfNull((Object)this.variants.get(id), (Object)this.defaultVariant);
    }

    public boolean isDefaultVariant(IVariant variant) {
        return variant == null || this.defaultVariant.getId().equals((Object)variant.getId());
    }

    public static abstract class ItemVariants<T>
    extends VariantContainer {
        public final T variantMap = this.buildVariantMap();

        public abstract T buildVariantMap();

        public abstract IVariant get(IInventory var1);

        protected long getIdFromStack(ItemStack stack) {
            return (long)(stack.func_77960_j() & Integer.MAX_VALUE) << 32 | (long)Objects.hashCode(stack.func_77973_b());
        }

        public long checkType(long currType, long newType) {
            if (currType >= 0L && newType >= 0L && currType != newType) {
                return -1L;
            }
            return newType >= 0L ? newType : currType;
        }
    }

    public static class Variant
    implements IVariant {
        private final ResourceLocation id;
        private final ResourceLocation texture;

        Variant(ResourceLocation id, ResourceLocation texture) {
            this.id = id;
            this.texture = texture;
        }

        @Override
        public ResourceLocation getId() {
            return this.id;
        }

        @Override
        public ResourceLocation getTexture() {
            return this.texture;
        }

        @Override
        public String getTranslatedName() {
            return LangUtils.translate((String)String.format("turret_variant.%s", this.id.toString()), (Object[])new Object[0]);
        }
    }
}

