/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.upgrades;

import de.sanandrew.mods.sanlib.lib.util.EntityUtils;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.upgrade.IUpgrade;
import de.sanandrew.mods.turretmod.registry.upgrades.Upgrades;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.Range;

public abstract class Health
implements IUpgrade {
    private final ResourceLocation id;
    private final AttributeModifier modifier;

    Health(String name, String modUUID) {
        this.modifier = new AttributeModifier(UUID.fromString(modUUID), String.format("%s:%s", "sapturretmod", name), 0.25, 1);
        this.id = new ResourceLocation("sapturretmod", "upgrade_" + name);
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public void initialize(ITurretInst turretInst, ItemStack stack) {
        if (!turretInst.get().field_70170_p.field_72995_K) {
            EntityUtils.tryRemoveModifier((EntityLivingBase)turretInst.get(), (IAttribute)SharedMonsterAttributes.field_111267_a, (AttributeModifier)this.modifier);
            EntityUtils.tryApplyModifier((EntityLivingBase)turretInst.get(), (IAttribute)SharedMonsterAttributes.field_111267_a, (AttributeModifier)this.modifier);
        }
    }

    @Override
    public void terminate(ITurretInst turretInst, ItemStack stack) {
        if (!turretInst.get().field_70170_p.field_72995_K && EntityUtils.tryRemoveModifier((EntityLivingBase)turretInst.get(), (IAttribute)SharedMonsterAttributes.field_111267_a, (AttributeModifier)this.modifier)) {
            turretInst.get().func_70606_j(turretInst.get().func_110143_aJ());
        }
    }

    static class MK4
    extends Health {
        MK4() {
            super("health_4", "9431A60C-B995-4547-B143-2BEDC67467E1");
        }

        @Override
        public IUpgrade getDependantOn() {
            return Upgrades.HEALTH_III;
        }

        @Override
        @Nullable
        public Range<Integer> getTierRange() {
            return Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3));
        }
    }

    static class MK3
    extends Health {
        MK3() {
            super("health_3", "D49F43AE-5EA4-4DD2-B08A-9B5F1966C091");
        }

        @Override
        public IUpgrade getDependantOn() {
            return Upgrades.HEALTH_II;
        }

        @Override
        @Nullable
        public Range<Integer> getTierRange() {
            return Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(4));
        }
    }

    static class MK2
    extends Health {
        MK2() {
            super("health_2", "B7E5ADFA-517C-4167-A2FD-E0D31FA6E9BE");
        }

        @Override
        public IUpgrade getDependantOn() {
            return Upgrades.HEALTH_I;
        }
    }

    static class MK1
    extends Health {
        MK1() {
            super("health_1", "673176FC-51F9-4CBC-BA12-5073B6867644");
        }
    }
}

