/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.upgrades;

import de.sanandrew.mods.sanlib.lib.util.EntityUtils;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.turret.TurretAttributes;
import de.sanandrew.mods.turretmod.api.upgrade.IUpgrade;
import de.sanandrew.mods.turretmod.registry.upgrades.Upgrades;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public abstract class ReloadTime
implements IUpgrade {
    private final ResourceLocation id;
    private final AttributeModifier modifier;

    ReloadTime(String name, String modUUID, double value) {
        this.modifier = new AttributeModifier(UUID.fromString(modUUID), String.format("%s:%s", "sapturretmod", name), value, 1);
        this.id = new ResourceLocation("sapturretmod", "upgrade_" + name);
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public void initialize(ITurretInst turretInst, ItemStack stack) {
        if (!turretInst.get().field_70170_p.field_72995_K) {
            EntityUtils.tryRemoveModifier((EntityLivingBase)turretInst.get(), (IAttribute)TurretAttributes.MAX_RELOAD_TICKS, (AttributeModifier)this.modifier);
            EntityUtils.tryApplyModifier((EntityLivingBase)turretInst.get(), (IAttribute)TurretAttributes.MAX_RELOAD_TICKS, (AttributeModifier)this.modifier);
        }
    }

    @Override
    public void terminate(ITurretInst turretInst, ItemStack stack) {
        if (!turretInst.get().field_70170_p.field_72995_K) {
            EntityUtils.tryRemoveModifier((EntityLivingBase)turretInst.get(), (IAttribute)TurretAttributes.MAX_RELOAD_TICKS, (AttributeModifier)this.modifier);
        }
    }

    static class MK2
    extends ReloadTime {
        MK2() {
            super("reload_2", "BA6FE867-0EBF-4E1A-9ED9-05E2B47143F8", -0.35);
        }

        @Override
        public IUpgrade getDependantOn() {
            return Upgrades.RELOAD_I;
        }
    }

    static class MK1
    extends ReloadTime {
        MK1() {
            super("reload_1", "E6DAE7D4-A730-4F57-B3F9-61C369033625", -0.15);
        }
    }
}

