/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.upgrades;

import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.upgrade.IUpgrade;
import de.sanandrew.mods.turretmod.api.upgrade.IUpgradeRegistry;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import de.sanandrew.mods.turretmod.item.ItemUpgrade;
import de.sanandrew.mods.turretmod.network.PacketRegistry;
import de.sanandrew.mods.turretmod.network.PacketSyncUpgradeInst;
import de.sanandrew.mods.turretmod.registry.upgrades.SimpleUpgrade;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.Range;

public final class UpgradeRegistry
implements IUpgradeRegistry {
    public static final UpgradeRegistry INSTANCE = new UpgradeRegistry();
    public static final IUpgrade EMPTY_UPGRADE = new EmptyUpgrade();
    private static final IUpgrade NULL_TYPE;
    private Map<ResourceLocation, IUpgrade> upgradeFromRL = new HashMap<ResourceLocation, IUpgrade>();
    private Collection<IUpgrade> upgrades = Collections.unmodifiableCollection(this.upgradeFromRL.values());

    private UpgradeRegistry() {
    }

    @Override
    public void register(IUpgrade obj) {
        this.upgradeFromRL.put(obj.getId(), obj);
        ItemRegistry.TURRET_UPGRADES.put(obj.getId(), new ItemUpgrade(obj));
    }

    @Override
    @Nonnull
    public IUpgrade getDefaultObject() {
        return NULL_TYPE;
    }

    @Override
    public IUpgrade getObject(ResourceLocation id) {
        return this.upgradeFromRL.getOrDefault(id, NULL_TYPE);
    }

    @Override
    public IUpgrade getObject(@Nonnull ItemStack stack) {
        if (!ItemStackUtils.isValid((ItemStack)stack) || !(stack.func_77973_b() instanceof ItemUpgrade)) {
            return NULL_TYPE;
        }
        return ((ItemUpgrade)stack.func_77973_b()).upgrade;
    }

    @Override
    public boolean isType(@Nonnull ItemStack stack, ResourceLocation id) {
        IUpgrade itmType = this.getObject(stack);
        return itmType.isValid() && itmType.getId().equals((Object)id);
    }

    @Override
    public boolean isType(@Nonnull ItemStack stack, IUpgrade obj) {
        IUpgrade itmType = this.getObject(stack);
        return obj.isValid() && itmType.isValid() && itmType.getId().equals((Object)obj.getId());
    }

    @Override
    public Collection<IUpgrade> getObjects() {
        return this.upgrades;
    }

    @Override
    @Nonnull
    public ItemStack getItem(ResourceLocation id) {
        if (!this.getObject(id).isValid()) {
            throw new IllegalArgumentException("Cannot get upgrade item with invalid type!");
        }
        return new ItemStack((Item)ItemRegistry.TURRET_UPGRADES.get(id), 1);
    }

    @Override
    public void syncWithServer(ITurretInst turretInst, ResourceLocation id) {
        PacketRegistry.sendToServer((IMessage)new PacketSyncUpgradeInst(turretInst, id));
    }

    @Override
    public void syncWithClients(ITurretInst turretInst, ResourceLocation id) {
        EntityLiving turretL = turretInst.get();
        if (!turretL.field_70170_p.field_72995_K) {
            PacketRegistry.sendToAllAround((IMessage)new PacketSyncUpgradeInst(turretInst, id), turretL.field_70170_p.field_73011_w.getDimension(), turretL.field_70165_t, turretL.field_70163_u, turretL.field_70161_v, 64.0);
        }
    }

    @Override
    public IUpgrade getEmptyUpgrade() {
        return EMPTY_UPGRADE;
    }

    @Override
    public boolean isApplicable(IUpgrade upgrade, ITurret turret) {
        return this.isApplicable(upgrade, turret, false);
    }

    @Override
    public boolean isApplicable(IUpgrade upgrade, ITurret turret, boolean isSpecialized) {
        boolean isEmpty;
        if (!upgrade.isValid()) {
            return false;
        }
        ITurret[] applicables = upgrade.getApplicableTurrets();
        boolean bl = isEmpty = applicables == null || applicables.length == 0;
        if (isSpecialized && isEmpty) {
            return false;
        }
        Range<Integer> tierRange = upgrade.getTierRange();
        if (tierRange != null && !tierRange.contains((Object)turret.getTier())) {
            return false;
        }
        return isEmpty || Arrays.asList(applicables).contains(turret);
    }

    static {
        INSTANCE.register(EMPTY_UPGRADE);
        NULL_TYPE = new SimpleUpgrade("null", new ITurret[0]){

            @Override
            public boolean isValid() {
                return false;
            }
        };
    }

    static final class EmptyUpgrade
    implements IUpgrade {
        private static final ResourceLocation ID = new ResourceLocation("sapturretmod", "upgrade_empty");

        EmptyUpgrade() {
        }

        @Override
        public ResourceLocation getId() {
            return ID;
        }

        @Override
        public Range<Integer> getTierRange() {
            return Range.is((Comparable)Integer.valueOf(-1));
        }
    }
}

