/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.upgrades.leveling;

import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.sanlib.lib.util.config.Category;
import de.sanandrew.mods.sanlib.lib.util.config.Init;
import de.sanandrew.mods.sanlib.lib.util.config.Value;
import de.sanandrew.mods.turretmod.api.TmrConstants;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.upgrade.IUpgradeInstance;
import de.sanandrew.mods.turretmod.registry.upgrades.UpgradeRegistry;
import de.sanandrew.mods.turretmod.registry.upgrades.leveling.Leveling;
import de.sanandrew.mods.turretmod.registry.upgrades.leveling.Stage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.logging.log4j.Level;

@IUpgradeInstance.Tickable
@Category(value="Leveling")
public class LevelStorage
implements IUpgradeInstance<LevelStorage> {
    @Value(comment="The maximum XP a turret can gain through the Leveling upgrade. The default is 50 levels worth; see https://minecraft.gamepedia.com/Experience#Leveling_up")
    public static int maxXp = 5345;
    @Value(value="stages", comment="A JSON array defining the level stages which are applied once a turret levels up to a stage level.", reqWorldRestart=true)
    private static String[] stagesJson = LevelStorage.getDefaultStages();
    private static Stage[] stages = new Stage[0];
    int xp;
    private int prevXp;
    private int prevLvl;
    private int cachedLevel;
    private Stage currStage = Stage.NULL_STAGE;
    private boolean initialized = false;

    LevelStorage() {
        this.xp = 0;
        this.prevXp = 0;
        this.prevLvl = 0;
        this.cachedLevel = -1;
    }

    LevelStorage(int xp) {
        this.xp = xp;
        this.prevXp = 0;
        this.prevLvl = 0;
        this.cachedLevel = -1;
    }

    @Init
    public static void initStages() {
        stages = Stage.load(String.join((CharSequence)"\n", stagesJson));
    }

    private static int getXpReqForNextLevel(int lvl) {
        if (lvl < 0) {
            return 0;
        }
        if (lvl < 17) {
            return lvl * lvl + 6 * lvl;
        }
        if (lvl < 32) {
            return MathHelper.func_76128_c((double)(2.5 * (double)lvl * (double)lvl - 40.5 * (double)lvl + 360.0));
        }
        return MathHelper.func_76128_c((double)(4.5 * (double)lvl * (double)lvl - 162.5 * (double)lvl + 2220.0));
    }

    static String[] getDefaultStages() {
        ArrayList stageLines = new ArrayList();
        try {
            MiscUtils.readFile((ModContainer)Loader.instance().getModList().stream().filter(c -> c.getModId().equals("sapturretmod")).findFirst().orElseThrow(IOException::new), (String)"assets/sapturretmod/stages_default.json", r -> {
                System.out.println("read file successfully...");
                stageLines.addAll(r.lines().collect(Collectors.toList()));
            });
            return stageLines.toArray(new String[0]);
        }
        catch (IOException e) {
            TmrConstants.LOG.log(Level.ERROR, "Cannot load default stages: {}", (Object)e.getMessage());
            return new String[0];
        }
    }

    @Override
    public void fromBytes(ObjectInputStream stream) throws IOException {
        this.xp = stream.readInt();
        this.prevXp = 0;
        this.cachedLevel = -1;
    }

    @Override
    public void toBytes(ObjectOutputStream stream) throws IOException {
        stream.writeInt(this.xp);
    }

    @Override
    public void onTick(ITurretInst turretInst) {
        EntityLiving e = turretInst.get();
        if (e.func_70613_aW() && this.prevXp != this.xp) {
            UpgradeRegistry.INSTANCE.syncWithClients(turretInst, Leveling.ID);
            this.prevXp = this.xp;
            this.cachedLevel = -1;
            this.applyEffects(turretInst, this.initialized);
        }
        if (!this.initialized) {
            this.initialized = true;
            List currModifierIds = Arrays.stream(stages).map(s -> Arrays.stream(s.modifiers).map(m -> m.modifier.func_111167_a()).collect(Collectors.toList())).reduce(new ArrayList(), (result, element) -> {
                result.addAll(element);
                return result;
            });
            e.func_110140_aT().func_111146_a().forEach(a -> a.func_111122_c().forEach(m -> {
                if (m.func_111166_b().startsWith("sapturretmod:leveling_") && !currModifierIds.contains(m.func_111167_a())) {
                    a.func_111124_b(m);
                }
            }));
        }
    }

    void applyEffects(ITurretInst turretInst, boolean playSound) {
        int currLevel = this.getLevel();
        if (this.prevLvl != currLevel) {
            this.prevLvl = currLevel;
            Arrays.stream(stages).forEach(s -> {
                if (s.check(currLevel, this.currStage)) {
                    s.apply(turretInst, playSound);
                }
            });
        }
    }

    void removeEffects(ITurretInst turretInst) {
        EntityLiving e = turretInst.get();
        e.func_110140_aT().func_111146_a().forEach(a -> a.func_111122_c().forEach(m -> {
            if (m.func_111166_b().startsWith("sapturretmod:leveling_")) {
                a.func_111124_b(m);
            }
        }));
    }

    public Map<String, Stage.ModifierInfo> fetchCurrentModifiers(ITurretInst turretInst) {
        return Stage.fetchModifiers(this.fetchCurrentStages(), turretInst.get().func_110140_aT());
    }

    private List<Stage> fetchCurrentStages() {
        int currLevel = this.getLevel();
        return Arrays.stream(stages).filter(s -> s.check(currLevel, Stage.NULL_STAGE)).collect(Collectors.toList());
    }

    public int getXp() {
        return Math.min(this.xp, maxXp);
    }

    public int getExcessXp() {
        return Math.max(this.xp - maxXp, 0);
    }

    public int getFullXp() {
        return this.xp;
    }

    public int retrieveExcessXp() {
        int exp = this.getExcessXp();
        this.xp -= exp;
        return exp;
    }

    public void addXp(int xp) {
        if (xp > 0) {
            this.xp += xp;
        }
    }

    public static Stage[] getStages() {
        return stages;
    }

    public int getLevel() {
        if (this.cachedLevel > -1) {
            return this.cachedLevel;
        }
        int xp = this.getXp();
        if (xp <= 352) {
            return MathHelper.func_76128_c((double)(Math.sqrt((double)xp + 9.0) - 3.0));
        }
        if (xp <= 1507) {
            return MathHelper.func_76128_c((double)(Math.sqrt(0.4 * (double)xp - 78.39) + 8.1));
        }
        return MathHelper.func_76128_c((double)(Math.sqrt(0.2222222222222222 * (double)xp - 167.33) + 18.056));
    }

    public int getNextLevelMinXp() {
        return LevelStorage.getXpReqForNextLevel(this.getLevel() + 1);
    }

    public int getCurrentLevelMinXp() {
        return LevelStorage.getXpReqForNextLevel(this.getLevel());
    }
}

