/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.upgrades.leveling;

import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.turret.IUpgradeProcessor;
import de.sanandrew.mods.turretmod.api.upgrade.IUpgrade;
import de.sanandrew.mods.turretmod.registry.upgrades.leveling.LevelStorage;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

@IUpgrade.InitSynchronizeClient
public class Leveling
implements IUpgrade {
    static final ResourceLocation ID = new ResourceLocation("sapturretmod", "upgrade_leveling");
    private static final String NBT_ITEM_LEVELS = "Levels";
    private static final String NBT_EXPERIENCE = "Experience";

    @Override
    @Nonnull
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public void initialize(ITurretInst turretInst, ItemStack stack) {
        IUpgradeProcessor processor = turretInst.getUpgradeProcessor();
        if (turretInst.get().func_70613_aW()) {
            NBTTagCompound lvlNbt = stack.func_179543_a(NBT_ITEM_LEVELS);
            LevelStorage stg = lvlNbt != null && lvlNbt.func_74764_b(NBT_EXPERIENCE) ? new LevelStorage(lvlNbt.func_74762_e(NBT_EXPERIENCE)) : new LevelStorage();
            processor.setUpgradeInstance(ID, stg);
        } else {
            processor.setUpgradeInstance(ID, new LevelStorage());
        }
    }

    @Override
    public void onLoad(ITurretInst turretInst, NBTTagCompound nbt) {
        LevelStorage stg = new LevelStorage(nbt.func_74762_e(NBT_EXPERIENCE));
        turretInst.getUpgradeProcessor().setUpgradeInstance(ID, stg);
        stg.applyEffects(turretInst, false);
    }

    @Override
    public void onSave(ITurretInst turretInst, NBTTagCompound nbt) {
        nbt.func_74768_a(NBT_EXPERIENCE, ((LevelStorage)turretInst.getUpgradeProcessor().getUpgradeInstance(ID)).getFullXp());
    }

    @Override
    public void terminate(ITurretInst turretInst, ItemStack stack) {
        LevelStorage stg = (LevelStorage)turretInst.getUpgradeProcessor().getUpgradeInstance(ID);
        if (stg != null) {
            NBTTagCompound lvlNbt = stack.func_190925_c(NBT_ITEM_LEVELS);
            lvlNbt.func_74768_a(NBT_EXPERIENCE, stg.xp);
            stg.removeEffects(turretInst);
            turretInst.getUpgradeProcessor().delUpgradeInstance(ID);
        }
    }
}

