/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.upgrades.leveling;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import de.sanandrew.mods.sanlib.lib.util.EntityUtils;
import de.sanandrew.mods.sanlib.lib.util.JsonUtils;
import de.sanandrew.mods.turretmod.api.TmrConstants;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.registry.EnumEffect;
import de.sanandrew.mods.turretmod.registry.turret.TurretRegistry;
import de.sanandrew.mods.turretmod.registry.upgrades.leveling.LevelStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class Stage {
    static final String NAME_PREFIX = "sapturretmod:leveling_";
    static final Stage NULL_STAGE = new Stage(-1, new Modifier[0]);
    public final int level;
    public final Modifier[] modifiers;

    private Stage(int level, Modifier ... modifiers) {
        this.level = level;
        this.modifiers = modifiers;
    }

    static Stage[] load(String jsons) {
        boolean tried = false;
        while (true) {
            try {
                ArrayList<Stage> stageList = new ArrayList<Stage>();
                JsonArray json = (JsonArray)JsonUtils.GSON.fromJson(jsons, JsonArray.class);
                for (JsonElement j : json) {
                    JsonObject stage = j.getAsJsonObject();
                    int lvl = stage.get("level").getAsInt();
                    ArrayList modifiers = new ArrayList();
                    stage.get("modifiers").getAsJsonArray().forEach(m -> {
                        JsonObject mod = m.getAsJsonObject();
                        ResourceLocation turret = null;
                        AttributeModifier attributeModifier = new AttributeModifier(UUID.fromString(mod.get("id").getAsString()), NAME_PREFIX + mod.get("name").getAsString(), mod.get("amount").getAsDouble(), mod.get("mode").getAsInt());
                        if (mod.has("turret") && !TurretRegistry.INSTANCE.getObject(turret = new ResourceLocation(mod.get("turret").getAsString())).isValid()) {
                            TmrConstants.LOG.log(Level.WARN, String.format("Skipping modifier %s for level %d, as it tries to target non-existing turret %s", mod.get("name"), lvl, mod.get("turret")));
                            return;
                        }
                        modifiers.add(new Modifier(mod.get("attribute").getAsString(), attributeModifier, turret));
                    });
                    stageList.add(new Stage(lvl, modifiers.toArray(new Modifier[0])));
                }
                return stageList.toArray(new Stage[0]);
            }
            catch (JsonSyntaxException ex) {
                TmrConstants.LOG.log(Level.WARN, "Cannot parse JSON from upgrades.leveling.stages config. Load default stages...", (Throwable)ex);
                jsons = String.join((CharSequence)"\n", LevelStorage.getDefaultStages());
                if (tried) {
                    return new Stage[0];
                }
                tried = true;
                continue;
            }
            break;
        }
    }

    boolean check(int level, Stage currStage) {
        return level >= this.level && currStage.level < this.level;
    }

    void apply(ITurretInst turretInst, boolean playSound) {
        boolean hasMultiplier = false;
        for (Modifier m : this.modifiers) {
            if (m.turret != null && !m.turret.equals((Object)turretInst.getTurret().getId())) continue;
            hasMultiplier |= EntityUtils.tryApplyModifier((EntityLivingBase)turretInst.get(), (String)m.attributeName, (AttributeModifier)m.modifier);
        }
        if (playSound && hasMultiplier) {
            EntityLiving markus = turretInst.get();
            EnumEffect.LEVEL_UP.addEffect((Entity)markus);
        }
    }

    public static Map<String, ModifierInfo> fetchModifiers(Collection<Stage> stages, AbstractAttributeMap attrMap) {
        HashMap<String, ModifierInfo> currModifiers = new HashMap<String, ModifierInfo>();
        HashMap<String, Map> modMap = new HashMap<String, Map>();
        stages.forEach(s -> Arrays.stream(s.modifiers).forEach(m -> modMap.computeIfAbsent(m.attributeName, k -> new HashMap()).computeIfAbsent(m.modifier.func_111169_c(), k -> new ArrayList()).add(m.modifier.func_111164_d())));
        modMap.forEach((attrName, mods) -> {
            double baseVal;
            if (attrMap != null) {
                IAttributeInstance attrInst = attrMap.func_111152_a(attrName);
                if (attrInst == null) {
                    return;
                }
                baseVal = attrInst.func_111125_b();
            } else {
                baseVal = 100.0;
            }
            ModifierInfo modInfo = currModifiers.computeIfAbsent((String)attrName, a -> new ModifierInfo(baseVal));
            mods.getOrDefault(0, Collections.emptyList()).forEach(m -> modInfo.modValue = modInfo.modValue + m);
            double modValFn = modInfo.modValue;
            mods.getOrDefault(1, Collections.emptyList()).forEach(m -> modInfo.modValue = modInfo.modValue + modValFn * m);
            mods.getOrDefault(2, Collections.emptyList()).forEach(m -> modInfo.modValue = modInfo.modValue + modInfo.modValue * m);
        });
        return currModifiers;
    }

    public static final class ModifierInfo {
        public final double baseValue;
        private double modValue;

        private ModifierInfo(double baseValue) {
            this.baseValue = baseValue;
            this.modValue = baseValue;
        }

        public double getModValue() {
            return this.modValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModifierInfo that = (ModifierInfo)o;
            return Double.compare(that.baseValue, this.baseValue) == 0 && Double.compare(that.modValue, this.modValue) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.baseValue, this.modValue);
        }
    }

    public static class Modifier {
        public final String attributeName;
        public final AttributeModifier modifier;
        public final ResourceLocation turret;

        private Modifier(String attributeName, AttributeModifier modifier, ResourceLocation turret) {
            this.attributeName = attributeName;
            this.modifier = modifier;
            this.turret = turret;
        }
    }
}

