/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.upgrades.shield;

import de.sanandrew.mods.sanlib.lib.ColorObj;
import de.sanandrew.mods.turretmod.api.turret.IForcefieldProvider;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.upgrade.IUpgradeInstance;
import de.sanandrew.mods.turretmod.registry.upgrades.shield.ShieldPersonalRecovery;
import de.sanandrew.mods.turretmod.util.TmrUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;

@IUpgradeInstance.Tickable
public final class ShieldPersonal
implements IUpgradeInstance<ShieldPersonal>,
IForcefieldProvider {
    public static final float MAX_VALUE = 20.0f;
    static final ColorObj BASE_COLOR = new ColorObj(1088255231);
    static final float[] BASE_CLR_HSL = BASE_COLOR.calcHSL();
    private static final AxisAlignedBB BB = new AxisAlignedBB(-0.5, 0.0, -0.5, 0.5, 2.0, 0.5);
    static final float CRIT_VALUE = 5.0f;
    private static final float RECOVERY_PER_TICK = 0.005f;
    float value;
    float recovery;

    ShieldPersonal(float value, float recovery) {
        this.value = Math.min(Math.max(value, 0.0f), 20.0f);
        this.recovery = recovery;
    }

    ShieldPersonal(float value) {
        this(value, 0.0f);
    }

    public float damage(float dmg) {
        if (dmg <= 0.0f) {
            return 0.0f;
        }
        if (this.value < dmg) {
            float rest = dmg - this.value;
            this.value = 0.0f;
            return rest;
        }
        this.value -= dmg;
        return 0.0f;
    }

    public float getValue() {
        return this.value;
    }

    public boolean isInRecovery() {
        return this.recovery > 0.0f;
    }

    public float getRecoveryPercentage() {
        return this.recovery / 5.0f * 100.0f;
    }

    @Override
    public boolean isShieldActive() {
        return this.value > 0.0f;
    }

    @Override
    public AxisAlignedBB getShieldBoundingBox() {
        return BB;
    }

    @Override
    public int getShieldColor() {
        if (this.value < 5.0f) {
            float[] hsl = (float[])BASE_CLR_HSL.clone();
            hsl[0] = hsl[0] <= 180.0f ? this.value / 5.0f * hsl[0] : 360.0f - this.value / 5.0f * (360.0f - hsl[0]);
            return ColorObj.fromHSLA((float)hsl[0], (float)hsl[1], (float)hsl[2], (float)BASE_COLOR.fAlpha()).getColorInt();
        }
        return BASE_COLOR.getColorInt();
    }

    @Override
    public boolean cullShieldFaces() {
        return true;
    }

    @Override
    public void fromBytes(ObjectInputStream stream) throws IOException {
        this.value = stream.readFloat();
        this.recovery = stream.readFloat();
    }

    @Override
    public void toBytes(ObjectOutputStream stream) throws IOException {
        stream.writeFloat(this.value);
        stream.writeFloat(this.recovery);
    }

    @Override
    public void onTick(ITurretInst turretInst) {
        if (this.value <= 0.0f) {
            this.recovery += 0.005f;
        }
        if (this.recovery >= 5.0f) {
            this.value = 20.0f;
            this.recovery = 0.0f;
        }
        if (turretInst.get().field_70170_p.field_72995_K) {
            if (this.isInRecovery() && !TmrUtils.INSTANCE.hasForcefield((Entity)turretInst.get(), ShieldPersonalRecovery.class)) {
                TmrUtils.INSTANCE.addForcefield((Entity)turretInst.get(), new ShieldPersonalRecovery(this));
            }
            if (this.isShieldActive() && !TmrUtils.INSTANCE.hasForcefield((Entity)turretInst.get(), this.getClass())) {
                TmrUtils.INSTANCE.addForcefield((Entity)turretInst.get(), this);
            }
        }
    }

    @Override
    public boolean renderFull() {
        return true;
    }
}

