/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.upgrades.shield;

import de.sanandrew.mods.sanlib.lib.ColorObj;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.api.turret.IForcefieldProvider;
import de.sanandrew.mods.turretmod.registry.upgrades.shield.ShieldPersonal;
import net.minecraft.util.math.AxisAlignedBB;

public final class ShieldPersonalRecovery
implements IForcefieldProvider {
    private static final ColorObj CRIT_COLOR = new ColorObj(0x40FF0000);
    private static final float[] CRIT_CLR_HSL = CRIT_COLOR.calcHSL();
    private static final float[] HSL_DIF = new float[]{MiscUtils.wrap360((float)(ShieldPersonal.BASE_CLR_HSL[0] - CRIT_CLR_HSL[0])), ShieldPersonal.BASE_CLR_HSL[1] - CRIT_CLR_HSL[1], ShieldPersonal.BASE_CLR_HSL[2] - CRIT_CLR_HSL[2]};
    private final ShieldPersonal delegate;

    ShieldPersonalRecovery(ShieldPersonal delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean isShieldActive() {
        return this.delegate.isInRecovery();
    }

    @Override
    public AxisAlignedBB getShieldBoundingBox() {
        return this.delegate.getShieldBoundingBox();
    }

    @Override
    public int getShieldColor() {
        float perc = this.delegate.recovery / 5.0f;
        if (perc < 0.9f) {
            ColorObj newClr = new ColorObj(CRIT_COLOR);
            newClr.setAlpha(Math.round((CRIT_COLOR.fAlpha() + (ShieldPersonal.BASE_COLOR.fAlpha() - CRIT_COLOR.fAlpha()) * (perc /= 0.9f)) * 255.0f * perc));
            return newClr.getColorInt();
        }
        perc = (perc - 0.9f) * 10.0f;
        float[] hslDif = (float[])HSL_DIF.clone();
        hslDif[0] = MiscUtils.wrap360((float)(CRIT_CLR_HSL[0] + (hslDif[0] > 180.0f ? -(360.0f - hslDif[0]) : hslDif[0]) * perc));
        hslDif[1] = CRIT_CLR_HSL[1] + hslDif[1] * perc;
        hslDif[2] = CRIT_CLR_HSL[2] + hslDif[2] * perc;
        return ColorObj.fromHSLA((float)hslDif[0], (float)hslDif[1], (float)hslDif[2], (float)(CRIT_COLOR.fAlpha() + (ShieldPersonal.BASE_COLOR.fAlpha() - CRIT_COLOR.fAlpha()) * perc)).getColorInt();
    }

    @Override
    public boolean cullShieldFaces() {
        return true;
    }

    @Override
    public boolean hasSmoothFadeOut() {
        return false;
    }

    @Override
    public boolean renderFull() {
        return true;
    }
}

