/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.upgrades.shield;

import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.upgrade.IUpgrade;
import de.sanandrew.mods.turretmod.registry.turret.Turrets;
import de.sanandrew.mods.turretmod.registry.turret.forcefield.Forcefield;
import de.sanandrew.mods.turretmod.registry.upgrades.shield.ShieldColorizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class UpgradeShieldColorizer
implements IUpgrade {
    private static final ResourceLocation ID = new ResourceLocation("sapturretmod", "upgrade_shield_colorizer");
    private static final ITurret[] APPLICABLES = new ITurret[]{Turrets.FORCEFIELD};

    @Override
    @Nonnull
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    @Nullable
    public ITurret[] getApplicableTurrets() {
        return APPLICABLES;
    }

    @Override
    public void initialize(ITurretInst turretInst, ItemStack stack) {
        turretInst.getUpgradeProcessor().setUpgradeInstance(ID, new ShieldColorizer());
        UpgradeShieldColorizer.recalcColor(turretInst);
    }

    @Override
    public void onLoad(ITurretInst turretInst, NBTTagCompound nbt) {
        turretInst.getUpgradeProcessor().setUpgradeInstance(ID, new ShieldColorizer(nbt));
        UpgradeShieldColorizer.recalcColor(turretInst);
    }

    @Override
    public void onSave(ITurretInst turretInst, NBTTagCompound nbt) {
        ShieldColorizer settings = (ShieldColorizer)turretInst.getUpgradeProcessor().getUpgradeInstance(ID);
        if (settings != null) {
            settings.writeToNbt(nbt);
        }
    }

    @Override
    public void terminate(ITurretInst turretInst, ItemStack stack) {
        turretInst.getUpgradeProcessor().delUpgradeInstance(ID);
        UpgradeShieldColorizer.recalcColor(turretInst);
    }

    static void recalcColor(ITurretInst turretInst) {
        Forcefield shield = (Forcefield)turretInst.getRAM(null);
        if (shield != null) {
            shield.recalcBaseColor();
        }
    }
}

