/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.tileentity.assembly;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.IEnergyStorage;

final class AssemblyEnergyStorage
implements IEnergyStorage,
INBTSerializable<NBTTagCompound> {
    int fluxAmount;
    private int prevFluxAmount;

    AssemblyEnergyStorage() {
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.getMaxEnergyStored() - this.fluxAmount, Math.min(500, maxReceive));
        if (!simulate) {
            this.fluxAmount += energyReceived;
        }
        return energyReceived;
    }

    void updatePrevFlux() {
        this.prevFluxAmount = this.fluxAmount;
    }

    boolean hasFluxChanged() {
        return this.prevFluxAmount != this.fluxAmount;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.fluxAmount;
    }

    public int getMaxEnergyStored() {
        return 75000;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("fluxAmount", this.fluxAmount);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.fluxAmount = nbt.func_74762_e("fluxAmount");
    }
}

