/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.tileentity.assembly;

import de.sanandrew.mods.sanlib.lib.Tuple;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.api.assembly.IAssemblyRecipe;
import de.sanandrew.mods.turretmod.inventory.AssemblyCache;
import de.sanandrew.mods.turretmod.inventory.AssemblyInventory;
import de.sanandrew.mods.turretmod.network.PacketSyncTileEntity;
import de.sanandrew.mods.turretmod.network.TileClientSync;
import de.sanandrew.mods.turretmod.registry.EnumEffect;
import de.sanandrew.mods.turretmod.registry.assembly.AssemblyManager;
import de.sanandrew.mods.turretmod.tileentity.assembly.AssemblyEnergyStorage;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityTurretAssembly
extends TileEntity
implements TileClientSync,
ITickable {
    static final int MAX_FLUX_STORAGE = 75000;
    static final int MAX_FLUX_INSERT = 500;
    public float robotArmX = 2.0f;
    public float robotArmY = -9.0f;
    public float prevRobotArmX;
    public float prevRobotArmY;
    private float robotMotionX = 0.0f;
    private float robotMotionY = 0.0f;
    private float robotEndX;
    private float robotEndY;
    public Tuple spawnParticle;
    private boolean prevActive;
    private boolean automate;
    public boolean isActive;
    public boolean isActiveClient;
    public IAssemblyRecipe currRecipe;
    public int craftingAmount;
    private int ticksCrafted = 0;
    private int maxTicksCrafted = 0;
    private int fluxConsumption = 0;
    private boolean doSync;
    private long ticksExisted = 0L;
    private String customName;
    private final AssemblyEnergyStorage energyStorage = new AssemblyEnergyStorage();
    private final AssemblyInventory invHandler = new AssemblyInventory(this);
    private final IItemHandler itemHandlerBottom = new SidedInvWrapper((ISidedInventory)this.invHandler, EnumFacing.DOWN);
    private final IItemHandler itemHandlerSide = new SidedInvWrapper((ISidedInventory)this.invHandler, EnumFacing.WEST);
    private final AssemblyCache cache = new AssemblyCache(this, (IInventory)this.invHandler);

    public void beginCrafting(IAssemblyRecipe recipe, int count) {
        if (this.currRecipe != null && recipe.getId().equals((Object)this.currRecipe.getId()) && !this.automate) {
            if (this.craftingAmount + count < 1) {
                this.cancelCrafting();
            } else {
                this.craftingAmount += count;
                this.doSync = true;
            }
        } else if (this.currRecipe == null) {
            this.currRecipe = recipe;
            this.craftingAmount = this.automate ? 1 : count;
            this.doSync = true;
        }
    }

    public void cancelCrafting() {
        this.cache.dropItems();
        this.currRecipe = null;
        this.craftingAmount = 0;
        this.ticksCrafted = 0;
        this.fluxConsumption = 0;
        this.maxTicksCrafted = 0;
        this.isActive = false;
        this.isActiveClient = false;
        this.doSync = true;
        this.func_70296_d();
    }

    private void initCrafting() {
        ItemStack result;
        this.doSync = true;
        if (this.currRecipe != null && this.craftingAmount >= 1 && this.invHandler.canFillOutput(result = this.currRecipe.getCraftingResult((IInventory)this.invHandler))) {
            this.cache.insert(AssemblyManager.INSTANCE.checkAndConsumeResources((IInventory)this.invHandler, this.field_145850_b, this.currRecipe));
            if (!this.cache.func_191420_l()) {
                this.maxTicksCrafted = this.currRecipe.getProcessTime();
                this.fluxConsumption = MathHelper.func_76123_f((float)((float)this.currRecipe.getFluxPerTick() * (this.hasSpeedUpgrade() ? 1.1f : 1.0f)));
                this.ticksCrafted = 0;
                this.isActive = true;
                return;
            }
        }
        this.isActive = false;
        this.isActiveClient = false;
    }

    public boolean hasAutoUpgrade() {
        return this.invHandler.hasAutoUpgrade();
    }

    public boolean hasSpeedUpgrade() {
        return this.invHandler.hasSpeedUpgrade();
    }

    public boolean hasFilterUpgrade() {
        return this.invHandler.hasFilterUpgrade();
    }

    public boolean hasRedstoneUpgrade() {
        return this.invHandler.hasRedstoneUpgrade();
    }

    public NonNullList<ItemStack> getFilterStacks() {
        return this.invHandler.getFilterStacks();
    }

    public void func_73660_a() {
        this.prevActive = this.isActive;
        boolean prevActiveClient = this.isActiveClient;
        if (!this.field_145850_b.field_72995_K) {
            if (this.automate && !this.hasAutoUpgrade()) {
                this.automate = false;
                this.cancelCrafting();
            }
            if (this.energyStorage.hasFluxChanged()) {
                this.doSync = true;
            }
            this.energyStorage.updatePrevFlux();
            int maxLoop = this.hasSpeedUpgrade() ? 4 : 1;
            boolean markDirty = false;
            this.isActiveClient = this.isActive;
            if (this.isActive && this.currRecipe != null) {
                if (this.hasRedstoneUpgrade() && this.isRedstonePowered()) {
                    this.isActiveClient = false;
                    if (prevActiveClient) {
                        this.doSync = true;
                    }
                } else {
                    if (!prevActiveClient) {
                        this.doSync = true;
                    }
                    for (int i = 0; i < maxLoop; ++i) {
                        if (this.energyStorage.fluxAmount >= this.fluxConsumption) {
                            this.energyStorage.fluxAmount -= this.fluxConsumption;
                            if (++this.ticksCrafted >= this.maxTicksCrafted) {
                                ItemStack stack = this.currRecipe.getCraftingResult(this.cache);
                                if (!ItemStackUtils.isValid((ItemStack)stack)) {
                                    this.cancelCrafting();
                                    return;
                                }
                                this.invHandler.fillOutput(stack);
                                this.cache.func_174888_l();
                                if (this.craftingAmount > 1 || this.automate) {
                                    if (!this.automate) {
                                        --this.craftingAmount;
                                    }
                                    if (this.isActive) {
                                        this.initCrafting();
                                    }
                                } else {
                                    this.cancelCrafting();
                                    return;
                                }
                                this.ticksCrafted = 0;
                                markDirty = true;
                            }
                            this.doSync = true;
                        } else {
                            this.isActiveClient = false;
                            this.doSync = true;
                        }
                        if (this.isActive && this.currRecipe != null) {
                            continue;
                        }
                        break;
                    }
                }
            } else {
                this.initCrafting();
                this.isActiveClient = false;
            }
            if (markDirty) {
                this.func_70296_d();
            }
            if (this.doSync) {
                PacketSyncTileEntity.sync(this);
                this.doSync = false;
            }
        } else {
            this.processRobotArm();
        }
        ++this.ticksExisted;
    }

    private boolean isRedstonePowered() {
        if (this.field_145850_b.func_175709_b(this.field_174879_c.func_177977_b(), EnumFacing.DOWN) || this.field_145850_b.func_175709_b(this.field_174879_c.func_177984_a(), EnumFacing.UP)) {
            return true;
        }
        return Arrays.stream(EnumFacing.field_176754_o).anyMatch(f -> RedstonePowerProxy.INSTANCE.isPowered(this.field_145850_b, this.field_174879_c, (EnumFacing)f));
    }

    private void processRobotArm() {
        this.prevRobotArmX = this.robotArmX;
        this.prevRobotArmY = this.robotArmY;
        this.robotArmX += this.robotMotionX;
        this.robotArmY += this.robotMotionY;
        if (this.robotArmX > this.robotEndX && this.robotMotionX > 0.0f) {
            this.robotArmX = this.robotEndX;
            this.robotMotionX = 0.0f;
        } else if (this.robotArmX < this.robotEndX && this.robotMotionX < 0.0f) {
            this.robotArmX = this.robotEndX;
            this.robotMotionX = 0.0f;
        }
        if (this.robotArmY > this.robotEndY && this.robotMotionY > 0.0f) {
            this.robotArmY = this.robotEndY;
            this.robotMotionY = 0.0f;
        } else if (this.robotArmY < this.robotEndY && this.robotMotionY < 0.0f) {
            this.robotArmY = this.robotEndY;
            this.robotMotionY = 0.0f;
        }
        if (this.isActiveClient && (!this.prevActive || this.ticksExisted % 20L == 0L)) {
            this.animateRobotArmRng();
        } else if (!this.isActiveClient && !this.isActive) {
            this.animateRobotArmReset();
            this.spawnParticle = null;
        }
        if (this.isActiveClient && this.spawnParticle != null) {
            EnumEffect.ASSEMBLY_SPARK.addEffect(true, this.field_145850_b.field_73011_w.getDimension(), (Double)this.spawnParticle.getValue(0), (Double)this.spawnParticle.getValue(1) + 0.05, (Double)this.spawnParticle.getValue(2));
            this.spawnParticle = null;
        }
    }

    private void animateRobotArmRng() {
        this.animateRobotArm(4.0f + MiscUtils.RNG.randomFloat() * 6.0f, -3.5f + MiscUtils.RNG.randomFloat() * -6.0f);
    }

    private void animateRobotArmReset() {
        this.animateRobotArm(2.0f, -9.0f);
    }

    private void animateRobotArm(float x, float y) {
        float speedMulti = this.hasSpeedUpgrade() ? 4.0f : 1.0f;
        this.robotMotionX = (0.1f + MiscUtils.RNG.randomFloat() * 0.1f) * (x > this.robotArmX ? 1.0f : -1.0f) * speedMulti;
        this.robotMotionY = (0.1f + MiscUtils.RNG.randomFloat() * 0.1f) * (y > this.robotArmY ? 1.0f : -1.0f) * speedMulti;
        this.robotEndX = x;
        this.robotEndY = y;
    }

    public IInventory getInventory() {
        return this.invHandler;
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readNBT(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.writeNBT(super.func_189517_E_());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.readNBT(tag);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.writeNBT(new NBTTagCompound()));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        this.writeNBT(nbt);
        if (!this.cache.func_191420_l()) {
            nbt.func_74782_a("RemovedItems", (NBTBase)this.cache.getCompound());
        }
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readNBT(nbt);
        if (nbt.func_150297_b("RemovedItems", 9)) {
            NBTTagList remItems = nbt.func_150295_c("RemovedItems", 10);
            NonNullList remStacks = NonNullList.func_191197_a((int)remItems.func_74745_c(), (Object)ItemStack.field_190927_a);
            ItemStackUtils.readItemStacksFromTag((List)remStacks, (NBTTagList)remItems);
            this.cache.insert((List<ItemStack>)remStacks);
        }
        this.doSync = true;
    }

    private NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("inventory", (NBTBase)this.invHandler.serializeNBT());
        if (this.currRecipe != null) {
            nbt.func_74778_a("CraftingId", this.currRecipe.getId().toString());
            nbt.func_74768_a("CraftingAmount", this.craftingAmount);
        }
        nbt.func_74782_a("cap_energy", (NBTBase)this.energyStorage.serializeNBT());
        nbt.func_74757_a("isActive", this.isActive);
        nbt.func_74768_a("ticksCrafted", this.ticksCrafted);
        nbt.func_74768_a("maxTicksCrafted", this.maxTicksCrafted);
        nbt.func_74768_a("fluxConsumption", this.fluxConsumption);
        nbt.func_74757_a("automate", this.automate);
        if (this.hasCustomName()) {
            nbt.func_74778_a("customName", this.customName);
        }
        return nbt;
    }

    private void readNBT(NBTTagCompound nbt) {
        this.invHandler.deserializeNBT(nbt.func_74775_l("inventory"));
        if (nbt.func_74764_b("CraftingId") && nbt.func_74764_b("CraftingAmount")) {
            this.currRecipe = AssemblyManager.INSTANCE.getRecipe(new ResourceLocation(nbt.func_74779_i("CraftingId")));
            this.craftingAmount = nbt.func_74762_e("CraftingAmount");
        }
        this.energyStorage.deserializeNBT(nbt.func_74775_l("cap_energy"));
        this.isActive = nbt.func_74767_n("isActive");
        this.ticksCrafted = nbt.func_74762_e("ticksCrafted");
        this.maxTicksCrafted = nbt.func_74762_e("maxTicksCrafted");
        this.fluxConsumption = nbt.func_74762_e("fluxConsumption");
        this.automate = nbt.func_74767_n("automate");
        if (nbt.func_74764_b("customName")) {
            this.customName = nbt.func_74779_i("customName");
        }
    }

    public ITextComponent func_145748_c_() {
        return this.hasCustomName() ? new TextComponentString(this.getCustomName()) : new TextComponentTranslation(this.getCustomName(), new Object[0]);
    }

    public int getTicksCrafted() {
        return this.ticksCrafted;
    }

    public int getMaxTicksCrafted() {
        return this.maxTicksCrafted;
    }

    public int getFluxConsumption() {
        return this.fluxConsumption;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.energyStorage.fluxAmount);
        buf.writeInt(this.fluxConsumption);
        buf.writeBoolean(this.isActive);
        buf.writeInt(this.ticksCrafted);
        buf.writeInt(this.maxTicksCrafted);
        buf.writeBoolean(this.automate);
        buf.writeBoolean(this.isActiveClient);
        if (this.currRecipe != null) {
            buf.writeBoolean(true);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.currRecipe.getId().toString());
            buf.writeInt(this.craftingAmount);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.energyStorage.fluxAmount = buf.readInt();
        this.fluxConsumption = buf.readInt();
        this.isActive = buf.readBoolean();
        this.ticksCrafted = buf.readInt();
        this.maxTicksCrafted = buf.readInt();
        this.automate = buf.readBoolean();
        this.isActiveClient = buf.readBoolean();
        if (buf.readBoolean()) {
            this.currRecipe = AssemblyManager.INSTANCE.getRecipe(new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf)));
            this.craftingAmount = buf.readInt();
        } else {
            this.currRecipe = null;
            this.craftingAmount = 0;
        }
    }

    public void setAutomated(boolean b) {
        if (this.currRecipe == null) {
            this.automate = b;
            this.doSync = true;
        } else if (!b) {
            this.cancelCrafting();
            this.automate = false;
            this.doSync = true;
        }
    }

    public boolean isAutomated() {
        return this.automate;
    }

    @Override
    public TileEntity getTile() {
        return this;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.itemHandlerBottom;
            }
            if (facing != EnumFacing.UP) {
                return (T)this.itemHandlerSide;
            }
        } else if (facing != EnumFacing.UP && capability == CapabilityEnergy.ENERGY) {
            return (T)this.energyStorage;
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (facing != EnumFacing.UP) {
            return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
        }
        return super.hasCapability(capability, facing);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public String getCustomName() {
        return this.hasCustomName() ? this.customName : "sapturretmod.container.assembly";
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    private static final class RedstonePowerProxy
    extends BlockRedstoneDiode {
        private static final RedstonePowerProxy INSTANCE = new RedstonePowerProxy();

        private RedstonePowerProxy() {
            super(false);
        }

        protected int func_176403_d(IBlockState state) {
            return Integer.MAX_VALUE;
        }

        protected IBlockState func_180674_e(IBlockState unpoweredState) {
            return null;
        }

        protected IBlockState func_180675_k(IBlockState poweredState) {
            return null;
        }

        protected BlockStateContainer func_180661_e() {
            return Blocks.field_150413_aR.func_176194_O();
        }

        public boolean isPowered(World worldIn, BlockPos pos, EnumFacing facing) {
            return super.func_176404_e(worldIn, pos, this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)facing));
        }
    }
}

