/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.tileentity.electrolytegen;

import de.sanandrew.mods.sanlib.lib.power.EnergyHelper;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.turretmod.api.electrolytegen.IElectrolyteRecipe;
import de.sanandrew.mods.turretmod.block.BlockRegistry;
import de.sanandrew.mods.turretmod.inventory.ElectrolyteInventory;
import de.sanandrew.mods.turretmod.inventory.ElectrolyteItemStackHandler;
import de.sanandrew.mods.turretmod.network.PacketRegistry;
import de.sanandrew.mods.turretmod.network.PacketSyncTileEntity;
import de.sanandrew.mods.turretmod.network.TileClientSync;
import de.sanandrew.mods.turretmod.registry.electrolytegen.ElectrolyteManager;
import de.sanandrew.mods.turretmod.registry.electrolytegen.ElectrolyteProcess;
import de.sanandrew.mods.turretmod.tileentity.electrolytegen.ElectrolyteEnergyStorage;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityElectrolyteGenerator
extends TileEntity
implements TileClientSync,
ITickable {
    static final int MAX_FLUX_STORAGE = 500000;
    static final int MAX_FLUX_EXTRACT = 1000;
    static final int MAX_FLUX_GENERATED = 200;
    public final ElectrolyteProcess[] processes = new ElectrolyteProcess[9];
    public float efficiency;
    private boolean doSync;
    private String customName;
    private final ElectrolyteInventory itemHandler = new ElectrolyteInventory(this);
    private final ElectrolyteEnergyStorage energyStorage = new ElectrolyteEnergyStorage();
    public final ElectrolyteItemStackHandler containerItemHandler = new ElectrolyteItemStackHandler(this.itemHandler);

    public int getGeneratedFlux() {
        return this.efficiency < 0.1f ? 0 : Math.min(200, (int)Math.round(Math.pow(1.6, this.efficiency) / 68.71947673597977 * 80.0));
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.energyStorage.resetFluxExtract();
            float prevEffective = this.efficiency;
            this.energyStorage.emptyBuffer();
            if (this.energyStorage.isBufferEmpty() && this.energyStorage.fluxAmount < 500000) {
                int fluxEff = this.getGeneratedFlux();
                this.efficiency = 0.0f;
                int max = this.processes.length;
                for (int i = 0; i < max; ++i) {
                    this.processSlot(i);
                }
                if (this.efficiency > 0.1f) {
                    this.energyStorage.fillBuffer(fluxEff);
                }
            }
            if (prevEffective < this.efficiency - 0.01f || prevEffective > this.efficiency + 0.01f) {
                this.doSync = true;
            }
            this.transferEnergy();
            if (this.energyStorage.hasFluxChanged()) {
                this.doSync = true;
            }
            if (this.doSync) {
                PacketRegistry.sendToAllAround((IMessage)new PacketSyncTileEntity(this), this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c, 64.0);
            }
            this.energyStorage.updatePrevFlux();
        }
    }

    private void processSlot(int slot) {
        IElectrolyteRecipe recipe;
        ElectrolyteProcess process = this.processes[slot];
        boolean markAsDirty = false;
        if (process != null) {
            if (process.recipe == null) {
                this.processes[slot] = null;
                return;
            }
            ItemStack trashStack = process.getTrashStack(this.itemHandler);
            if (ItemStackUtils.isValid((ItemStack)trashStack) && this.itemHandler.isOutputFull(trashStack)) {
                return;
            }
            ItemStack treasureStack = process.getTreasureStack(this.itemHandler);
            if (ItemStackUtils.isValid((ItemStack)treasureStack) && this.itemHandler.isOutputFull(treasureStack)) {
                return;
            }
            if (process.hasFinished()) {
                if (ItemStackUtils.isValid((ItemStack)trashStack)) {
                    this.itemHandler.addExtraction(trashStack);
                }
                if (ItemStackUtils.isValid((ItemStack)treasureStack)) {
                    this.itemHandler.addExtraction(treasureStack);
                }
                this.processes[slot] = null;
                markAsDirty = true;
            } else {
                process.incrProgress();
            }
            this.efficiency += process.recipe.getEfficiency();
            this.doSync = true;
        }
        if (this.processes[slot] == null && (recipe = ElectrolyteManager.INSTANCE.getFuel(this.itemHandler.extractInsertItem(slot, true))) != null) {
            this.processes[slot] = new ElectrolyteProcess(recipe, this.itemHandler.extractInsertItem(slot, false));
            markAsDirty = true;
            this.doSync = true;
        }
        if (markAsDirty) {
            this.func_70296_d();
        }
    }

    private void transferEnergy() {
        if (this.energyStorage.fluxExtractPerTick > 0) {
            for (EnumFacing direction : EnumFacing.field_82609_l) {
                if (direction == EnumFacing.UP) continue;
                EnumFacing otherDir = direction.func_176734_d();
                BlockPos adjPos = this.field_174879_c.func_177982_a(direction.func_82601_c(), direction.func_96559_d(), direction.func_82599_e());
                TileEntity te = this.field_145850_b.func_175625_s(adjPos);
                if (te == null || !EnergyHelper.canConnectEnergy((TileEntity)te, (EnumFacing)otherDir)) continue;
                long extractable = EnergyHelper.extractEnergy((TileEntity)this, (EnumFacing)direction, (long)1000L, (boolean)true);
                long receivable = EnergyHelper.receiveEnergy((TileEntity)te, (EnumFacing)otherDir, (long)extractable, (boolean)false);
                EnergyHelper.extractEnergy((TileEntity)this, (EnumFacing)direction, (long)receivable, (boolean)false);
                if (this.energyStorage.fluxExtractPerTick <= 0) break;
            }
        }
    }

    private NBTTagCompound writeNbt(NBTTagCompound nbt) {
        NBTTagList progressesNbt = new NBTTagList();
        int max = this.processes.length;
        for (int i = 0; i < max; ++i) {
            if (this.processes[i] == null) continue;
            NBTTagCompound progNbt = new NBTTagCompound();
            progNbt.func_74774_a("progressSlot", (byte)i);
            this.processes[i].writeToNBT(progNbt);
            progressesNbt.func_74742_a((NBTBase)progNbt);
        }
        nbt.func_74782_a("progress", (NBTBase)progressesNbt);
        nbt.func_74782_a("cap_energy", (NBTBase)this.energyStorage.serializeNBT());
        if (this.hasCustomName()) {
            nbt.func_74778_a("customName", this.customName);
        }
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readNbt(nbt);
        this.itemHandler.deserializeNBT(nbt.func_74775_l("cap_inventory"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("cap_inventory", (NBTBase)this.itemHandler.serializeNBT());
        this.writeNbt(nbt);
        return nbt;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeNbt(nbt);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    public NBTTagCompound func_189517_E_() {
        return this.writeNbt(super.func_189517_E_());
    }

    public ITextComponent func_145748_c_() {
        return this.hasCustomName() ? new TextComponentString(this.getName()) : new TextComponentTranslation(this.getName(), new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.readNbt(nbt);
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.readNbt(tag);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (facing != EnumFacing.UP) {
            return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing != EnumFacing.UP) {
                return (T)((Object)this.itemHandler);
            }
        } else if (capability == CapabilityEnergy.ENERGY && facing != EnumFacing.UP) {
            return (T)this.energyStorage;
        }
        return null;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    private void readNbt(NBTTagCompound nbt) {
        Arrays.fill(this.processes, null);
        NBTTagList progressesNbt = nbt.func_150295_c("progress", 10);
        int max = progressesNbt.func_74745_c();
        for (int i = 0; i < max; ++i) {
            NBTTagCompound progNbt = progressesNbt.func_150305_b(i);
            byte slot = progNbt.func_74771_c("progressSlot");
            this.processes[slot] = new ElectrolyteProcess(progNbt);
        }
        this.energyStorage.deserializeNBT(nbt.func_74775_l("cap_energy"));
        if (nbt.func_150297_b("customName", 8)) {
            this.customName = nbt.func_74779_i("customName");
        }
    }

    public String getName() {
        return this.hasCustomName() ? this.customName : BlockRegistry.ELECTROLYTE_GENERATOR.func_149739_a() + ".name";
    }

    public boolean hasCustomName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.energyStorage.fluxAmount);
        buf.writeFloat(this.efficiency);
        for (ElectrolyteProcess process : this.processes) {
            if (process != null) {
                buf.writeBoolean(true);
                process.writeToByteBuf(buf);
                continue;
            }
            buf.writeBoolean(false);
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.energyStorage.fluxAmount = buf.readInt();
        this.efficiency = buf.readFloat();
        int max = this.processes.length;
        for (int i = 0; i < max; ++i) {
            this.processes[i] = buf.readBoolean() ? new ElectrolyteProcess(buf) : null;
        }
    }

    @Override
    public TileEntity getTile() {
        return this;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }
}

