/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.world;

import de.sanandrew.mods.sanlib.lib.util.UuidUtils;
import de.sanandrew.mods.turretmod.network.PacketRegistry;
import de.sanandrew.mods.turretmod.network.PacketSyncPlayerList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class PlayerList
extends WorldSavedData {
    private static final String WSD_NAME = String.format("%s_%s", "sapturretmod", "playerList");
    public static final PlayerList INSTANCE = new PlayerList();
    private final Map<UUID, String> playerMap = new ConcurrentHashMap<UUID, String>();

    private PlayerList() {
        this(WSD_NAME);
    }

    public PlayerList(String s) {
        super(s);
    }

    public String getPlayerName(UUID playerUUID) {
        if (playerUUID.equals(UuidUtils.EMPTY_UUID)) {
            return "[deprecated]";
        }
        String s = this.playerMap.get(playerUUID);
        return s == null ? "UNKNOWN" : this.playerMap.get(playerUUID);
    }

    public Map<UUID, String> getPlayerMap() {
        return new HashMap<UUID, String>(this.playerMap);
    }

    public Map<UUID, Boolean> getDefaultPlayerList() {
        HashMap<UUID, Boolean> players = new HashMap<UUID, Boolean>(this.playerMap.size());
        for (UUID playerUUID : this.playerMap.keySet()) {
            players.put(playerUUID, false);
        }
        return players;
    }

    public void putPlayersClient(Map<UUID, String> players) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.playerMap.putAll(players);
        }
    }

    private void syncList() {
        PacketRegistry.sendToAll((IMessage)new PacketSyncPlayerList(this));
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer && !event.getWorld().field_72995_K) {
            this.playerMap.put(event.getEntity().func_110124_au(), event.getEntity().func_70005_c_());
            this.syncList();
            this.func_76185_a();
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        MapStorage storage;
        if (!event.getWorld().field_72995_K && (storage = event.getWorld().func_175693_T()) != null) {
            PlayerList result = (PlayerList)storage.func_75742_a(PlayerList.class, WSD_NAME);
            if (result == null) {
                result = this;
            }
            this.playerMap.putAll(result.playerMap);
            storage.func_75745_a(WSD_NAME, (WorldSavedData)this);
            this.syncList();
        }
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagCompound tmrNBT;
        String tmrNbtName = WSD_NAME;
        if (nbt.func_74764_b(tmrNbtName) && (tmrNBT = nbt.func_74775_l(tmrNbtName)).func_74764_b("players")) {
            NBTTagList nbtList = tmrNBT.func_150295_c("players", 10);
            int size = nbtList.func_74745_c();
            for (int i = 0; i < size; ++i) {
                NBTTagCompound playerNbt = nbtList.func_150305_b(i);
                this.playerMap.put(UUID.fromString(playerNbt.func_74779_i("playerUUID")), playerNbt.func_74779_i("playerName"));
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        NBTTagCompound tmrNBT = new NBTTagCompound();
        NBTTagList nbtList = new NBTTagList();
        for (Map.Entry<UUID, String> player : this.playerMap.entrySet()) {
            NBTTagCompound playerNbt = new NBTTagCompound();
            playerNbt.func_74778_a("playerUUID", player.getKey().toString());
            playerNbt.func_74778_a("playerName", player.getValue());
            nbtList.func_74742_a((NBTBase)playerNbt);
        }
        tmrNBT.func_74782_a("players", (NBTBase)nbtList);
        nbt.func_74782_a(WSD_NAME, (NBTBase)tmrNBT);
        return nbt;
    }
}

