/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.event;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import de.sanandrew.mods.turretmod.client.render.ForcefieldCube;
import de.sanandrew.mods.turretmod.client.util.ForcefieldProvider;
import de.sanandrew.mods.turretmod.util.Resources;
import de.sanandrew.mods.turretmod.util.TmrConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.darkhax.bookshelf.lib.ColorObject;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

public class RenderForcefieldHandler {
    public static final RenderForcefieldHandler INSTANCE = new RenderForcefieldHandler();
    private List<ForcefieldFadeOut> fadeOutFields = new ArrayList<ForcefieldFadeOut>();
    private Map<Integer, ForcefieldProvider> fieldProviders = new HashMap<Integer, ForcefieldProvider>();

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        EntityLivingBase renderEntity = Minecraft.func_71410_x().field_71451_h;
        double renderX = renderEntity.field_70142_S + (renderEntity.field_70165_t - renderEntity.field_70142_S) * (double)event.partialTicks;
        double renderY = renderEntity.field_70137_T + (renderEntity.field_70163_u - renderEntity.field_70137_T) * (double)event.partialTicks;
        double renderZ = renderEntity.field_70136_U + (renderEntity.field_70161_v - renderEntity.field_70136_U) * (double)event.partialTicks;
        ArrayList<ForcefieldCube> cubes = new ArrayList<ForcefieldCube>();
        int worldTicks = (int)(Minecraft.func_71410_x().field_71441_e.func_82737_E() % Integer.MAX_VALUE);
        Iterator<Map.Entry<Integer, ForcefieldProvider>> it = this.fieldProviders.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, ForcefieldProvider> entry = it.next();
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(entry.getKey().intValue());
            ForcefieldProvider ffProvider = entry.getValue();
            if (entity == null) {
                it.remove();
                continue;
            }
            if (entity.field_70128_L || !entity.func_70089_S() || !ffProvider.hasShieldActive() || !Minecraft.func_71410_x().field_71441_e.field_72996_f.contains(entity)) {
                this.fadeOutFields.add(new ForcefieldFadeOut(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, ffProvider.getShieldColor(), ffProvider.getShieldBoundingBox()));
                it.remove();
                continue;
            }
            double entityX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)event.partialTicks;
            double entityY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)event.partialTicks;
            double entityZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)event.partialTicks;
            ForcefieldCube cube = new ForcefieldCube(Vec3.func_72443_a((double)(entityX - renderX), (double)(entityY - renderY), (double)(entityZ - renderZ)), ffProvider.getShieldBoundingBox(), ffProvider.getShieldColor());
            if (TmrConfiguration.calcForcefieldIntf) {
                for (ForcefieldCube intfCube : cubes) {
                    cube.interfere(intfCube, false);
                    intfCube.interfere(cube, true);
                }
            }
            cubes.add(cube);
        }
        Iterator<ForcefieldFadeOut> fadeOutIt = this.fadeOutFields.iterator();
        while (fadeOutIt.hasNext()) {
            ForcefieldFadeOut shield = fadeOutIt.next();
            if (shield.color.getAlpha() <= 0.0f) {
                fadeOutIt.remove();
                continue;
            }
            ForcefieldCube cube = new ForcefieldCube(Vec3.func_72443_a((double)(shield.posX - renderX), (double)(shield.posY - renderY), (double)(shield.posZ - renderZ)), shield.shieldBB, shield.color);
            cubes.add(cube);
            shield.color.setAlpha(shield.color.getAlpha() - 0.01f);
        }
        Tessellator tess = Tessellator.field_78398_a;
        for (int pass = 1; pass <= 5; ++pass) {
            float transformTexAmount = (float)(worldTicks % 400) + event.partialTicks;
            float texTranslateX = 0.0f;
            float texTranslateY = 0.0f;
            switch (pass) {
                case 1: {
                    texTranslateX = transformTexAmount * -0.01f;
                    texTranslateY = transformTexAmount * 0.01f;
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(Resources.TURRET_FORCEFIELD_P1.getResource());
                    break;
                }
                case 2: {
                    texTranslateX = transformTexAmount * 0.005f;
                    texTranslateY = transformTexAmount * 0.005f;
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(Resources.TURRET_FORCEFIELD_P2.getResource());
                    break;
                }
                case 3: {
                    texTranslateX = transformTexAmount * -0.005f;
                    texTranslateY = transformTexAmount * 0.005f;
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(Resources.TURRET_FORCEFIELD_P1.getResource());
                    break;
                }
                case 4: {
                    texTranslateX = transformTexAmount * 0.0025f;
                    texTranslateY = transformTexAmount * 0.0025f;
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(Resources.TURRET_FORCEFIELD_P2.getResource());
                    break;
                }
                case 5: {
                    texTranslateX = transformTexAmount * 0.0f;
                    texTranslateY = transformTexAmount * 0.0f;
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(Resources.TURRET_FORCEFIELD_P3.getResource());
                }
            }
            GL11.glMatrixMode((int)5890);
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)texTranslateX, (float)texTranslateY, (float)0.0f);
            GL11.glMatrixMode((int)5888);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)32771, (int)32772, (int)1, (int)0);
            for (ForcefieldCube cube : cubes) {
                tess.func_78382_b();
                cube.draw(tess);
                GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)cube.boxColor.getAlpha());
                GL11.glDepthMask((boolean)false);
                GL11.glDisable((int)2884);
                tess.func_78381_a();
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)2884);
            }
            GL11.glDisable((int)3042);
            GL11.glMatrixMode((int)5890);
            GL11.glLoadIdentity();
            GL11.glMatrixMode((int)5888);
            GL11.glDisable((int)3042);
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2884);
        }
    }

    public void addForcefieldRenderer(Entity entity, ForcefieldProvider provider) {
        this.fieldProviders.put(entity.func_145782_y(), provider);
    }

    private static class ForcefieldFadeOut {
        public ColorObject color;
        public final AxisAlignedBB shieldBB;
        public double posX;
        public double posY;
        public double posZ;

        public ForcefieldFadeOut(double posX, double posY, double posZ, ColorObject origRGBA, AxisAlignedBB origShieldBB) {
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
            this.color = origRGBA;
            this.shieldBB = origShieldBB;
        }
    }
}

