/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.assembly;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import de.sanandrew.mods.turretmod.client.gui.assembly.GuiAssemblyCategoryTab;
import de.sanandrew.mods.turretmod.client.gui.assembly.GuiAssemblyTabNav;
import de.sanandrew.mods.turretmod.client.gui.control.GuiSlimButton;
import de.sanandrew.mods.turretmod.client.util.TmrClientUtils;
import de.sanandrew.mods.turretmod.inventory.ContainerTurretAssembly;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import de.sanandrew.mods.turretmod.network.PacketAssemblyToggleAutomate;
import de.sanandrew.mods.turretmod.network.PacketInitAssemblyCrafting;
import de.sanandrew.mods.turretmod.network.PacketRegistry;
import de.sanandrew.mods.turretmod.registry.assembly.RecipeEntryItem;
import de.sanandrew.mods.turretmod.registry.assembly.TurretAssemblyRecipes;
import de.sanandrew.mods.turretmod.tileentity.TileEntityTurretAssembly;
import de.sanandrew.mods.turretmod.util.Lang;
import de.sanandrew.mods.turretmod.util.Resources;
import de.sanandrew.mods.turretmod.util.TmrUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.darkhax.bookshelf.lib.javatuples.Pair;
import net.darkhax.bookshelf.lib.javatuples.Triplet;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiTurretAssembly
extends GuiContainer {
    private final ItemStack upgIconAuto;
    private final ItemStack upgIconSpeed;
    private final ItemStack upgIconFilter;
    private TileEntityTurretAssembly assembly;
    private List<Pair<UUID, ItemStack>> cacheRecipes;
    private FontRenderer frDetails;
    private boolean shiftPressed;
    private int scrollPos;
    private static int scrollGroupPos;
    private static int currOpenTab;
    private boolean prevIsLmbDown;
    private boolean prevIsRmbDown;
    private boolean isScrolling;
    private GuiSlimButton cancelTask;
    private GuiSlimButton automate;
    private GuiSlimButton manual;
    private GuiAssemblyTabNav groupUp;
    private GuiAssemblyTabNav groupDown;
    private Map<GuiAssemblyCategoryTab, TurretAssemblyRecipes.RecipeGroup> groupBtns;
    private long lastTimestamp;

    public GuiTurretAssembly(InventoryPlayer invPlayer, TileEntityTurretAssembly tile) {
        super((Container)new ContainerTurretAssembly((IInventory)invPlayer, tile));
        this.assembly = tile;
        this.field_146999_f = 230;
        this.field_147000_g = 222;
        this.assembly.syncStacks = false;
        this.upgIconAuto = new ItemStack((Item)ItemRegistry.asbAuto);
        this.upgIconSpeed = new ItemStack((Item)ItemRegistry.asbSpeed);
        this.upgIconFilter = new ItemStack((Item)ItemRegistry.asbFilter);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.frDetails = new FontRenderer(this.field_146297_k.field_71474_y, new ResourceLocation("textures/font/ascii.png"), this.field_146297_k.func_110434_K(), true);
        this.cancelTask = new GuiSlimButton(this.field_146292_n.size(), this.field_147003_i + 156, this.field_147009_r + 55, 50, Lang.translate(Lang.TASSEMBLY_BTN_CANCEL));
        this.field_146292_n.add(this.cancelTask);
        this.automate = new GuiSlimButton(this.field_146292_n.size(), this.field_147003_i + 156, this.field_147009_r + 68, 50, Lang.translate(Lang.TASSEMBLY_BTN_AUTOENABLE));
        this.field_146292_n.add(this.automate);
        this.manual = new GuiSlimButton(this.field_146292_n.size(), this.field_147003_i + 156, this.field_147009_r + 81, 50, Lang.translate(Lang.TASSEMBLY_BTN_AUTODISABLE));
        this.field_146292_n.add(this.manual);
        this.groupUp = new GuiAssemblyTabNav(this.field_146292_n.size(), this.field_147003_i + 13, this.field_147009_r + 9, false);
        this.field_146292_n.add(this.groupUp);
        int pos = 0;
        TurretAssemblyRecipes.RecipeGroup[] groups = TurretAssemblyRecipes.INSTANCE.getGroups();
        Arrays.sort(groups, new Comparator<TurretAssemblyRecipes.RecipeGroup>(){

            @Override
            public int compare(TurretAssemblyRecipes.RecipeGroup o1, TurretAssemblyRecipes.RecipeGroup o2) {
                return o1.name.compareTo(o2.name);
            }
        });
        this.groupBtns = new HashMap<GuiAssemblyCategoryTab, TurretAssemblyRecipes.RecipeGroup>(1 + (int)((float)groups.length / 0.75f));
        for (TurretAssemblyRecipes.RecipeGroup grp : groups) {
            GuiAssemblyCategoryTab tab = new GuiAssemblyCategoryTab(this.field_146292_n.size(), this.field_147003_i + 9, this.field_147009_r + 19 + pos * 15 - 15 * scrollGroupPos, grp.icon, Lang.translate(grp.name));
            this.groupBtns.put(tab, grp);
            this.field_146292_n.add(tab);
            boolean bl = tab.field_146125_m = pos >= scrollGroupPos && pos < scrollGroupPos + 4;
            if (pos == currOpenTab) {
                tab.field_146124_l = false;
                this.loadGroupRecipes(grp);
            }
            ++pos;
        }
        this.groupDown = new GuiAssemblyTabNav(this.field_146292_n.size(), this.field_147003_i + 13, this.field_147009_r + 79, true);
        this.field_146292_n.add(this.groupDown);
        if (scrollGroupPos + 4 >= groups.length) {
            this.groupDown.field_146125_m = false;
        }
        if (scrollGroupPos <= 0) {
            this.groupUp.field_146125_m = false;
        }
    }

    private void loadGroupRecipes(TurretAssemblyRecipes.RecipeGroup group) {
        this.cacheRecipes = new ArrayList<Pair<UUID, ItemStack>>();
        for (UUID recipe : group.recipes) {
            this.cacheRecipes.add((Pair<UUID, ItemStack>)Pair.with((Object)recipe, (Object)TurretAssemblyRecipes.INSTANCE.getRecipeResult(recipe)));
        }
    }

    protected void func_146976_a(float partTicks, int mouseX, int mouseY) {
        int i;
        boolean isLmbDown = Mouse.isButtonDown((int)0);
        boolean isRmbDown = Mouse.isButtonDown((int)1);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(Resources.GUI_ASSEMBLY_CRF.getResource());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int energy = this.assembly.getEnergyStored(ForgeDirection.DOWN);
        int maxEnergy = 75000;
        double energyPerc = (double)energy / (double)maxEnergy;
        int energyBarY = Math.max(0, Math.min(82, MathHelper.func_76143_f((double)((1.0 - energyPerc) * 82.0))));
        this.func_73729_b(this.field_147003_i + 210, this.field_147009_r + 8 + energyBarY, 230, 12 + energyBarY, 12, 82 - energyBarY);
        double procPerc = this.assembly.isActive ? (double)this.assembly.ticksCrafted / (double)this.assembly.maxTicksCrafted : 0.0;
        int procBarX = Math.max(0, Math.min(50, MathHelper.func_76143_f((double)(procPerc * 50.0))));
        this.func_73729_b(this.field_147003_i + 156, this.field_147009_r + 30, 0, 222, procBarX, 5);
        int maxScroll = this.cacheRecipes.size() - 4;
        if (maxScroll > 0 && this.assembly.currCrafting == null) {
            int scrollBtnPos = MathHelper.func_76128_c((double)(79.0 / (double)maxScroll * (double)this.scrollPos));
            if ((mouseX >= this.field_147003_i + 144 && mouseX < this.field_147003_i + 150 && mouseY >= this.field_147009_r + 7 && mouseY < this.field_147009_r + 92 || this.isScrolling) && isLmbDown) {
                scrollBtnPos = Math.min(79, Math.max(0, mouseY - 7 - this.field_147009_r));
                this.scrollPos = MathHelper.func_76128_c((double)((double)scrollBtnPos / 78.0 * (double)maxScroll));
                this.isScrolling = true;
            }
            this.func_73729_b(this.field_147003_i + 144, this.field_147009_r + 7 + scrollBtnPos, 230, 6, 6, 6);
        }
        GL11.glEnable((int)3089);
        TmrClientUtils.doGlScissor(this.field_147003_i + 33, this.field_147009_r + 8, 110, 83);
        if (this.cacheRecipes != null) {
            int maxSz = Math.min(4, this.cacheRecipes.size());
            for (i = 0; i < maxSz; ++i) {
                int index = this.scrollPos + i;
                ItemStack stack = (ItemStack)this.cacheRecipes.get(index).getValue1();
                boolean isActive = this.assembly.currCrafting == null || !this.assembly.isAutomated() && TmrUtils.areStacksEqual((ItemStack)this.assembly.currCrafting.getValue1(), stack, TmrUtils.NBT_COMPARATOR_FIXD);
                GL11.glEnable((int)32826);
                RenderHelper.func_74520_c();
                this.drawItemStack(stack, this.field_147003_i + 36, this.field_147009_r + 10 + 21 * i, 200.0f, true);
                GL11.glDisable((int)32826);
                RenderHelper.func_74518_a();
                List<?> tooltip = TmrClientUtils.getTooltipWithoutShift(stack);
                this.frDetails.func_78276_b(tooltip.get(0).toString(), this.field_147003_i + 57, this.field_147009_r + 10 + 21 * i, -1);
                if (tooltip.size() > 1) {
                    this.frDetails.func_78276_b(tooltip.get(1).toString(), this.field_147003_i + 57, this.field_147009_r + 19 + 21 * i, -8355712);
                }
                if (isActive) {
                    if (mouseX < this.field_147003_i + 35 || mouseX >= this.field_147003_i + 143 || mouseY < this.field_147009_r + 9 + 21 * i || mouseY >= this.field_147009_r + 27 + 21 * i) continue;
                    GL11.glDisable((int)2929);
                    GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                    this.func_73733_a(this.field_147003_i + 35, this.field_147009_r + 9 + 21 * i, this.field_147003_i + 143, this.field_147009_r + 27 + 21 * i, 0x2AFFFFFF, 0x2AFFFFFF);
                    GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    GL11.glEnable((int)2929);
                    if (isLmbDown && !this.prevIsLmbDown) {
                        PacketRegistry.sendToServer((IMessage)new PacketInitAssemblyCrafting(this.assembly, (UUID)this.cacheRecipes.get(index).getValue0(), this.shiftPressed ? 16 : 1));
                    }
                    if (!isRmbDown || this.prevIsRmbDown) continue;
                    PacketRegistry.sendToServer((IMessage)new PacketInitAssemblyCrafting(this.assembly, (UUID)this.cacheRecipes.get(index).getValue0(), this.shiftPressed ? -16 : -1));
                    continue;
                }
                this.field_146297_k.func_110434_K().func_110577_a(Resources.GUI_ASSEMBLY_CRF.getResource());
                GL11.glDisable((int)2929);
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
                this.func_73729_b(this.field_147003_i + 35, this.field_147009_r + 9 + 21 * i, 35, 9 + 21 * i, 108, 18);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)2929);
            }
        }
        GL11.glDisable((int)3089);
        if (!this.assembly.hasAutoUpgrade()) {
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
            RenderHelper.func_74518_a();
            this.field_146297_k.field_71446_o.func_110577_a(this.field_146297_k.field_71446_o.func_130087_a(this.upgIconAuto.func_94608_d()));
            this.func_94065_a(this.field_147003_i + 14, this.field_147009_r + 100, this.upgIconAuto.func_77954_c(), 16, 16);
            GL11.glDisable((int)3042);
        }
        if (!this.assembly.hasSpeedUpgrade()) {
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
            RenderHelper.func_74518_a();
            this.field_146297_k.field_71446_o.func_110577_a(this.field_146297_k.field_71446_o.func_130087_a(this.upgIconSpeed.func_94608_d()));
            this.func_94065_a(this.field_147003_i + 14, this.field_147009_r + 118, this.upgIconSpeed.func_77954_c(), 16, 16);
            GL11.glDisable((int)3042);
        }
        if (this.assembly.hasFilterUpgrade()) {
            ItemStack[] filteredStacks = this.assembly.getFilterStacks();
            for (i = 0; i < filteredStacks.length; ++i) {
                ItemStack filterStack = filteredStacks[i];
                if (!ItemStackUtils.isValidStack((ItemStack)filterStack) || ItemStackUtils.isValidStack((ItemStack)this.assembly.func_70301_a(i + 5))) continue;
                int x = i % 9;
                int y = i / 9;
                GL11.glEnable((int)32826);
                RenderHelper.func_74520_c();
                this.drawItemStack(filterStack, this.field_147003_i + 36 + x * 18, this.field_147009_r + 100 + y * 18, 200.0f, false);
                GL11.glDisable((int)32826);
                RenderHelper.func_74518_a();
                this.field_146297_k.func_110434_K().func_110577_a(Resources.GUI_ASSEMBLY_CRF.getResource());
                GL11.glDisable((int)2929);
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
                this.func_73729_b(this.field_147003_i + 35 + x * 18, this.field_147009_r + 99 + y * 18, 35 + x * 18, 99 + 18 * y, 18, 18);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)2929);
            }
        } else {
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
            RenderHelper.func_74518_a();
            this.field_146297_k.field_71446_o.func_110577_a(this.field_146297_k.field_71446_o.func_130087_a(this.upgIconFilter.func_94608_d()));
            this.func_94065_a(this.field_147003_i + 202, this.field_147009_r + 100, this.upgIconFilter.func_77954_c(), 16, 16);
            GL11.glDisable((int)3042);
        }
        if (this.assembly.currCrafting != null) {
            String cnt = String.format("%d", ((ItemStack)this.assembly.currCrafting.getValue1()).field_77994_a);
            if (this.assembly.isAutomated()) {
                cnt = String.valueOf('\u221e');
            }
            this.frDetails.func_78276_b(Lang.translate(Lang.TASSEMBLY_CRAFTING), this.field_147003_i + 156, this.field_147009_r + 40, -13619152);
            GL11.glEnable((int)32826);
            RenderHelper.func_74520_c();
            this.drawItemStack((ItemStack)this.assembly.currCrafting.getValue1(), this.field_147003_i + 190, this.field_147009_r + 36, 200.0f, false);
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2929);
            this.field_146289_q.func_78276_b(cnt, this.field_147003_i + 191 + 18 - this.field_146289_q.func_78256_a(cnt), this.field_147009_r + 37 + 18 - this.field_146289_q.field_78288_b, -13619152);
            this.field_146289_q.func_78276_b(cnt, this.field_147003_i + 190 + 18 - this.field_146289_q.func_78256_a(cnt), this.field_147009_r + 36 + 18 - this.field_146289_q.field_78288_b, -1);
            this.cancelTask.field_146124_l = true;
            this.automate.field_146124_l = false;
            this.manual.field_146124_l = false;
        } else {
            this.cancelTask.field_146124_l = false;
            this.automate.field_146124_l = !this.assembly.isAutomated();
            this.manual.field_146124_l = !this.automate.field_146124_l;
        }
        this.manual.field_146125_m = this.automate.field_146125_m = ItemStackUtils.isValidStack((ItemStack)this.assembly.func_70301_a(1));
        this.prevIsLmbDown = isLmbDown;
        this.prevIsRmbDown = isRmbDown;
        if (!isLmbDown) {
            this.isScrolling = false;
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        long time;
        super.func_146979_b(mouseX, mouseY);
        if (mouseX >= this.field_147003_i + 210 && mouseX < this.field_147003_i + 222 && mouseY >= this.field_147009_r + 8 && mouseY < this.field_147009_r + 90) {
            this.drawRFluxLabel(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (this.cacheRecipes != null) {
            int maxSz = Math.min(4, this.cacheRecipes.size());
            for (int i = 0; i < maxSz; ++i) {
                int index = this.scrollPos + i;
                if (this.assembly.currCrafting != null || mouseX < this.field_147003_i + 35 || mouseX >= this.field_147003_i + 143 || mouseY < this.field_147009_r + 9 + 21 * i || mouseY >= this.field_147009_r + 27 + 21 * i) continue;
                if (this.shiftPressed) {
                    this.drawIngredientsDetail(mouseX - this.field_147003_i, mouseY - this.field_147009_r, (UUID)this.cacheRecipes.get(index).getValue0());
                    continue;
                }
                this.drawIngredientsSmall(mouseX - this.field_147003_i, mouseY - this.field_147009_r, (UUID)this.cacheRecipes.get(index).getValue0());
            }
        }
        if (this.lastTimestamp + 1000L < (time = System.currentTimeMillis())) {
            this.lastTimestamp = time;
        }
    }

    private void drawItemStack(ItemStack stack, int x, int y, float z, boolean drawText) {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = z;
        GuiTurretAssembly.field_146296_j.field_77023_b = z;
        field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), stack, x, y);
        if (drawText) {
            field_146296_j.func_77021_b(this.field_146297_k.field_71466_p, this.field_146297_k.func_110434_K(), stack, x, y);
        }
        this.field_73735_i = 0.0f;
        GuiTurretAssembly.field_146296_j.field_77023_b = 0.0f;
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-32.0f);
    }

    private void drawIngredientsDetail(int mouseX, int mouseY, UUID recipe) {
        TurretAssemblyRecipes.RecipeEntry recipeEntry = TurretAssemblyRecipes.INSTANCE.getRecipeEntry(recipe);
        RecipeEntryItem[] ingredients = recipeEntry.resources;
        if (ingredients.length < 1) {
            this.drawIngredientsSmall(mouseX, mouseY, recipe);
            return;
        }
        HashMap<RecipeEntryItem, Triplet> desc = new HashMap<RecipeEntryItem, Triplet>(ingredients.length);
        ArrayList<Integer> lngth = new ArrayList<Integer>(ingredients.length);
        int tHeight = 0;
        for (RecipeEntryItem entry : ingredients) {
            ItemStack[] entryStacks = entry.getEntryItemStacks();
            ItemStack stack = entryStacks[(int)(this.lastTimestamp / 1000L % (long)entryStacks.length)];
            List<?> tooltip = TmrClientUtils.getTooltipWithoutShift(stack);
            String dscL1 = String.format("%dx %s", stack.field_77994_a, tooltip.get(0));
            String dscL2 = null;
            tHeight += 9;
            if (tooltip.size() > 1 && entry.shouldDrawTooltip()) {
                dscL2 = String.format("%s", tooltip.get(1));
                tHeight += 9;
            }
            desc.put(entry, Triplet.with((Object)stack, (Object)dscL1, dscL2));
            lngth.add(Math.max(this.frDetails.func_78256_a(dscL1), dscL2 == null ? 0 : this.frDetails.func_78256_a(dscL2)));
        }
        int textWidth = (lngth.size() > 0 ? (Integer)Collections.max(lngth) : 0) + 10;
        int xPos = mouseX + 12;
        int yPos = mouseY - 12;
        this.field_73735_i = 300.0f;
        GuiTurretAssembly.field_146296_j.field_77023_b = 300.0f;
        int bkgColor = -267386864;
        int lightBg = 0x505000FF;
        int darkBg = (lightBg & 0xFEFEFE) >> 1 | lightBg & 0xFF000000;
        this.func_73733_a(xPos - 3, yPos - 4, xPos + textWidth + 3, yPos - 3, bkgColor, bkgColor);
        this.func_73733_a(xPos - 3, yPos + tHeight + 3, xPos + textWidth + 3, yPos + tHeight + 4, bkgColor, bkgColor);
        this.func_73733_a(xPos - 3, yPos - 3, xPos + textWidth + 3, yPos + tHeight + 3, bkgColor, bkgColor);
        this.func_73733_a(xPos - 4, yPos - 3, xPos - 3, yPos + tHeight + 3, bkgColor, bkgColor);
        this.func_73733_a(xPos + textWidth + 3, yPos - 3, xPos + textWidth + 4, yPos + tHeight + 3, bkgColor, bkgColor);
        this.func_73733_a(xPos - 3, yPos - 3 + 1, xPos - 3 + 1, yPos + tHeight + 3 - 1, lightBg, darkBg);
        this.func_73733_a(xPos + textWidth + 2, yPos - 3 + 1, xPos + textWidth + 3, yPos + tHeight + 3 - 1, lightBg, darkBg);
        this.func_73733_a(xPos - 3, yPos - 3, xPos + textWidth + 3, yPos - 3 + 1, lightBg, lightBg);
        this.func_73733_a(xPos - 3, yPos + tHeight + 2, xPos + textWidth + 3, yPos + tHeight + 3, darkBg, darkBg);
        int i = 0;
        int j = 0;
        while (i < ingredients.length) {
            Triplet descIng = (Triplet)desc.get(ingredients[i]);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)xPos, (float)(yPos + j * 9), (float)0.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
            GL11.glEnable((int)32826);
            RenderHelper.func_74520_c();
            this.drawItemStack((ItemStack)descIng.getValue0(), 0, 0, 500.0f, false);
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2929);
            GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
            this.frDetails.func_78276_b((String)descIng.getValue1(), 10, 0, -12632257);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.0f);
            this.frDetails.func_78276_b((String)descIng.getValue1(), 10, 0, -1);
            if (descIng.getValue2() != null) {
                this.frDetails.func_78276_b((String)descIng.getValue2(), 10, 9, -9474193);
                ++j;
            }
            GL11.glEnable((int)2929);
            GL11.glPopMatrix();
            ++i;
            ++j;
        }
        RenderHelper.func_74520_c();
        GL11.glEnable((int)32826);
        this.field_73735_i = 0.0f;
        GuiTurretAssembly.field_146296_j.field_77023_b = 0.0f;
    }

    private void drawIngredientsSmall(int mouseX, int mouseY, UUID recipe) {
        TurretAssemblyRecipes.RecipeEntry recipeEntry = TurretAssemblyRecipes.INSTANCE.getRecipeEntry(recipe);
        RecipeEntryItem[] ingredients = recipeEntry.resources;
        String rf = String.format("%d RF/t", MathHelper.func_76123_f((float)((float)recipeEntry.fluxPerTick * (this.assembly.hasSpeedUpgrade() ? 1.1f : 1.0f))));
        String ticks = TmrClientUtils.getTimeFromTicks(recipeEntry.ticksProcessing);
        int textWidth = Math.max(Math.max(ingredients.length * 9, this.frDetails.func_78256_a(rf) + 10), this.frDetails.func_78256_a(ticks) + 10);
        int xPos = mouseX + 12;
        int yPos = mouseY - 12;
        int height = ingredients.length > 0 ? 31 : 18;
        this.field_73735_i = 300.0f;
        GuiTurretAssembly.field_146296_j.field_77023_b = 300.0f;
        int bkgColor = -267386864;
        int lightBg = 0x505000FF;
        int darkBg = (lightBg & 0xFEFEFE) >> 1 | lightBg & 0xFF000000;
        this.func_73733_a(xPos - 3, yPos - 4, xPos + textWidth + 3, yPos - 3, bkgColor, bkgColor);
        this.func_73733_a(xPos - 3, yPos + height + 3, xPos + textWidth + 3, yPos + height + 4, bkgColor, bkgColor);
        this.func_73733_a(xPos - 3, yPos - 3, xPos + textWidth + 3, yPos + height + 3, bkgColor, bkgColor);
        this.func_73733_a(xPos - 4, yPos - 3, xPos - 3, yPos + height + 3, bkgColor, bkgColor);
        this.func_73733_a(xPos + textWidth + 3, yPos - 3, xPos + textWidth + 4, yPos + height + 3, bkgColor, bkgColor);
        this.func_73733_a(xPos - 3, yPos - 3 + 1, xPos - 3 + 1, yPos + height + 3 - 1, lightBg, darkBg);
        this.func_73733_a(xPos + textWidth + 2, yPos - 3 + 1, xPos + textWidth + 3, yPos + height + 3 - 1, lightBg, darkBg);
        this.func_73733_a(xPos - 3, yPos - 3, xPos + textWidth + 3, yPos - 3 + 1, lightBg, lightBg);
        this.func_73733_a(xPos - 3, yPos + height + 2, xPos + textWidth + 3, yPos + height + 3, darkBg, darkBg);
        if (ingredients.length > 0) {
            this.func_73733_a(xPos - 2, yPos + 10, xPos + textWidth + 2, yPos + 11, lightBg, darkBg);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(Resources.GUI_ASSEMBLY_CRF.getResource());
        GL11.glPushMatrix();
        if (ingredients.length < 1) {
            GL11.glTranslatef((float)0.0f, (float)-10.0f, (float)0.0f);
        } else {
            GL11.glTranslatef((float)0.0f, (float)3.0f, (float)0.0f);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)xPos, (float)yPos, (float)0.0f);
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        this.func_73729_b(0, 20, 230, 94, 16, 16);
        this.func_73729_b(0, 40, 230, 110, 16, 16);
        GL11.glPopMatrix();
        GL11.glDisable((int)2929);
        this.frDetails.func_78276_b(rf, xPos + 10, yPos + 10, -1);
        this.frDetails.func_78276_b(ticks, xPos + 10, yPos + 20, -1);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
        for (int i = 0; i < ingredients.length; ++i) {
            ItemStack[] entryStacks = ingredients[i].getEntryItemStacks();
            ItemStack stack = entryStacks[(int)(this.lastTimestamp / 1000L % (long)entryStacks.length)];
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(xPos + i * 9), (float)yPos, (float)0.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
            GL11.glEnable((int)32826);
            RenderHelper.func_74520_c();
            this.drawItemStack(stack, 0, 0, 500.0f, true);
            GL11.glPopMatrix();
        }
        RenderHelper.func_74520_c();
        this.field_73735_i = 0.0f;
        GuiTurretAssembly.field_146296_j.field_77023_b = 0.0f;
    }

    private void drawRFluxLabel(int mouseX, int mouseY) {
        String amount = String.format("%d / %d RF", this.assembly.getEnergyStored(ForgeDirection.DOWN), this.assembly.getMaxEnergyStored(ForgeDirection.DOWN));
        String consumption = String.format(Lang.translate(Lang.TASSEMBLY_RF_USING), this.assembly.fluxConsumption * (this.assembly.hasSpeedUpgrade() ? 4 : 1));
        int textWidth = Math.max(this.field_146289_q.func_78256_a(amount), this.field_146289_q.func_78256_a(consumption));
        int xPos = mouseX + 12;
        int yPos = mouseY - 12;
        int height = 18;
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)2929);
        this.field_73735_i = 400.0f;
        GuiTurretAssembly.field_146296_j.field_77023_b = 300.0f;
        int bkgColor = -267386864;
        int lightBg = 0x505000FF;
        int darkBg = (lightBg & 0xFEFEFE) >> 1 | lightBg & 0xFF000000;
        this.func_73733_a(xPos - 3, yPos - 4, xPos + textWidth + 3, yPos - 3, bkgColor, bkgColor);
        this.func_73733_a(xPos - 3, yPos + height + 3, xPos + textWidth + 3, yPos + height + 4, bkgColor, bkgColor);
        this.func_73733_a(xPos - 3, yPos - 3, xPos + textWidth + 3, yPos + height + 3, bkgColor, bkgColor);
        this.func_73733_a(xPos - 4, yPos - 3, xPos - 3, yPos + height + 3, bkgColor, bkgColor);
        this.func_73733_a(xPos + textWidth + 3, yPos - 3, xPos + textWidth + 4, yPos + height + 3, bkgColor, bkgColor);
        this.func_73733_a(xPos - 3, yPos - 3 + 1, xPos - 3 + 1, yPos + height + 3 - 1, lightBg, darkBg);
        this.func_73733_a(xPos + textWidth + 2, yPos - 3 + 1, xPos + textWidth + 3, yPos + height + 3 - 1, lightBg, darkBg);
        this.func_73733_a(xPos - 3, yPos - 3, xPos + textWidth + 3, yPos - 3 + 1, lightBg, lightBg);
        this.func_73733_a(xPos - 3, yPos + height + 2, xPos + textWidth + 3, yPos + height + 3, darkBg, darkBg);
        this.field_73735_i = 0.0f;
        GuiTurretAssembly.field_146296_j.field_77023_b = 0.0f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)xPos, (float)yPos, (float)0.0f);
        GL11.glDisable((int)2929);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
        this.field_146289_q.func_78276_b(amount, 0, 0, -12632257);
        this.field_146289_q.func_78276_b(consumption, 0, 9, -12632257);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.0f);
        this.field_146289_q.func_78276_b(amount, 0, 0, -1);
        this.field_146289_q.func_78276_b(consumption, 0, 9, -1);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
        RenderHelper.func_74520_c();
        GL11.glEnable((int)32826);
        GL11.glPopMatrix();
    }

    public void func_146282_l() {
        this.shiftPressed = false;
        super.func_146282_l();
    }

    public void func_146281_b() {
        this.assembly.syncStacks = true;
        super.func_146281_b();
    }

    protected void func_73869_a(char keyChar, int keyCode) {
        this.shiftPressed = keyCode == 42;
        super.func_73869_a(keyChar, keyCode);
    }

    public void func_146274_d() {
        super.func_146274_d();
        if (this.cacheRecipes.size() > 4 && this.assembly.currCrafting == null) {
            int dWheelDir = Mouse.getEventDWheel();
            if (dWheelDir < 0) {
                this.scrollPos = Math.min(this.cacheRecipes.size() - 4, this.scrollPos + 1);
            } else if (dWheelDir > 0) {
                this.scrollPos = Math.max(0, this.scrollPos - 1);
            }
        }
    }

    private GuiAssemblyCategoryTab[] getSortedTabs() {
        GuiAssemblyCategoryTab[] tabs = this.groupBtns.keySet().toArray(new GuiAssemblyCategoryTab[this.groupBtns.size()]);
        Arrays.sort(tabs, new Comparator<GuiAssemblyCategoryTab>(){

            @Override
            public int compare(GuiAssemblyCategoryTab o1, GuiAssemblyCategoryTab o2) {
                return o1.field_146127_k > o2.field_146127_k ? 1 : (o1.field_146127_k < o2.field_146127_k ? -1 : 0);
            }
        });
        return tabs;
    }

    protected void func_146284_a(GuiButton btn) {
        if (btn.field_146127_k == this.cancelTask.field_146127_k) {
            PacketRegistry.sendToServer((IMessage)new PacketInitAssemblyCrafting(this.assembly));
        } else if (btn.field_146127_k == this.automate.field_146127_k || btn.field_146127_k == this.manual.field_146127_k) {
            PacketRegistry.sendToServer((IMessage)new PacketAssemblyToggleAutomate(this.assembly));
        } else if (btn instanceof GuiAssemblyCategoryTab && this.groupBtns.containsKey(btn)) {
            this.scrollPos = 0;
            TurretAssemblyRecipes.RecipeGroup grp = this.groupBtns.get(btn);
            GuiAssemblyCategoryTab[] tabs = this.getSortedTabs();
            for (int i = 0; i < tabs.length; ++i) {
                tabs[i].field_146124_l = true;
                if (tabs[i] != btn) continue;
                currOpenTab = i;
            }
            btn.field_146124_l = false;
            this.loadGroupRecipes(grp);
        } else if (btn.field_146127_k == this.groupDown.field_146127_k) {
            GuiAssemblyCategoryTab[] tabs = this.getSortedTabs();
            if (scrollGroupPos + 4 < tabs.length) {
                ++scrollGroupPos;
                for (int i = 0; i < tabs.length; ++i) {
                    tabs[i].field_146129_i -= 15;
                    tabs[i].field_146125_m = i >= scrollGroupPos && i < scrollGroupPos + 4;
                }
                this.groupUp.field_146125_m = true;
                if (scrollGroupPos + 4 >= tabs.length) {
                    this.groupDown.field_146125_m = false;
                }
            }
        } else if (btn.field_146127_k == this.groupUp.field_146127_k) {
            GuiAssemblyCategoryTab[] tabs = this.getSortedTabs();
            if (scrollGroupPos > 0) {
                --scrollGroupPos;
                for (int i = 0; i < tabs.length; ++i) {
                    tabs[i].field_146129_i += 15;
                    tabs[i].field_146125_m = i >= scrollGroupPos && i < scrollGroupPos + 4;
                }
                this.groupDown.field_146125_m = true;
                if (scrollGroupPos <= 0) {
                    this.groupUp.field_146125_m = false;
                }
            }
        } else {
            super.func_146284_a(btn);
        }
    }
}

