/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.tcu;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import de.sanandrew.mods.turretmod.client.gui.control.GuiSlimButton;
import de.sanandrew.mods.turretmod.client.gui.tcu.GuiTCUHelper;
import de.sanandrew.mods.turretmod.client.gui.tcu.GuiTurretCtrlUnit;
import de.sanandrew.mods.turretmod.client.util.TmrClientUtils;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.network.PacketRegistry;
import de.sanandrew.mods.turretmod.network.PacketUpdateTargets;
import de.sanandrew.mods.turretmod.util.Lang;
import de.sanandrew.mods.turretmod.util.PlayerList;
import de.sanandrew.mods.turretmod.util.Resources;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.MathHelper;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiTcuPlayerTargets
extends GuiScreen
implements GuiTurretCtrlUnit {
    private EntityTurret turret;
    private int guiLeft;
    private int guiTop;
    private Map<UUID, Boolean> tempTargetList = new HashMap<UUID, Boolean>();
    private float scroll = 0.0f;
    private float scrollAmount = 0.0f;
    private boolean isScrolling;
    private boolean canScroll;
    private boolean prevIsLmbDown;
    private boolean doSelectAll;
    private boolean doDeselectAll;
    private GuiButton selectAll;
    private GuiButton deselectAll;

    public GuiTcuPlayerTargets(EntityTurret turret) {
        this.turret = turret;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - 176) / 2;
        this.guiTop = (this.field_146295_m - 222) / 2;
        this.field_146292_n.clear();
        GuiTCUHelper.initGui(this);
        int center = this.guiLeft + 13;
        this.selectAll = new GuiSlimButton(this.field_146292_n.size(), center, this.guiTop + 138, 150, Lang.translate(Lang.TCU_TARGET_BTN, "selectAll"));
        this.field_146292_n.add(this.selectAll);
        this.deselectAll = new GuiSlimButton(this.field_146292_n.size(), center, this.guiTop + 151, 150, Lang.translate(Lang.TCU_TARGET_BTN, "deselectAll"));
        this.field_146292_n.add(this.deselectAll);
        GuiTCUHelper.pagePlayerTargets.field_146124_l = false;
        this.updateList();
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.turret.field_70128_L) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        this.canScroll = this.tempTargetList.size() >= 11;
        this.scrollAmount = Math.max(0.0f, 1.0f / ((float)this.tempTargetList.size() - 11.0f));
    }

    public void func_73863_a(int mouseX, int mouseY, float partTicks) {
        boolean isLmbDown = Mouse.isButtonDown((int)0);
        int scrollMinX = this.guiLeft + 163;
        int scrollMaxX = this.guiLeft + 163 + 9;
        int scrollMinY = this.guiTop + 19;
        int scrollMaxY = this.guiTop + 134;
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.func_146276_q_();
        if (!this.isScrolling && this.canScroll && isLmbDown && mouseX >= scrollMinX && mouseX < scrollMaxX && mouseY > scrollMinY && mouseY < scrollMaxY) {
            this.isScrolling = true;
        } else if (!isLmbDown) {
            this.isScrolling = false;
        }
        if (this.isScrolling) {
            this.scroll = Math.max(0.0f, Math.min(1.0f, (float)(mouseY - 2 - scrollMinY) / 109.0f));
        }
        this.field_146297_k.field_71446_o.func_110577_a(Resources.GUI_TCU_TARGETS.getResource());
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, 176, 222);
        this.func_73729_b(this.guiLeft + 163, this.guiTop + 19 + MathHelper.func_76141_d((float)(this.scroll * 109.0f)), 176, this.canScroll ? 0 : 6, 6, 6);
        GL11.glEnable((int)3089);
        TmrClientUtils.doGlScissor(this.guiLeft + 6, this.guiTop + 19, 153, 115);
        int offsetY = Math.round(-this.scroll * (float)(this.tempTargetList.size() - 11)) * (this.field_146289_q.field_78288_b + 1);
        boolean targetListChanged = false;
        for (Map.Entry<UUID, Boolean> entry : this.tempTargetList.entrySet()) {
            int btnTexOffY = 12 + (entry.getValue() != false ? 16 : 0);
            int btnMinOffY = this.guiTop + 20;
            int btnMaxOffY = this.guiTop + 20 + 110;
            if (this.doSelectAll && !entry.getValue().booleanValue()) {
                this.turret.getTargetProcessor().updatePlayerTarget(entry.getKey(), true);
                targetListChanged = true;
            } else if (this.doDeselectAll && entry.getValue().booleanValue()) {
                this.turret.getTargetProcessor().updatePlayerTarget(entry.getKey(), false);
                targetListChanged = true;
            }
            if (mouseY >= btnMinOffY && mouseY < btnMaxOffY && mouseX >= this.guiLeft + 10 && mouseX < this.guiLeft + 18 && mouseY >= this.guiTop + 20 + offsetY && mouseY < this.guiTop + 28 + offsetY) {
                btnTexOffY += 8;
                if (isLmbDown && !this.prevIsLmbDown) {
                    this.turret.getTargetProcessor().updatePlayerTarget(entry.getKey(), entry.getValue() == false);
                    targetListChanged = true;
                }
            }
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(Resources.GUI_TCU_TARGETS.getResource());
            this.func_73729_b(this.guiLeft + 10, this.guiTop + 20 + offsetY, 176, btnTexOffY, 8, 8);
            int textColor = 0xFFFFFF;
            this.field_146289_q.func_85187_a(PlayerList.INSTANCE.getPlayerName(entry.getKey()), this.guiLeft + 20, this.guiTop + 20 + offsetY, textColor, false);
            offsetY += this.field_146289_q.field_78288_b + 1;
        }
        GL11.glDisable((int)3089);
        this.doSelectAll = false;
        this.doDeselectAll = false;
        if (targetListChanged) {
            this.updateTargets();
            this.updateList();
        }
        this.prevIsLmbDown = isLmbDown;
        GuiTCUHelper.drawScreen(this);
        super.func_73863_a(mouseX, mouseY, partTicks);
    }

    public void func_146274_d() {
        super.func_146274_d();
        if (this.canScroll) {
            int dWheelDir = Mouse.getEventDWheel();
            if (dWheelDir < 0) {
                this.scroll = Math.min(1.0f, this.scroll + this.scrollAmount);
            } else if (dWheelDir > 0) {
                this.scroll = Math.max(0.0f, this.scroll - this.scrollAmount);
            }
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button == this.selectAll) {
            this.doSelectAll = true;
        } else if (button == this.deselectAll) {
            this.doDeselectAll = true;
        } else if (!GuiTCUHelper.actionPerformed(button, this)) {
            super.func_146284_a(button);
        }
    }

    private void updateTargets() {
        PacketRegistry.sendToServer((IMessage)new PacketUpdateTargets(this.turret.getTargetProcessor()));
    }

    @Override
    public int getGuiLeft() {
        return this.guiLeft;
    }

    @Override
    public int getGuiTop() {
        return this.guiTop;
    }

    @Override
    public List getButtonList() {
        return this.field_146292_n;
    }

    @Override
    public EntityTurret getTurret() {
        return this.turret;
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    @Override
    public Minecraft getMc() {
        return this.field_146297_k;
    }

    public boolean func_73868_f() {
        return false;
    }

    private void updateList() {
        TreeMap<UUID, Boolean> btwSortMapNm = new TreeMap<UUID, Boolean>(new TargetComparatorName());
        btwSortMapNm.putAll(PlayerList.INSTANCE.getDefaultPlayerList());
        btwSortMapNm.putAll(this.turret.getTargetProcessor().getPlayerTargets());
        this.tempTargetList = btwSortMapNm;
    }

    private static final class TargetComparatorName
    implements Comparator<UUID> {
        private TargetComparatorName() {
        }

        @Override
        public int compare(UUID o1, UUID o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

