/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.tinfo.entry;

import de.sanandrew.mods.turretmod.client.gui.tinfo.GuiTurretInfo;
import de.sanandrew.mods.turretmod.client.gui.tinfo.entry.TurretInfoEntry;
import de.sanandrew.mods.turretmod.client.shader.ShaderCallback;
import de.sanandrew.mods.turretmod.client.util.ShaderHelper;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import de.sanandrew.mods.turretmod.registry.ammo.AmmoRegistry;
import de.sanandrew.mods.turretmod.registry.ammo.TurretAmmo;
import de.sanandrew.mods.turretmod.registry.assembly.TurretAssemblyRecipes;
import de.sanandrew.mods.turretmod.util.Lang;
import de.sanandrew.mods.turretmod.util.Resources;
import de.sanandrew.mods.turretmod.util.TmrConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.EntityList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;

public class TurretInfoEntryAmmo
extends TurretInfoEntry {
    private int drawHeight;
    private int shownAmmo;
    private TurretAmmo[] ammos;
    private List<GuiButtonAmmoItem> ammoBtn;
    private long lastTimestamp;

    public TurretInfoEntryAmmo(UUID groupId) {
        this(AmmoRegistry.INSTANCE.getTypes(groupId));
    }

    private TurretInfoEntryAmmo(TurretAmmo[] ammos) {
        super(ammos[0].getStoringAmmoItem(), Lang.translate(Lang.TINFO_ENTRY_AMMO_NAME, ammos[0].getInfoName()));
        this.ammos = ammos;
    }

    @Override
    public void initEntry(GuiTurretInfo gui) {
        super.initEntry(gui);
        this.ammoBtn = new ArrayList<GuiButtonAmmoItem>(MathHelper.func_76143_f((double)((double)this.ammos.length * 1.3333333333333333)));
        this.shownAmmo = 0;
        for (int i = 0; i < this.ammos.length; ++i) {
            GuiButtonAmmoItem btn = new GuiButtonAmmoItem(gui.getButtonList().size(), gui.entryX + i * 16, gui.entryY, i);
            this.ammoBtn.add(btn);
            btn.field_146124_l = i != this.shownAmmo;
            gui.getButtonList().add(btn);
        }
    }

    @Override
    public void drawPage(GuiTurretInfo gui, int mouseX, int mouseY, int scrollY, float partTicks) {
        TurretAmmo ammo = this.ammos[this.shownAmmo];
        gui.field_146297_k.field_71466_p.func_78276_b(EnumChatFormatting.ITALIC + Lang.translate(this.getTitle()), 2, 20, -16744261);
        Gui.func_73734_a((int)2, (int)30, (int)166, (int)31, (int)-16744261);
        gui.field_146297_k.func_110434_K().func_110577_a(Resources.GUI_TURRETINFO.getResource());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.func_73729_b(2, 34, 192, 18, 34, 34);
        TurretInfoEntryAmmo.drawItem(gui.field_146297_k, 3, 35, ItemRegistry.ammo.getAmmoItem(1, ammo), 2.0f);
        gui.field_146297_k.field_71466_p.func_85187_a(this.txtRounds, 42, 34, -9803158, false);
        gui.field_146297_k.field_71466_p.func_85187_a(String.format("%d", ammo.getAmmoCapacity()), 45, 43, -16777216, false);
        gui.field_146297_k.field_71466_p.func_85187_a(this.txtDps, 42, 54, -9803158, false);
        gui.field_146297_k.field_71466_p.func_85187_a(String.format(this.txtHealthVal, Float.valueOf(ammo.getInfoDamage())), 45, 63, -16777216, false);
        gui.field_146297_k.field_71466_p.func_85187_a(this.txtTurret, 42, 74, -9803158, false);
        gui.field_146297_k.field_71466_p.func_85187_a(Lang.translate("entity.%s.name", EntityList.field_75626_c.get(ammo.getTurret())), 45, 83, -16777216, false);
        gui.field_146297_k.field_71466_p.func_85187_a(this.txtCrft, 42, 94, -9803158, false);
        String text = Lang.translate(Lang.TINFO_ENTRY_AMMO_DESC, ammo.getInfoName()).replace("\\n", "\n");
        gui.field_146297_k.field_71466_p.func_78279_b(text, 2, 117, 166, -16777216);
        this.drawHeight = gui.field_146297_k.field_71466_p.func_78267_b(text, 166) + 2;
        Gui.func_73734_a((int)2, (int)114, (int)166, (int)115, (int)-16744261);
        TurretAssemblyRecipes.RecipeEntry recipeEntry = TurretAssemblyRecipes.INSTANCE.getRecipeEntry(ammo.getRecipeId());
        for (int i = 0; i < recipeEntry.resources.length; ++i) {
            ItemStack[] stacks = recipeEntry.resources[i].getEntryItemStacks();
            TurretInfoEntryAmmo.drawMiniItem(gui, 45 + 10 * i, 103, mouseX, mouseY, scrollY, stacks[(int)(this.lastTimestamp / 1000L % (long)stacks.length)], recipeEntry.resources[i].shouldDrawTooltip());
        }
        this.drawHeight += 116;
        Gui.func_73734_a((int)0, (int)scrollY, (int)168, (int)(16 + scrollY), (int)Integer.MIN_VALUE);
        long time = System.currentTimeMillis();
        if (this.lastTimestamp + 1000L < time) {
            this.lastTimestamp = time;
        }
    }

    @Override
    public int getPageHeight() {
        return this.drawHeight;
    }

    @Override
    public boolean actionPerformed(GuiButton btn) {
        if (btn instanceof GuiButtonAmmoItem) {
            this.shownAmmo = ((GuiButtonAmmoItem)btn).ammoIndex;
            for (GuiButtonAmmoItem ammoBtn : this.ammoBtn) {
                ammoBtn.field_146124_l = ammoBtn.ammoIndex != this.shownAmmo;
            }
            return true;
        }
        return super.actionPerformed(btn);
    }

    private class GuiButtonAmmoItem
    extends GuiButton {
        public final int ammoIndex;
        public final ItemStack stack;
        private ShaderCallback shaderCallback;

        public GuiButtonAmmoItem(int id, int x, int y, int index) {
            super(id, x, y, 16, 16, "");
            this.shaderCallback = new ShaderCallback(){

                @Override
                public void call(int shader) {
                    TextureManager texMgr = Minecraft.func_71410_x().field_71446_o;
                    int imageUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"image");
                    OpenGlHelper.func_77473_a((int)33984);
                    GL11.glBindTexture((int)3553, (int)texMgr.func_110581_b(texMgr.func_130087_a(GuiButtonAmmoItem.this.stack.func_94608_d())).func_110552_b());
                    ARBShaderObjects.glUniform1iARB((int)imageUniform, (int)0);
                }
            };
            this.ammoIndex = index;
            this.stack = ItemRegistry.ammo.getAmmoItem(1, TurretInfoEntryAmmo.this.ammos[this.ammoIndex]);
        }

        public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                Gui.func_73734_a((int)this.field_146128_h, (int)this.field_146129_i, (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + 1), (int)-1610612736);
                Gui.func_73734_a((int)this.field_146128_h, (int)(this.field_146129_i + this.field_146121_g - 1), (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + this.field_146121_g), (int)-1610612736);
                Gui.func_73734_a((int)this.field_146128_h, (int)(this.field_146129_i + 1), (int)(this.field_146128_h + 1), (int)(this.field_146129_i + this.field_146121_g - 1), (int)0x40000000);
                Gui.func_73734_a((int)(this.field_146128_h + this.field_146120_f - 1), (int)(this.field_146129_i + 1), (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + this.field_146121_g - 1), (int)0x40000000);
                if (this.field_146124_l) {
                    Gui.func_73734_a((int)this.field_146128_h, (int)this.field_146129_i, (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + this.field_146121_g), (int)Integer.MIN_VALUE);
                    int texture = 0;
                    boolean shaders = ShaderHelper.areShadersEnabled();
                    if (shaders) {
                        OpenGlHelper.func_77473_a((int)(33984 + TmrConfiguration.glSecondaryTextureUnit));
                        texture = GL11.glGetInteger((int)32873);
                    }
                    ShaderHelper.useShader(ShaderHelper.grayscaleItem, this.shaderCallback);
                    TurretInfoEntry.drawItem(mc, this.field_146128_h, this.field_146129_i, this.stack, 1.0f);
                    ShaderHelper.releaseShader();
                    if (shaders) {
                        OpenGlHelper.func_77473_a((int)(33984 + TmrConfiguration.glSecondaryTextureUnit));
                        GL11.glBindTexture((int)3553, (int)texture);
                        OpenGlHelper.func_77473_a((int)33984);
                    }
                } else {
                    Gui.func_73734_a((int)this.field_146128_h, (int)this.field_146129_i, (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + this.field_146121_g), (int)-2130706433);
                    TurretInfoEntry.drawItem(mc, this.field_146128_h, this.field_146129_i, this.stack, 1.0f);
                }
            }
        }
    }
}

