/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.tinfo.entry;

import de.sanandrew.mods.turretmod.client.gui.tinfo.GuiTurretInfo;
import de.sanandrew.mods.turretmod.client.gui.tinfo.entry.TurretInfoEntry;
import de.sanandrew.mods.turretmod.client.util.TmrClientUtils;
import de.sanandrew.mods.turretmod.util.Lang;
import de.sanandrew.mods.turretmod.util.Resources;
import de.sanandrew.mods.turretmod.util.TmrUtils;
import java.util.ArrayList;
import java.util.List;
import net.darkhax.bookshelf.lib.javatuples.Triplet;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.lwjgl.opengl.GL11;

public class TurretInfoEntryMiscCraftable
extends TurretInfoEntry {
    private final String desc;
    private final Triplet<ItemStack[][], Integer, Integer> crafting;
    private int drawHeight;
    private long lastTimestamp;

    public TurretInfoEntryMiscCraftable(IRecipe recipe) {
        this(recipe.func_77571_b(), recipe);
    }

    private TurretInfoEntryMiscCraftable(ItemStack stack, IRecipe recipe) {
        super(stack, String.format("%s.name", stack.func_77977_a()));
        this.desc = String.format("%s.desc", stack.func_77977_a());
        this.crafting = recipe != null ? (recipe instanceof ShapedOreRecipe ? TurretInfoEntryMiscCraftable.getCrafting((ShapedOreRecipe)recipe) : (recipe instanceof ShapedRecipes ? TurretInfoEntryMiscCraftable.getCrafting((ShapedRecipes)recipe) : Triplet.with(null, (Object)0, (Object)0))) : Triplet.with(null, (Object)0, (Object)0);
    }

    private static Triplet<ItemStack[][], Integer, Integer> getCrafting(ShapedRecipes cRecipe) {
        ItemStack[][] crfArray = new ItemStack[cRecipe.field_77576_b * cRecipe.field_77577_c][];
        for (int i = 0; i < cRecipe.field_77577_c; ++i) {
            for (int j = 0; j < cRecipe.field_77576_b; ++j) {
                ItemStack recpStack = cRecipe.field_77574_d[i * cRecipe.field_77576_b + j];
                ItemStack[] recpStacks = null;
                if (recpStack != null) {
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    if (recpStack.func_77960_j() == Short.MAX_VALUE) {
                        recpStack.func_77973_b().func_150895_a(recpStack.func_77973_b(), CreativeTabs.field_78027_g, stacks);
                    } else {
                        stacks.add(recpStack);
                    }
                    recpStacks = stacks.toArray(new ItemStack[stacks.size()]);
                }
                crfArray[i * cRecipe.field_77576_b + j] = recpStacks;
            }
        }
        return Triplet.with((Object)crfArray, (Object)cRecipe.field_77576_b, (Object)cRecipe.field_77577_c);
    }

    private static Triplet<ItemStack[][], Integer, Integer> getCrafting(ShapedOreRecipe cRecipe) {
        int recipeWidth = TmrUtils.getOreRecipeWidth(cRecipe);
        int recipeHeight = TmrUtils.getOreRecipeHeight(cRecipe);
        ItemStack[][] crfArray = new ItemStack[recipeWidth * recipeHeight][];
        for (int i = 0; i < recipeHeight; ++i) {
            for (int j = 0; j < recipeWidth; ++j) {
                Object recpObj = cRecipe.getInput()[i * recipeWidth + j];
                ItemStack[] recpStacks = null;
                if (recpObj != null) {
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    if (recpObj instanceof ItemStack) {
                        ItemStack recpStack = (ItemStack)recpObj;
                        if (recpStack.func_77960_j() == Short.MAX_VALUE) {
                            recpStack.func_77973_b().func_150895_a(recpStack.func_77973_b(), CreativeTabs.field_78027_g, stacks);
                        } else {
                            stacks.add(recpStack);
                        }
                    } else if (recpObj instanceof ArrayList) {
                        for (ItemStack recpStack : (ArrayList)recpObj) {
                            if (recpStack == null) continue;
                            if (recpStack.func_77960_j() == Short.MAX_VALUE) {
                                recpStack.func_77973_b().func_150895_a(recpStack.func_77973_b(), CreativeTabs.field_78027_g, stacks);
                                continue;
                            }
                            stacks.add(recpStack);
                        }
                    }
                    recpStacks = stacks.toArray(new ItemStack[stacks.size()]);
                }
                crfArray[i * recipeWidth + j] = recpStacks;
            }
        }
        return Triplet.with((Object)crfArray, (Object)recipeWidth, (Object)recipeHeight);
    }

    @Override
    public void drawPage(GuiTurretInfo gui, int mouseX, int mouseY, int scrollY, float partTicks) {
        gui.field_146297_k.field_71466_p.func_78276_b(EnumChatFormatting.ITALIC + Lang.translate(this.getTitle()), 2, 2, -16744261);
        Gui.func_73734_a((int)2, (int)12, (int)166, (int)13, (int)-16744261);
        gui.field_146297_k.func_110434_K().func_110577_a(Resources.GUI_TURRETINFO.getResource());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.func_73729_b(2, 16, 192, 18, 34, 34);
        TurretInfoEntryMiscCraftable.drawItem(gui.field_146297_k, 3, 17, this.getIcon(), 2.0f);
        gui.field_146297_k.field_71466_p.func_85187_a(this.txtWorkbench, 42, 16, -9803158, false);
        this.drawHeight = 27 + 9 * (Integer)this.crafting.getValue2();
        Gui.func_73734_a((int)2, (int)this.drawHeight, (int)166, (int)(this.drawHeight + 1), (int)-16744261);
        String text = Lang.translate(this.desc).replace("\\n", "\n");
        gui.field_146297_k.field_71466_p.func_78279_b(text, 2, this.drawHeight + 3, 166, -16777216);
        this.drawHeight = gui.field_146297_k.field_71466_p.func_78267_b(text, 166) + this.drawHeight + 3 + 2;
        int maxI = (Integer)this.crafting.getValue1();
        for (int i = 0; i < maxI; ++i) {
            int maxJ = (Integer)this.crafting.getValue2();
            for (int j = 0; j < maxJ; ++j) {
                ItemStack[] crfStack = ((ItemStack[][])this.crafting.getValue0())[i * 3 + j];
                if (crfStack == null || crfStack.length <= 0) continue;
                TurretInfoEntryMiscCraftable.drawCrfItem(gui, 42 + 9 * j, 25 + 9 * i, mouseX, mouseY, scrollY, crfStack[(int)(this.lastTimestamp / 1000L % (long)crfStack.length)], true);
            }
        }
        long time = System.currentTimeMillis();
        if (this.lastTimestamp + 1000L < time) {
            this.lastTimestamp = time;
        }
    }

    private static void drawCrfItem(GuiTurretInfo gui, int x, int y, int mouseX, int mouseY, int scrollY, ItemStack stack, boolean drawTooltip) {
        boolean mouseOver;
        boolean bl = mouseOver = mouseY >= 0 && mouseY < 183 && mouseX >= x && mouseX < x + 9 && mouseY >= y - scrollY && mouseY < y + 9 - scrollY;
        if (mouseOver) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)(163 + scrollY), (float)64.0f);
            Gui.func_73734_a((int)0, (int)0, (int)168, (int)20, (int)-805306368);
            List<?> tooltip = TmrClientUtils.getTooltipWithoutShift(stack);
            gui.field_146297_k.field_71466_p.func_85187_a(tooltip.get(0).toString(), 22, 2, -1, false);
            if (drawTooltip && tooltip.size() > 1) {
                gui.field_146297_k.field_71466_p.func_85187_a(tooltip.get(1).toString(), 22, 11, -8355712, false);
            }
            GL11.glEnable((int)32826);
            RenderHelper.func_74520_c();
            TurretInfoEntryMiscCraftable.ITEM_RENDER.field_77023_b = -50.0f;
            ITEM_RENDER.func_82406_b(gui.field_146297_k.field_71466_p, gui.field_146297_k.func_110434_K(), stack, 2, 2);
            ITEM_RENDER.func_77021_b(gui.field_146297_k.field_71466_p, gui.field_146297_k.func_110434_K(), stack, 2, 2);
            TurretInfoEntryMiscCraftable.ITEM_RENDER.field_77023_b = 0.0f;
            RenderHelper.func_74518_a();
            GL11.glDisable((int)32826);
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)32.0f);
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        gui.field_146297_k.func_110434_K().func_110577_a(Resources.GUI_TURRETINFO.getResource());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.func_73729_b(0, 0, 192, 0, 18, 18);
        GL11.glEnable((int)32826);
        RenderHelper.func_74520_c();
        TurretInfoEntryMiscCraftable.ITEM_RENDER.field_77023_b = -50.0f;
        ITEM_RENDER.func_82406_b(gui.field_146297_k.field_71466_p, gui.field_146297_k.func_110434_K(), stack, 1, 1);
        ITEM_RENDER.func_77021_b(gui.field_146297_k.field_71466_p, gui.field_146297_k.func_110434_K(), stack, 1, 1);
        TurretInfoEntryMiscCraftable.ITEM_RENDER.field_77023_b = 0.0f;
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        if (mouseOver) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
            Gui.func_73734_a((int)1, (int)1, (int)17, (int)17, (int)-2130706433);
        }
        GL11.glPopMatrix();
    }

    @Override
    public int getPageHeight() {
        return this.drawHeight;
    }
}

