/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.tinfo.entry;

import de.sanandrew.mods.turretmod.client.gui.tinfo.GuiTurretInfo;
import de.sanandrew.mods.turretmod.client.gui.tinfo.entry.TurretInfoEntry;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import de.sanandrew.mods.turretmod.registry.ammo.AmmoRegistry;
import de.sanandrew.mods.turretmod.registry.ammo.TurretAmmo;
import de.sanandrew.mods.turretmod.registry.assembly.RecipeEntryItem;
import de.sanandrew.mods.turretmod.registry.assembly.TurretAssemblyRecipes;
import de.sanandrew.mods.turretmod.registry.turret.TurretInfo;
import de.sanandrew.mods.turretmod.registry.turret.TurretRegistry;
import de.sanandrew.mods.turretmod.util.Lang;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class TurretInfoEntryTurret
extends TurretInfoEntry {
    private int drawHeight;
    private float rotation;
    private long lastTimestamp;
    private Class<? extends EntityTurret> turretClass;
    private WeakReference<EntityTurret> turretRenderCache;
    private TurretInfoValues values;

    public TurretInfoEntryTurret(Class<? extends EntityTurret> turret) {
        this(TurretRegistry.INSTANCE.getInfo(turret));
        this.turretClass = turret;
    }

    private TurretInfoEntryTurret(TurretInfo info) {
        super(ItemRegistry.turret.getTurretItem(1, info), Lang.translate("entity.%s.name", EntityList.field_75626_c.get(info.getTurretClass())));
        this.values = new TurretInfoValues(info);
    }

    @Override
    public void drawPage(GuiTurretInfo gui, int mouseX, int mouseY, int scrollY, float partTicks) {
        int i;
        int turretHeight = 82;
        int valueHeight = 113;
        gui.field_146297_k.field_71466_p.func_78276_b(EnumChatFormatting.ITALIC + this.values.name, 2, 2, -16744261);
        Gui.func_73734_a((int)2, (int)12, (int)166, (int)13, (int)-16744261);
        gui.doEntryScissoring(2, 15, 54, 82);
        Gui.func_73734_a((int)0, (int)0, (int)168, (int)183, (int)-16777216);
        this.drawTurret(gui.field_146297_k, 28, 35);
        gui.doEntryScissoring();
        gui.field_146297_k.field_71466_p.func_85187_a(this.txtHealth, 60, 15, -9803158, false);
        gui.field_146297_k.field_71466_p.func_85187_a(String.format(Lang.translate(Lang.TINFO_ENTRY_HEALTHVAL), Float.valueOf(this.values.health)), 63, 24, -16777216, false);
        gui.field_146297_k.field_71466_p.func_85187_a(this.txtRange, 60, 35, -9803158, false);
        gui.field_146297_k.field_71466_p.func_85187_a(String.format(Lang.translate(Lang.TINFO_ENTRY_RANGEVAL), this.values.range), 63, 44, -16777216, false);
        gui.field_146297_k.field_71466_p.func_85187_a(this.txtAmmoCap, 60, 55, -9803158, false);
        gui.field_146297_k.field_71466_p.func_85187_a(String.format(Lang.translate(Lang.TINFO_ENTRY_ROUNDSVAL), this.values.ammoCap), 63, 64, -16777216, false);
        gui.field_146297_k.field_71466_p.func_85187_a(this.txtAmmoUse, 60, 75, -9803158, false);
        gui.field_146297_k.field_71466_p.func_85187_a(this.txtCrft, 60, 95, -9803158, false);
        int descStart = Math.max(turretHeight, valueHeight);
        Gui.func_73734_a((int)2, (int)(2 + descStart), (int)166, (int)(3 + descStart), (int)-16744261);
        gui.field_146297_k.field_71466_p.func_78279_b(this.values.desc, 2, 5 + descStart, 166, -16777216);
        int descHeight = gui.field_146297_k.field_71466_p.func_78267_b(this.values.desc, 164) + 7;
        for (i = 0; i < this.values.ammoStacks.length; ++i) {
            TurretInfoEntryTurret.drawMiniItem(gui, 63 + 10 * i, 84, mouseX, mouseY, scrollY, this.values.ammoStacks[i], true);
        }
        for (i = 0; i < this.values.recipeStacks.length; ++i) {
            this.drawItemRecipe(gui, 63 + 10 * i, 104, mouseX, mouseY, scrollY, this.values.recipeStacks[i]);
        }
        this.drawHeight = descStart + descHeight;
        long time = System.currentTimeMillis();
        if (this.lastTimestamp + 1000L < time) {
            this.lastTimestamp = time;
        }
    }

    @Override
    public int getPageHeight() {
        return this.drawHeight;
    }

    private void drawTurret(Minecraft mc, int x, int y) {
        EntityTurret turret;
        if (this.turretRenderCache == null || this.turretRenderCache.get() == null || this.turretRenderCache.isEnqueued()) {
            try {
                this.turretRenderCache = new WeakReference<EntityTurret>(this.turretClass.getConstructor(World.class).newInstance(mc.field_71441_e));
            }
            catch (Exception e) {
                return;
            }
        }
        if ((turret = (EntityTurret)((Object)this.turretRenderCache.get())) == null) {
            return;
        }
        turret.inGui = true;
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2903);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)50.0f);
        GL11.glScalef((float)30.0f, (float)30.0f, (float)30.0f);
        GL11.glTranslatef((float)0.0f, (float)turret.field_70131_O, (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(135.0f + this.rotation), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.rotation += 0.2f;
        turret.field_70125_A = 0.0f;
        turret.field_70127_C = 0.0f;
        turret.field_70177_z = 0.0f;
        turret.field_70126_B = 0.0f;
        turret.field_70759_as = 0.0f;
        turret.field_70758_at = 0.0f;
        RenderManager.field_78727_a.field_78735_i = 180.0f;
        RenderManager.field_78727_a.func_147940_a((Entity)turret, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        GL11.glPopMatrix();
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }

    private void drawItemRecipe(GuiTurretInfo gui, int x, int y, int mouseX, int mouseY, int scrollY, RecipeEntryItem entryItem) {
        ItemStack[] entryStacks = entryItem.getEntryItemStacks();
        ItemStack stack = entryStacks[(int)(this.lastTimestamp / 1000L % (long)entryStacks.length)];
        TurretInfoEntryTurret.drawMiniItem(gui, x, y, mouseX, mouseY, scrollY, stack, entryItem.shouldDrawTooltip());
    }

    private static final class TurretInfoValues {
        public final String name;
        public final String desc;
        public final float health;
        public final int ammoCap;
        public final String range;
        public final RecipeEntryItem[] recipeStacks;
        public final ItemStack[] ammoStacks;

        public TurretInfoValues(TurretInfo info) {
            ArrayList<ItemStack> ammoItms = new ArrayList<ItemStack>();
            this.name = Lang.translate("entity.%s.name", EntityList.field_75626_c.get(info.getTurretClass()));
            this.desc = Lang.translate("entity.%s.desc", EntityList.field_75626_c.get(info.getTurretClass())).replace("\\n", "\n");
            this.range = info.getInfoRange();
            this.health = info.getTurretHealth();
            this.ammoCap = info.getBaseAmmoCapacity();
            List<TurretAmmo> ammos = AmmoRegistry.INSTANCE.getTypesForTurret(info.getTurretClass());
            for (TurretAmmo ammo : ammos) {
                ammoItms.add(ItemRegistry.ammo.getAmmoItem(1, ammo));
            }
            this.recipeStacks = TurretAssemblyRecipes.INSTANCE.getRecipeEntry((UUID)info.getRecipeId()).resources;
            this.ammoStacks = ammoItms.toArray(new ItemStack[ammoItms.size()]);
        }
    }
}

