/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.render;

import de.sanandrew.mods.turretmod.util.TurretModRebirth;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import net.darkhax.bookshelf.lib.ColorObject;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.Level;

public class ForcefieldCube {
    public Map<ForgeDirection, CubeFace[]> faces = new EnumMap<ForgeDirection, CubeFace[]>(ForgeDirection.class);
    private final Vec3 center;
    private final AxisAlignedBB boxAABB;
    public ColorObject boxColor;

    public ForcefieldCube(Vec3 mpCenter, AxisAlignedBB cubeBox, ColorObject color) {
        this.center = mpCenter;
        this.boxAABB = cubeBox;
        this.boxColor = color;
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            this.faces.put(direction, new CubeFace[]{new CubeFace(direction, mpCenter, cubeBox, color)});
        }
    }

    public ForcefieldCube clone() {
        return new ForcefieldCube(this.center, this.boxAABB, this.boxColor);
    }

    public void draw(Tessellator tess) {
        for (CubeFace[] faceList : this.faces.values()) {
            for (CubeFace facePart : faceList) {
                double maxV;
                double maxU;
                if (facePart.facing == ForgeDirection.NORTH) {
                    maxU = (facePart.endPt.field_72449_c - facePart.beginPt.field_72449_c) / 8.0;
                    maxV = (facePart.beginPt.field_72448_b - facePart.endPt.field_72448_b) / 8.0;
                    tess.func_78374_a(facePart.beginPt.field_72450_a - 5.0E-4, facePart.beginPt.field_72448_b, facePart.beginPt.field_72449_c, maxU, 0.0);
                    tess.func_78374_a(facePart.beginPt.field_72450_a - 5.0E-4, facePart.beginPt.field_72448_b, facePart.endPt.field_72449_c, 0.0, 0.0);
                    tess.func_78374_a(facePart.beginPt.field_72450_a - 5.0E-4, facePart.endPt.field_72448_b, facePart.endPt.field_72449_c, 0.0, maxV);
                    tess.func_78374_a(facePart.beginPt.field_72450_a - 5.0E-4, facePart.endPt.field_72448_b, facePart.beginPt.field_72449_c, maxU, maxV);
                    continue;
                }
                if (facePart.facing == ForgeDirection.EAST) {
                    maxU = (facePart.endPt.field_72450_a - facePart.beginPt.field_72450_a) / 8.0;
                    maxV = (facePart.beginPt.field_72448_b - facePart.endPt.field_72448_b) / 8.0;
                    tess.func_78374_a(facePart.endPt.field_72450_a, facePart.beginPt.field_72448_b, facePart.beginPt.field_72449_c - 5.0E-4, maxU, 0.0);
                    tess.func_78374_a(facePart.beginPt.field_72450_a, facePart.beginPt.field_72448_b, facePart.beginPt.field_72449_c - 5.0E-4, 0.0, 0.0);
                    tess.func_78374_a(facePart.beginPt.field_72450_a, facePart.endPt.field_72448_b, facePart.beginPt.field_72449_c - 5.0E-4, 0.0, maxV);
                    tess.func_78374_a(facePart.endPt.field_72450_a, facePart.endPt.field_72448_b, facePart.beginPt.field_72449_c - 5.0E-4, maxU, maxV);
                    continue;
                }
                if (facePart.facing == ForgeDirection.SOUTH) {
                    maxU = (facePart.endPt.field_72449_c - facePart.beginPt.field_72449_c) / 8.0;
                    maxV = (facePart.beginPt.field_72448_b - facePart.endPt.field_72448_b) / 8.0;
                    tess.func_78374_a(facePart.beginPt.field_72450_a + 5.0E-4, facePart.beginPt.field_72448_b, facePart.endPt.field_72449_c, maxU, 0.0);
                    tess.func_78374_a(facePart.beginPt.field_72450_a + 5.0E-4, facePart.beginPt.field_72448_b, facePart.beginPt.field_72449_c, 0.0, 0.0);
                    tess.func_78374_a(facePart.beginPt.field_72450_a + 5.0E-4, facePart.endPt.field_72448_b, facePart.beginPt.field_72449_c, 0.0, maxV);
                    tess.func_78374_a(facePart.beginPt.field_72450_a + 5.0E-4, facePart.endPt.field_72448_b, facePart.endPt.field_72449_c, maxU, maxV);
                    continue;
                }
                if (facePart.facing == ForgeDirection.WEST) {
                    maxU = (facePart.endPt.field_72450_a - facePart.beginPt.field_72450_a) / 8.0;
                    maxV = (facePart.beginPt.field_72448_b - facePart.endPt.field_72448_b) / 8.0;
                    tess.func_78374_a(facePart.beginPt.field_72450_a, facePart.beginPt.field_72448_b, facePart.beginPt.field_72449_c + 5.0E-4, maxU, 0.0);
                    tess.func_78374_a(facePart.endPt.field_72450_a, facePart.beginPt.field_72448_b, facePart.beginPt.field_72449_c + 5.0E-4, 0.0, 0.0);
                    tess.func_78374_a(facePart.endPt.field_72450_a, facePart.endPt.field_72448_b, facePart.beginPt.field_72449_c + 5.0E-4, 0.0, maxV);
                    tess.func_78374_a(facePart.beginPt.field_72450_a, facePart.endPt.field_72448_b, facePart.beginPt.field_72449_c + 5.0E-4, maxU, maxV);
                    continue;
                }
                if (facePart.facing == ForgeDirection.UP) {
                    maxU = (facePart.beginPt.field_72449_c - facePart.endPt.field_72449_c) / 8.0;
                    maxV = (facePart.endPt.field_72450_a - facePart.beginPt.field_72450_a) / 8.0;
                    tess.func_78374_a(facePart.beginPt.field_72450_a, facePart.beginPt.field_72448_b - 5.0E-4, facePart.beginPt.field_72449_c, maxU, maxV);
                    tess.func_78374_a(facePart.endPt.field_72450_a, facePart.beginPt.field_72448_b - 5.0E-4, facePart.beginPt.field_72449_c, maxU, 0.0);
                    tess.func_78374_a(facePart.endPt.field_72450_a, facePart.beginPt.field_72448_b - 5.0E-4, facePart.endPt.field_72449_c, 0.0, 0.0);
                    tess.func_78374_a(facePart.beginPt.field_72450_a, facePart.beginPt.field_72448_b - 5.0E-4, facePart.endPt.field_72449_c, 0.0, maxV);
                    continue;
                }
                if (facePart.facing != ForgeDirection.DOWN) continue;
                maxU = (facePart.endPt.field_72449_c - facePart.beginPt.field_72449_c) / 8.0;
                maxV = (facePart.endPt.field_72450_a - facePart.beginPt.field_72450_a) / 8.0;
                tess.func_78374_a(facePart.endPt.field_72450_a, facePart.beginPt.field_72448_b + 5.0E-4, facePart.beginPt.field_72449_c, maxU, maxV);
                tess.func_78374_a(facePart.beginPt.field_72450_a, facePart.beginPt.field_72448_b + 5.0E-4, facePart.beginPt.field_72449_c, maxU, 0.0);
                tess.func_78374_a(facePart.beginPt.field_72450_a, facePart.beginPt.field_72448_b + 5.0E-4, facePart.endPt.field_72449_c, 0.0, 0.0);
                tess.func_78374_a(facePart.endPt.field_72450_a, facePart.beginPt.field_72448_b + 5.0E-4, facePart.endPt.field_72449_c, 0.0, maxV);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void interfere(ForcefieldCube interfered, boolean isRecessive) {
        faceIterator = this.faces.entrySet().iterator();
        newFaceMap = new EnumMap<ForgeDirection, CubeFace[]>(ForgeDirection.class);
        block8: while (faceIterator.hasNext()) {
            myFace = faceIterator.next();
            newFaces = new ArrayList<E>();
            switch (1.$SwitchMap$net$minecraftforge$common$util$ForgeDirection[myFace.getKey().ordinal()]) {
                case 1: {
                    v0 = this.center.field_72450_a + this.boxAABB.field_72336_d;
                    v1 = isRecessive != false ? 0.001 : 0.0;
                    if (!(v0 + v1 >= interfered.center.field_72450_a + interfered.boxAABB.field_72340_a)) ** GOTO lbl-1000
                    v2 = this.center.field_72450_a + this.boxAABB.field_72336_d;
                    v3 = isRecessive != false ? 0.001 : 0.0;
                    if (v2 + v3 <= interfered.center.field_72450_a + interfered.boxAABB.field_72336_d) {
                        v4 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v4 = false;
                    }
                    intersects = v4;
                    break;
                }
                case 2: {
                    v5 = this.center.field_72450_a + this.boxAABB.field_72340_a;
                    v6 = isRecessive != false ? 0.001 : 0.0;
                    if (!(v5 - v6 <= interfered.center.field_72450_a + interfered.boxAABB.field_72336_d)) ** GOTO lbl-1000
                    v7 = this.center.field_72450_a + this.boxAABB.field_72340_a;
                    v8 = isRecessive != false ? 0.001 : 0.0;
                    if (v7 - v8 >= interfered.center.field_72450_a + interfered.boxAABB.field_72340_a) {
                        v9 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v9 = false;
                    }
                    intersects = v9;
                    break;
                }
                case 3: {
                    v10 = this.center.field_72449_c + this.boxAABB.field_72334_f;
                    v11 = isRecessive != false ? 0.001 : 0.0;
                    if (!(v10 + v11 >= interfered.center.field_72449_c + interfered.boxAABB.field_72339_c)) ** GOTO lbl-1000
                    v12 = this.center.field_72449_c + this.boxAABB.field_72334_f;
                    v13 = isRecessive != false ? 0.001 : 0.0;
                    if (v12 + v13 <= interfered.center.field_72449_c + interfered.boxAABB.field_72334_f) {
                        v14 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v14 = false;
                    }
                    intersects = v14;
                    break;
                }
                case 4: {
                    v15 = this.center.field_72449_c + this.boxAABB.field_72339_c;
                    v16 = isRecessive != false ? 0.001 : 0.0;
                    if (!(v15 - v16 <= interfered.center.field_72449_c + interfered.boxAABB.field_72334_f)) ** GOTO lbl-1000
                    v17 = this.center.field_72449_c + this.boxAABB.field_72339_c;
                    v18 = isRecessive != false ? 0.001 : 0.0;
                    if (v17 - v18 >= interfered.center.field_72449_c + interfered.boxAABB.field_72339_c) {
                        v19 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v19 = false;
                    }
                    intersects = v19;
                    break;
                }
                case 5: {
                    v20 = this.center.field_72448_b + this.boxAABB.field_72337_e;
                    v21 = isRecessive != false ? 0.001 : 0.0;
                    if (!(v20 + v21 >= interfered.center.field_72448_b + interfered.boxAABB.field_72338_b)) ** GOTO lbl-1000
                    v22 = this.center.field_72448_b + this.boxAABB.field_72337_e;
                    v23 = isRecessive != false ? 0.001 : 0.0;
                    if (v22 + v23 <= interfered.center.field_72448_b + interfered.boxAABB.field_72337_e) {
                        v24 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v24 = false;
                    }
                    intersects = v24;
                    break;
                }
                case 6: {
                    v25 = this.center.field_72448_b + this.boxAABB.field_72338_b;
                    v26 = isRecessive != false ? 0.001 : 0.0;
                    if (!(v25 - v26 <= interfered.center.field_72448_b + interfered.boxAABB.field_72337_e)) ** GOTO lbl-1000
                    v27 = this.center.field_72448_b + this.boxAABB.field_72338_b;
                    v28 = isRecessive != false ? 0.001 : 0.0;
                    if (v27 - v28 >= interfered.center.field_72448_b + interfered.boxAABB.field_72338_b) {
                        v29 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v29 = false;
                    }
                    intersects = v29;
                    break;
                }
                default: {
                    continue block8;
                }
            }
            Collections.addAll(newFaces, (Object[])myFace.getValue());
            if (newFaces.size() > 0 && intersects) {
                intfFace = new CubeFace(myFace.getKey().getOpposite(), interfered.center, interfered.boxAABB, interfered.boxColor);
                i = 0;
                j = 0;
                while (i < newFaces.size()) {
                    myFacePart = (CubeFace)newFaces.get(i);
                    newFaceParts = myFacePart.intersect(intfFace);
                    if (newFaceParts != null) {
                        newFaces.remove(i);
                        Collections.addAll(newFaces, newFaceParts);
                        --i;
                    }
                    if (j >= 10000) {
                        TurretModRebirth.LOG.log(Level.ERROR, "Too many face parts for shield! Max. of 10000 is exceeded! Removing Face!");
                        newFaces.clear();
                        break;
                    }
                    ++i;
                    ++j;
                }
            }
            newFaceMap.put(myFace.getKey(), newFaces.toArray(new CubeFace[newFaces.size()]));
        }
        this.faces = newFaceMap;
    }

    private static class RectCoords {
        public final double beginX;
        public final double beginY;
        public final double endX;
        public final double endY;

        public RectCoords(double xBegin, double yBegin, double xEnd, double yEnd) {
            this.beginX = xBegin;
            this.beginY = yBegin;
            this.endX = xEnd;
            this.endY = yEnd;
        }

        public boolean isEmptyOrNegative() {
            return this.beginX + 1.0E-4 >= this.endX || this.beginY <= this.endY + 1.0E-4;
        }
    }

    private static class CubeFace {
        public final ForgeDirection facing;
        public final Vec3 beginPt;
        public final Vec3 endPt;
        public final ColorObject color;

        public CubeFace(ForgeDirection direction, Vec3 begin, Vec3 end, ColorObject faceColor) {
            this.facing = direction;
            this.beginPt = begin;
            this.endPt = end;
            this.color = faceColor;
        }

        public CubeFace(ForgeDirection direction, Vec3 center, AxisAlignedBB boxBB, ColorObject faceColor) {
            this.facing = direction;
            this.color = faceColor;
            switch (direction) {
                case NORTH: {
                    this.beginPt = Vec3.func_72443_a((double)(center.field_72450_a + boxBB.field_72336_d), (double)(center.field_72448_b + boxBB.field_72337_e), (double)(center.field_72449_c + boxBB.field_72339_c));
                    this.endPt = Vec3.func_72443_a((double)(center.field_72450_a + boxBB.field_72336_d), (double)(center.field_72448_b + boxBB.field_72338_b), (double)(center.field_72449_c + boxBB.field_72334_f));
                    break;
                }
                case SOUTH: {
                    this.beginPt = Vec3.func_72443_a((double)(center.field_72450_a + boxBB.field_72340_a), (double)(center.field_72448_b + boxBB.field_72337_e), (double)(center.field_72449_c + boxBB.field_72339_c));
                    this.endPt = Vec3.func_72443_a((double)(center.field_72450_a + boxBB.field_72340_a), (double)(center.field_72448_b + boxBB.field_72338_b), (double)(center.field_72449_c + boxBB.field_72334_f));
                    break;
                }
                case EAST: {
                    this.beginPt = Vec3.func_72443_a((double)(center.field_72450_a + boxBB.field_72340_a), (double)(center.field_72448_b + boxBB.field_72337_e), (double)(center.field_72449_c + boxBB.field_72334_f));
                    this.endPt = Vec3.func_72443_a((double)(center.field_72450_a + boxBB.field_72336_d), (double)(center.field_72448_b + boxBB.field_72338_b), (double)(center.field_72449_c + boxBB.field_72334_f));
                    break;
                }
                case WEST: {
                    this.beginPt = Vec3.func_72443_a((double)(center.field_72450_a + boxBB.field_72340_a), (double)(center.field_72448_b + boxBB.field_72337_e), (double)(center.field_72449_c + boxBB.field_72339_c));
                    this.endPt = Vec3.func_72443_a((double)(center.field_72450_a + boxBB.field_72336_d), (double)(center.field_72448_b + boxBB.field_72338_b), (double)(center.field_72449_c + boxBB.field_72339_c));
                    break;
                }
                case UP: {
                    this.beginPt = Vec3.func_72443_a((double)(center.field_72450_a + boxBB.field_72340_a), (double)(center.field_72448_b + boxBB.field_72337_e), (double)(center.field_72449_c + boxBB.field_72334_f));
                    this.endPt = Vec3.func_72443_a((double)(center.field_72450_a + boxBB.field_72336_d), (double)(center.field_72448_b + boxBB.field_72337_e), (double)(center.field_72449_c + boxBB.field_72339_c));
                    break;
                }
                case DOWN: {
                    this.beginPt = Vec3.func_72443_a((double)(center.field_72450_a + boxBB.field_72340_a), (double)(center.field_72448_b + boxBB.field_72338_b), (double)(center.field_72449_c + boxBB.field_72334_f));
                    this.endPt = Vec3.func_72443_a((double)(center.field_72450_a + boxBB.field_72336_d), (double)(center.field_72448_b + boxBB.field_72338_b), (double)(center.field_72449_c + boxBB.field_72339_c));
                    break;
                }
                default: {
                    throw new RuntimeException(String.format("Invalid direction for Forcefield Face: %s", direction.toString()));
                }
            }
        }

        public CubeFace[] intersect(CubeFace intersector) {
            RectCoords myCoord = this.get2DCoords();
            RectCoords intsCoord = intersector.get2DCoords();
            if (myCoord.endX <= intsCoord.beginX || myCoord.beginX >= intsCoord.endX || myCoord.beginY <= intsCoord.endY || myCoord.endY >= intsCoord.beginY) {
                return null;
            }
            ArrayList<CubeFace> newCubes = new ArrayList<CubeFace>(4);
            RectCoords topRect = new RectCoords(myCoord.beginX, myCoord.beginY, myCoord.endX, Math.max(intsCoord.beginY, myCoord.endY));
            RectCoords btmRect = new RectCoords(myCoord.beginX, Math.max(intsCoord.endY, myCoord.endY), myCoord.endX, myCoord.endY);
            RectCoords lftRect = new RectCoords(myCoord.beginX, Math.min(intsCoord.beginY, myCoord.beginY), Math.max(intsCoord.beginX, myCoord.beginX), Math.max(intsCoord.endY, myCoord.endY));
            RectCoords rgtRect = new RectCoords(Math.min(intsCoord.endX, myCoord.endX), Math.min(intsCoord.beginY, myCoord.beginY), myCoord.endX, Math.max(intsCoord.endY, myCoord.endY));
            if (!topRect.isEmptyOrNegative()) {
                newCubes.add(this.get3DCoords(topRect));
            }
            if (!btmRect.isEmptyOrNegative()) {
                newCubes.add(this.get3DCoords(btmRect));
            }
            if (!lftRect.isEmptyOrNegative()) {
                newCubes.add(this.get3DCoords(lftRect));
            }
            if (!rgtRect.isEmptyOrNegative()) {
                newCubes.add(this.get3DCoords(rgtRect));
            }
            if (newCubes.size() == 0) {
                return new CubeFace[0];
            }
            return newCubes.toArray(new CubeFace[newCubes.size()]);
        }

        public RectCoords get2DCoords() {
            switch (this.facing) {
                case NORTH: 
                case SOUTH: {
                    return new RectCoords(this.beginPt.field_72449_c, this.beginPt.field_72448_b, this.endPt.field_72449_c, this.endPt.field_72448_b);
                }
                case EAST: 
                case WEST: {
                    return new RectCoords(this.beginPt.field_72450_a, this.beginPt.field_72448_b, this.endPt.field_72450_a, this.endPt.field_72448_b);
                }
                case UP: 
                case DOWN: {
                    return new RectCoords(this.beginPt.field_72450_a, this.beginPt.field_72449_c, this.endPt.field_72450_a, this.endPt.field_72449_c);
                }
            }
            return new RectCoords(0.0, 0.0, 0.0, 0.0);
        }

        public CubeFace get3DCoords(RectCoords newRect) {
            switch (this.facing) {
                case NORTH: 
                case SOUTH: {
                    return new CubeFace(this.facing, Vec3.func_72443_a((double)this.beginPt.field_72450_a, (double)newRect.beginY, (double)newRect.beginX), Vec3.func_72443_a((double)this.endPt.field_72450_a, (double)newRect.endY, (double)newRect.endX), this.color);
                }
                case EAST: 
                case WEST: {
                    return new CubeFace(this.facing, Vec3.func_72443_a((double)newRect.beginX, (double)newRect.beginY, (double)this.beginPt.field_72449_c), Vec3.func_72443_a((double)newRect.endX, (double)newRect.endY, (double)this.endPt.field_72449_c), this.color);
                }
                case UP: 
                case DOWN: {
                    return new CubeFace(this.facing, Vec3.func_72443_a((double)newRect.beginX, (double)this.beginPt.field_72448_b, (double)newRect.beginY), Vec3.func_72443_a((double)newRect.endX, (double)this.endPt.field_72448_b, (double)newRect.endY), this.color);
                }
            }
            return null;
        }
    }
}

