/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.render.turret;

import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.util.TmrConfiguration;
import de.sanandrew.mods.turretmod.util.TurretModRebirth;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL11;

public class RenderTurret
extends RenderLiving {
    private ModelBase glowModel;

    public RenderTurret(ModelBase standardModel) {
        super(standardModel, 0.5f);
        try {
            this.glowModel = (ModelBase)standardModel.getClass().getConstructor(Float.TYPE).newInstance(Float.valueOf(0.001f));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            TurretModRebirth.LOG.log(Level.ERROR, "Could not instanciate model class! Make sure it has a constructor with a one float parameter (scale)! Glowmap disabled.", (Throwable)ex);
            this.glowModel = null;
        }
    }

    protected void func_77036_a(EntityLivingBase entity, float limbSwing, float limbSwingAmount, float rotFloat, float rotYaw, float rotPitch, float scale) {
        super.func_77036_a(entity, limbSwing, limbSwingAmount, rotFloat, rotYaw, rotPitch, scale);
        if (TmrConfiguration.renderUpgrades) {
            GL11.glPushMatrix();
            if (entity instanceof EntityTurret) {
                EntityTurret turret = (EntityTurret)entity;
                GL11.glRotated((double)((double)rotYaw + 90.0), (double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)rotPitch, (double)0.0, (double)0.0, (double)1.0);
                RenderTurret.renderUpgrades(turret);
                if (turret.field_70737_aN > 0) {
                    GL11.glDisable((int)3553);
                    GL11.glDisable((int)3008);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glDepthFunc((int)514);
                    GL11.glColor4f((float)0.4f, (float)0.0f, (float)0.0f, (float)1.0f);
                    RenderTurret.renderUpgrades(turret);
                    GL11.glDepthFunc((int)515);
                    GL11.glDisable((int)3042);
                    GL11.glEnable((int)3008);
                    GL11.glEnable((int)3553);
                }
            }
            GL11.glPopMatrix();
        }
    }

    protected int func_77032_a(EntityLivingBase livingBase, int pass, float partTicks) {
        if (livingBase instanceof EntityTurret) {
            return this.renderGlowMap((EntityTurret)livingBase, pass);
        }
        return -1;
    }

    protected void func_77043_a(EntityLivingBase living, float x, float y, float z) {
        super.func_77043_a(living, x, y, z);
        if (living instanceof EntityTurret && ((EntityTurret)living).isUpsideDown) {
            GL11.glTranslatef((float)0.0f, (float)(living.field_70131_O + 0.2f), (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        if (entity instanceof EntityTurret) {
            return ((EntityTurret)entity).getStandardTexture();
        }
        return null;
    }

    protected void func_77033_b(EntityLivingBase entity, double x, double y, double z) {
        RenderTurret.renderTurretRange((EntityTurret)entity, x, y, z);
    }

    private int renderGlowMap(EntityTurret turret, int pass) {
        if (pass == 0) {
            this.func_77042_a(this.glowModel);
            this.func_110776_a(turret.getGlowTexture());
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3008);
            GL11.glBlendFunc((int)1, (int)1);
            int bright = 240;
            int brightX = bright % 65536;
            int brightY = bright / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)brightX / 1.0f), (float)((float)brightY / 1.0f));
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDepthMask((boolean)false);
            return 1;
        }
        if (pass == 1) {
            this.func_77042_a(this.field_77045_g);
            GL11.glDepthMask((boolean)true);
            GL11.glDisable((int)3042);
        }
        return -1;
    }

    private static void renderTurretRange(EntityTurret turret, double x, double y, double z) {
        if (turret.showRange) {
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glDisable((int)3553);
            Tessellator tess = Tessellator.field_78398_a;
            int range = MathHelper.func_76128_c((double)turret.getTargetProcessor().getRange());
            GL11.glLineWidth((float)5.0f);
            tess.func_78371_b(2);
            tess.func_78370_a(255, 0, 0, 64);
            tess.func_78377_a(x, y, z);
            tess.func_78377_a(x, y + (double)range, z);
            tess.func_78381_a();
            GL11.glLineWidth((float)0.1f);
            for (double j = (double)(-range); j <= (double)range; j += 1.0) {
                double yC;
                double xC;
                double neg;
                int i;
                tess.func_78371_b(2);
                tess.func_78370_a(255, 0, 0, 64);
                for (i = 0; i <= 360; i += 5) {
                    neg = Math.sin(Math.acos(j / (double)range)) * (double)range;
                    xC = neg * Math.sin((double)i * Math.PI * 2.0 / 360.0);
                    yC = neg * Math.cos((double)i * Math.PI * 2.0 / 360.0);
                    tess.func_78377_a(x + xC, y + yC, z + j);
                }
                tess.func_78381_a();
                tess.func_78371_b(2);
                tess.func_78370_a(255, 0, 0, 64);
                for (i = 0; i <= 360; i += 5) {
                    neg = Math.sin(Math.acos(j / (double)range)) * (double)range;
                    double zC = neg * Math.sin((double)i * Math.PI * 2.0 / 360.0);
                    yC = neg * Math.cos((double)i * Math.PI * 2.0 / 360.0);
                    tess.func_78377_a(x + j, y + yC, z + zC);
                }
                tess.func_78381_a();
                tess.func_78371_b(2);
                tess.func_78370_a(255, 0, 0, 64);
                for (i = 0; i <= 360; i += 5) {
                    neg = Math.sin(Math.acos(j / (double)range)) * (double)range;
                    xC = neg * Math.sin((double)i * Math.PI * 2.0 / 360.0);
                    double zC = neg * Math.cos((double)i * Math.PI * 2.0 / 360.0);
                    tess.func_78377_a(x + xC, y + j, z + zC);
                }
                tess.func_78381_a();
            }
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void renderUpgrades(EntityTurret turret) {
        int cnt = turret.getUpgradeProcessor().func_70302_i_();
        RenderItem.field_82407_g = true;
        for (int i = 0; i < cnt; ++i) {
            ItemStack slotStack = turret.getUpgradeProcessor().func_70301_a(i);
            if (slotStack == null) continue;
            EntityItem entityitem = new EntityItem(turret.field_70170_p, 0.0, 0.0, 0.0, slotStack.func_77946_l());
            entityitem.func_92059_d().field_77994_a = 1;
            entityitem.field_70290_d = 0.0f;
            int x = i / 18;
            int y = i % 18;
            GL11.glPushMatrix();
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            GL11.glTranslatef((float)(-0.25f + 0.5f * (float)x), (float)0.2f, (float)(-0.425f + 0.05f * (float)y));
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            RenderManager.field_78727_a.func_147940_a((Entity)entityitem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
        RenderItem.field_82407_g = false;
    }

    private static float interpolateRotation(float rot1, float rot2, float partTicks) {
        float rotDelta;
        for (rotDelta = rot2 - rot1; rotDelta < -180.0f; rotDelta += 360.0f) {
        }
        while (rotDelta >= 180.0f) {
            rotDelta -= 360.0f;
        }
        return rot1 + partTicks * rotDelta;
    }
}

