/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.util;

import cpw.mods.fml.common.FMLLog;
import de.sanandrew.mods.turretmod.client.event.ClientTickHandler;
import de.sanandrew.mods.turretmod.client.shader.ShaderCallback;
import de.sanandrew.mods.turretmod.util.Resources;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.ARBShaderObjects;

public final class ShaderHelper {
    private static final int VERT = 35633;
    private static final int FRAG = 35632;
    public static int categoryButton = 0;
    public static int grayscaleItem = 0;

    public static void initShaders() {
        if (!ShaderHelper.areShadersEnabled()) {
            return;
        }
        categoryButton = ShaderHelper.createProgram(null, Resources.SHADER_CATEGORY_BUTTON_FRAG.getResource());
        grayscaleItem = ShaderHelper.createProgram(null, Resources.SHADER_GRAYSCALE_FRAG.getResource());
    }

    public static void useShader(int shader, ShaderCallback callback) {
        if (!ShaderHelper.areShadersEnabled()) {
            return;
        }
        ARBShaderObjects.glUseProgramObjectARB((int)shader);
        if (shader != 0) {
            int time = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"time");
            ARBShaderObjects.glUniform1iARB((int)time, (int)ClientTickHandler.ticksInGame);
            if (callback != null) {
                callback.call(shader);
            }
        }
    }

    public static void useShader(int shader) {
        ShaderHelper.useShader(shader, null);
    }

    public static void releaseShader() {
        ShaderHelper.useShader(0);
    }

    public static boolean areShadersEnabled() {
        return OpenGlHelper.field_148824_g;
    }

    private static int createProgram(ResourceLocation vert, ResourceLocation frag) {
        int program;
        int vertId = 0;
        int fragId = 0;
        if (vert != null) {
            vertId = ShaderHelper.createShader(vert, 35633);
        }
        if (frag != null) {
            fragId = ShaderHelper.createShader(frag, 35632);
        }
        if ((program = ARBShaderObjects.glCreateProgramObjectARB()) == 0) {
            return 0;
        }
        if (vert != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)vertId);
        }
        if (frag != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)fragId);
        }
        ARBShaderObjects.glLinkProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35714) == 0) {
            FMLLog.log((Level)Level.ERROR, (String)ShaderHelper.getLogInfo(program), (Object[])new Object[0]);
            return 0;
        }
        ARBShaderObjects.glValidateProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35715) == 0) {
            FMLLog.log((Level)Level.ERROR, (String)ShaderHelper.getLogInfo(program), (Object[])new Object[0]);
            return 0;
        }
        return program;
    }

    private static int createShader(ResourceLocation file, int shaderType) {
        int shader = 0;
        try {
            shader = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)ShaderHelper.readFileAsString(file));
            ARBShaderObjects.glCompileShaderARB((int)shader);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713) == 0) {
                throw new RuntimeException("Error creating shader: " + ShaderHelper.getLogInfo(shader));
            }
            return shader;
        }
        catch (Exception e) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
            e.printStackTrace();
            return -1;
        }
    }

    private static String getLogInfo(int obj) {
        return ARBShaderObjects.glGetInfoLogARB((int)obj, (int)ARBShaderObjects.glGetObjectParameteriARB((int)obj, (int)35716));
    }

    private static String readFileAsString(ResourceLocation file) throws Exception {
        StringBuilder source = new StringBuilder();
        try (InputStream in = Minecraft.func_71410_x().func_110442_L().func_110536_a(file).func_110527_b();){
            if (in == null) {
                String string = "";
                return string;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));){
                String line;
                while ((line = reader.readLine()) != null) {
                    source.append(line).append('\n');
                }
            }
        }
        return source.toString();
    }
}

