/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.entity.projectile;

import de.sanandrew.mods.turretmod.entity.projectile.EntityTurretProjectile;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.util.EnumParticle;
import de.sanandrew.mods.turretmod.util.TurretModRebirth;
import net.darkhax.bookshelf.lib.javatuples.Triplet;
import net.darkhax.bookshelf.lib.javatuples.Tuple;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityProjectileCryoCell
extends EntityTurretProjectile {
    private int level = 0;
    private int duration = 0;

    public EntityProjectileCryoCell(World world) {
        super(world);
    }

    public EntityProjectileCryoCell(World world, Entity shooter, Entity target) {
        super(world, shooter, target);
    }

    public EntityProjectileCryoCell(World world, Entity shooter, Vec3 shootingVec) {
        super(world, shooter, shootingVec);
    }

    public EntityProjectileCryoCell setLevelAndDuration(int lvl, int duration) {
        this.level = lvl;
        this.duration = duration;
        return this;
    }

    @Override
    public float getArc() {
        return 0.05f;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            TurretModRebirth.proxy.spawnParticle(EnumParticle.CRYO_PARTICLE, this.field_70165_t, this.field_70163_u, this.field_70161_v, (Tuple)Triplet.with((Object)this.field_70159_w, (Object)this.field_70181_x, (Object)this.field_70179_y));
        }
    }

    @Override
    protected void processHit(MovingObjectPosition hitObj) {
        super.processHit(hitObj);
    }

    @Override
    public float getInitialSpeedMultiplier() {
        return 1.5f;
    }

    @Override
    public float getDamage() {
        return 0.0f;
    }

    @Override
    public float getKnockbackStrengthH() {
        return 0.0f;
    }

    @Override
    public float getKnockbackStrengthV() {
        return 0.0f;
    }

    @Override
    public boolean onPreHit(Entity e, DamageSource dmgSource, float dmg) {
        if (!this.field_70170_p.field_72995_K && e instanceof EntityLivingBase) {
            ((EntityLivingBase)e).func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), this.duration, this.level));
            if (e instanceof EntityCreature && this.shooterCache instanceof EntityTurret) {
                EntityProjectileCryoCell.setEntityTarget((EntityCreature)e, (EntityTurret)this.shooterCache);
            }
            this.func_85030_a(this.getRicochetSound(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            this.func_70106_y();
            return false;
        }
        return super.onPreHit(e, dmgSource, dmg);
    }

    @Override
    public String getRicochetSound() {
        return "sapturretmod:ricochet.splash";
    }

    @Override
    public void onPostHit(Entity e, DamageSource dmg) {
        super.onPostHit(e, dmg);
        if (e instanceof EntityLivingBase) {
            ((EntityLivingBase)e).field_70172_ad = 0;
        }
    }
}

