/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.entity.turret;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import de.sanandrew.mods.turretmod.entity.turret.TargetProcessor;
import de.sanandrew.mods.turretmod.entity.turret.UpgradeProcessor;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import de.sanandrew.mods.turretmod.network.PacketPlayerTurretAction;
import de.sanandrew.mods.turretmod.network.PacketRegistry;
import de.sanandrew.mods.turretmod.network.PacketUpdateTurretState;
import de.sanandrew.mods.turretmod.registry.medpack.TurretRepairKit;
import de.sanandrew.mods.turretmod.registry.turret.TurretAttributes;
import de.sanandrew.mods.turretmod.registry.turret.TurretRegistry;
import de.sanandrew.mods.turretmod.util.DataWatcherBooleans;
import de.sanandrew.mods.turretmod.util.EnumGui;
import de.sanandrew.mods.turretmod.util.TmrUtils;
import de.sanandrew.mods.turretmod.util.TurretModRebirth;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.darkhax.bookshelf.lib.javatuples.Pair;
import net.darkhax.bookshelf.lib.javatuples.Triplet;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class EntityTurret
extends EntityLiving
implements IEntityAdditionalSpawnData {
    public boolean isUpsideDown;
    public boolean showRange;
    private static final int DW_EXPERIENCE = 22;
    private static final int DW_FREQUENCY = 27;
    private static final int DW_BOOLEANS = 28;
    private Triplet<Integer, Integer, Integer> blockPos;
    protected TargetProcessor targetProc;
    protected UpgradeProcessor upgProc = new UpgradeProcessor(this);
    protected UUID ownerUUID;
    protected String ownerName;
    public boolean inGui;
    private DataWatcherBooleans dwBools;

    public EntityTurret(World world) {
        super(world);
    }

    public EntityTurret(World world, boolean isUpsideDown, EntityPlayer owner) {
        this(world);
        this.isUpsideDown = isUpsideDown;
        this.ownerUUID = owner.func_110124_au();
        this.ownerName = owner.func_70005_c_();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(TurretAttributes.MAX_AMMO_CAPACITY);
        this.func_110140_aT().func_111150_b(TurretAttributes.MAX_RELOAD_TICKS);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.dwBools = new DataWatcherBooleans((Entity)this, 28);
        this.dwBools.registerDwValue();
        this.setActive(true);
    }

    protected String func_70621_aR() {
        return "sapturretmod:hit.turrethit";
    }

    protected String func_70673_aS() {
        return "sapturretmod:hit.turretDeath";
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70625_a(Entity entity, float yawSpeed, float pitchSpeed) {
        double deltaY;
        if (entity == null || entity.field_70121_D == null) {
            return;
        }
        double deltaX = entity.field_70165_t - this.field_70165_t;
        double deltaZ = entity.field_70161_v - this.field_70161_v;
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase livingBase = (EntityLivingBase)entity;
            deltaY = livingBase.field_70163_u + (double)livingBase.func_70047_e() - (this.field_70163_u + (double)this.func_70047_e());
        } else {
            deltaY = (entity.field_70121_D.field_72338_b + entity.field_70121_D.field_72337_e) / 2.0 - (this.field_70163_u + (double)this.func_70047_e());
        }
        double distVecXZ = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ));
        float yawRotation = (float)((this.isUpsideDown ? -1.0 : 1.0) * (Math.atan2(deltaZ, deltaX) * 180.0 / Math.PI)) - 90.0f;
        float pitchRotation = (float)(-(Math.atan2(deltaY *= this.isUpsideDown ? -1.0 : 1.0, distVecXZ) * 180.0 / Math.PI));
        this.field_70125_A = this.func_70663_b(this.field_70125_A, pitchRotation, 20.0f);
        this.field_70759_as = this.func_70663_b(this.field_70759_as, yawRotation, 20.0f);
    }

    public void func_70034_d(float rotation) {
    }

    protected float func_70663_b(float prevRotation, float newRotation, float speed) {
        float part = MathHelper.func_76142_g((float)(newRotation - prevRotation));
        if (part > speed) {
            part = speed;
        }
        if (part < -speed) {
            part = -speed;
        }
        return prevRotation + part;
    }

    public void func_70071_h_() {
        if (!this.inGui) {
            super.func_70071_h_();
        }
    }

    public void func_70636_d() {
        this.field_70177_z = 0.0f;
        if (this.blockPos == null) {
            this.blockPos = Triplet.with((Object)((int)Math.floor(this.field_70165_t)), (Object)((int)Math.floor(this.field_70163_u) + (this.isUpsideDown ? 3 : 0)), (Object)((int)Math.floor(this.field_70161_v)));
        }
        if (!EntityTurret.canTurretBePlaced(this.field_70170_p, (Integer)this.blockPos.getValue0(), (Integer)this.blockPos.getValue1(), (Integer)this.blockPos.getValue2(), true, this.isUpsideDown)) {
            this.func_70076_C();
        }
        this.field_70170_p.field_72984_F.func_76320_a("ai");
        if (this.func_70610_aX()) {
            this.field_70703_bu = false;
            this.field_70702_br = 0.0f;
            this.field_70701_bs = 0.0f;
            this.field_70704_bt = 0.0f;
        } else if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.field_72984_F.func_76320_a("oldAi");
            this.func_70626_be();
            this.field_70170_p.field_72984_F.func_76319_b();
        }
        if (this.isActive()) {
            if (!this.field_70170_p.field_72995_K) {
                this.targetProc.onTick();
            }
            this.upgProc.onTick();
            if (this.targetProc.hasTarget()) {
                this.func_70625_a(this.targetProc.getTarget(), 10.0f, this.func_70646_bf());
            } else if (this.field_70170_p.field_72995_K && (this.field_70153_n == null || !(this.field_70153_n instanceof EntityPlayer))) {
                this.field_70759_as += 1.0f;
                this.field_70125_A = 0.0f;
            }
        }
        this.field_70170_p.field_72984_F.func_76319_b();
    }

    private void onInteractSucceed(ItemStack heldItem, EntityPlayer player) {
        if (heldItem.field_77994_a == 0) {
            player.func_71028_bD();
        } else {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, heldItem.func_77946_l());
        }
        this.updateState();
        player.field_71069_bz.func_75142_b();
        this.field_70170_p.func_72956_a((Entity)this, "sapturretmod:collect.ia_get", 1.0f, 1.0f);
    }

    protected boolean func_70085_c(EntityPlayer player) {
        ItemStack heldItem = player.func_71045_bC();
        if (this.field_70170_p.field_72995_K) {
            if (ItemStackUtils.isValidStack((ItemStack)heldItem) && heldItem.func_77973_b() == ItemRegistry.tcu) {
                TurretModRebirth.proxy.openGui(player, EnumGui.GUI_TCU_INFO, this.func_145782_y(), 0, 0);
                return true;
            }
            return false;
        }
        if (ItemStackUtils.isValidStack((ItemStack)heldItem)) {
            if (this.targetProc.addAmmo(heldItem)) {
                this.onInteractSucceed(heldItem, player);
                return true;
            }
            if (heldItem.func_77973_b() == ItemRegistry.repairKit) {
                TurretRepairKit repKit = ItemRegistry.repairKit.getRepKitType(heldItem);
                if (repKit != null && repKit.isApplicable(this)) {
                    this.func_70691_i(repKit.getHealAmount());
                    repKit.onHeal(this);
                    --heldItem.field_77994_a;
                    this.onInteractSucceed(heldItem, player);
                    return true;
                }
            } else if (heldItem.func_77973_b() == ItemRegistry.turretUpgrade && this.upgProc.tryApplyUpgrade(heldItem.func_77946_l())) {
                --heldItem.field_77994_a;
                this.onInteractSucceed(heldItem, player);
                return true;
            }
        }
        return super.func_70085_c(player);
    }

    public void func_70645_a(DamageSource dmgSrc) {
        super.func_70645_a(dmgSrc);
        if (!this.field_70170_p.field_72995_K) {
            this.targetProc.dropAmmo();
            this.upgProc.dropUpgrades();
        }
        this.func_70106_y();
    }

    protected void func_70626_be() {
        ++this.field_70708_bq;
        this.field_70702_br = 0.0f;
        this.field_70701_bs = 0.0f;
    }

    public TargetProcessor getTargetProcessor() {
        return this.targetProc;
    }

    public UpgradeProcessor getUpgradeProcessor() {
        return this.upgProc;
    }

    public void writeSpawnData(ByteBuf buffer) {
        NBTTagCompound targetNbt = new NBTTagCompound();
        this.targetProc.writeToNbt(targetNbt);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)targetNbt);
        NBTTagCompound upgNbt = new NBTTagCompound();
        this.upgProc.writeToNbt(upgNbt);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)upgNbt);
        buffer.writeBoolean(this.isUpsideDown);
        if (this.ownerUUID != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.ownerUUID.toString());
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.ownerName);
        } else {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)"[UNKNOWN_OWNER]");
        }
    }

    public void readSpawnData(ByteBuf buffer) {
        this.targetProc.readFromNbt(ByteBufUtils.readTag((ByteBuf)buffer));
        this.upgProc.readFromNbt(ByteBufUtils.readTag((ByteBuf)buffer));
        this.isUpsideDown = buffer.readBoolean();
        String ownerUUIDStr = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        if (!ownerUUIDStr.equals("[UNKNOWN_OWNER]")) {
            this.ownerUUID = UUID.fromString(ownerUUIDStr);
            this.ownerName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        this.targetProc.writeToNbt(nbt);
        this.upgProc.writeToNbt(nbt);
        this.dwBools.writeToNbt(nbt);
        nbt.func_74757_a("isUpsideDown", this.isUpsideDown);
        if (this.ownerUUID != null) {
            nbt.func_74778_a("ownerUUID", this.ownerUUID.toString());
            nbt.func_74778_a("ownerName", this.ownerName);
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.targetProc.readFromNbt(nbt);
        this.upgProc.readFromNbt(nbt);
        this.dwBools.readFromNbt(nbt);
        this.isUpsideDown = nbt.func_74767_n("isUpsideDown");
        if (nbt.func_74764_b("ownerUUID")) {
            this.ownerUUID = UUID.fromString(nbt.func_74779_i("ownerUUID"));
            this.ownerName = nbt.func_74779_i("ownerName");
        }
    }

    public int func_70646_bf() {
        return 50;
    }

    public boolean func_70687_e(PotionEffect effect) {
        return effect != null && effect.func_82720_e();
    }

    public final void func_70653_a(Entity entity, float unknown, double motionXAmount, double motionZAmount) {
    }

    public final void func_70091_d(double motionX, double motionY, double motionZ) {
    }

    public final void func_70612_e(float strafe, float forward) {
    }

    public abstract ResourceLocation getStandardTexture();

    public abstract ResourceLocation getGlowTexture();

    public void updateState() {
        PacketRegistry.sendToAllAround((IMessage)new PacketUpdateTurretState(this), this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
    }

    public boolean isActive() {
        return this.dwBools.getBit(DataWatcherBooleans.Turret.ACTIVE.bit);
    }

    public void setActive(boolean active) {
        this.dwBools.setBit(DataWatcherBooleans.Turret.ACTIVE.bit, active);
    }

    public static boolean canTurretBePlaced(World world, int x, int y, int z, boolean doBlockCheckOnly, boolean updideDown) {
        AxisAlignedBB aabb;
        if (!Blocks.field_150442_at.func_149742_c(world, x, y, z)) {
            return false;
        }
        return doBlockCheckOnly || world.func_72872_a(EntityTurret.class, aabb = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)((double)x + 1.0), (double)((double)y + (updideDown ? -1.0 : 1.0)), (double)((double)z + 1.0))).isEmpty();
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public boolean tryDismantle(EntityPlayer player) {
        Pair<Integer, ItemStack> chestItm = TmrUtils.getSimilarStackFromInventory(new ItemStack((Block)Blocks.field_150486_ae), (IInventory)player.field_71071_by, null);
        if (chestItm != null && ItemStackUtils.isValidStack((ItemStack)((ItemStack)chestItm.getValue1()))) {
            TileEntity te;
            ItemStack chestStack = (ItemStack)chestItm.getValue1();
            if (this.field_70170_p.field_72995_K) {
                PacketRegistry.sendToServer((IMessage)new PacketPlayerTurretAction(this, 1));
                return true;
            }
            this.field_70163_u += 2048.0;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            int y = this.isUpsideDown ? (Integer)this.blockPos.getValue1() - 2 : (Integer)this.blockPos.getValue1();
            if (chestStack.func_77973_b().func_77648_a(chestStack, player, this.field_70170_p, ((Integer)this.blockPos.getValue0()).intValue(), y, ((Integer)this.blockPos.getValue2()).intValue(), (this.isUpsideDown ? ForgeDirection.DOWN : ForgeDirection.UP).ordinal(), 0.5f, 1.0f, 0.5f) && (te = this.field_70170_p.func_147438_o(((Integer)this.blockPos.getValue0()).intValue(), y, ((Integer)this.blockPos.getValue2()).intValue())) instanceof TileEntityChest) {
                this.field_70163_u -= 2048.0;
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                TileEntityChest chest = (TileEntityChest)te;
                chest.func_70299_a(0, ItemRegistry.turret.getTurretItem(1, TurretRegistry.INSTANCE.getInfo(((Object)((Object)this)).getClass()), this));
                this.targetProc.putAmmoInInventory((IInventory)chest);
                if (chestStack.field_77994_a < 1) {
                    player.field_71071_by.func_70299_a(((Integer)chestItm.getValue0()).intValue(), null);
                }
                player.field_71069_bz.func_75142_b();
                this.upgProc.dropUpgrades();
                this.func_70076_C();
                return true;
            }
            this.field_70163_u -= 2048.0;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        return false;
    }

    protected void func_70076_C() {
        this.func_70097_a(DamageSource.field_76376_m, Float.MAX_VALUE);
    }
}

