/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.entity.turret;

import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.entity.turret.TargetProcessor;
import de.sanandrew.mods.turretmod.registry.assembly.TurretAssemblyRecipes;
import de.sanandrew.mods.turretmod.registry.turret.TurretAttributes;
import de.sanandrew.mods.turretmod.registry.turret.TurretInfo;
import de.sanandrew.mods.turretmod.util.Resources;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EntityTurretCryolator
extends EntityTurret {
    public static final UUID TI_UUID = UUID.fromString("3AF4D8C3-FCFC-42B0-98A3-BFB669AA7CE6");
    public static final TurretInfo TINFO = new TurretInfo(){

        @Override
        public String getName() {
            return "turret_i_snowball";
        }

        @Override
        public UUID getUUID() {
            return TI_UUID;
        }

        @Override
        public Class<? extends EntityTurret> getTurretClass() {
            return EntityTurretCryolator.class;
        }

        @Override
        public float getTurretHealth() {
            return 20.0f;
        }

        @Override
        public int getBaseAmmoCapacity() {
            return 256;
        }

        @Override
        public String getIcon() {
            return "turret_snowball";
        }

        @Override
        public UUID getRecipeId() {
            return TurretAssemblyRecipes.TURRET_MK1_SB;
        }

        @Override
        public String getInfoRange() {
            return "16";
        }
    };

    public EntityTurretCryolator(World world) {
        super(world);
        this.targetProc = new MyTargetProc();
    }

    public EntityTurretCryolator(World world, boolean isUpsideDown, EntityPlayer player) {
        super(world, isUpsideDown, player);
        this.targetProc = new MyTargetProc();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(TurretAttributes.MAX_RELOAD_TICKS).func_111128_a(20.0);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
    }

    @Override
    public ResourceLocation getStandardTexture() {
        return Resources.TURRET_T1_SNOWBALL.getResource();
    }

    @Override
    public ResourceLocation getGlowTexture() {
        return Resources.TURRET_T1_SNOWBALL_GLOW.getResource();
    }

    private class MyTargetProc
    extends TargetProcessor {
        public MyTargetProc() {
            super(EntityTurretCryolator.this);
        }

        @Override
        public double getRange() {
            return 16.0;
        }

        @Override
        public String getShootSound() {
            return "sapturretmod:shoot.cryolator";
        }

        @Override
        public String getLowAmmoSound() {
            return "random.click";
        }

        @Override
        public boolean doAllowTarget(Entity e) {
            if (e instanceof EntityLivingBase) {
                return !((EntityLivingBase)e).func_70644_a(Potion.field_76421_d) && super.doAllowTarget(e);
            }
            return super.doAllowTarget(e);
        }
    }
}

