/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.entity.turret;

import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.entity.turret.TargetProcessor;
import de.sanandrew.mods.turretmod.registry.assembly.TurretAssemblyRecipes;
import de.sanandrew.mods.turretmod.registry.turret.TurretAttributes;
import de.sanandrew.mods.turretmod.registry.turret.TurretInfo;
import de.sanandrew.mods.turretmod.util.EnumParticle;
import de.sanandrew.mods.turretmod.util.Resources;
import de.sanandrew.mods.turretmod.util.TurretModRebirth;
import java.util.UUID;
import net.darkhax.bookshelf.lib.javatuples.Triplet;
import net.darkhax.bookshelf.lib.javatuples.Tuple;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EntityTurretShotgun
extends EntityTurret {
    public static final UUID TI_UUID = UUID.fromString("F7991EC5-2A89-49A6-B8EA-80775973C4C5");
    public static final TurretInfo TINFO = new TurretInfo(){

        @Override
        public String getName() {
            return "turret_i_shotgun";
        }

        @Override
        public UUID getUUID() {
            return TI_UUID;
        }

        @Override
        public Class<? extends EntityTurret> getTurretClass() {
            return EntityTurretShotgun.class;
        }

        @Override
        public float getTurretHealth() {
            return 20.0f;
        }

        @Override
        public int getBaseAmmoCapacity() {
            return 256;
        }

        @Override
        public String getIcon() {
            return "turret_shotgun";
        }

        @Override
        public UUID getRecipeId() {
            return TurretAssemblyRecipes.TURRET_MK1_SG;
        }

        @Override
        public String getInfoRange() {
            return "16";
        }
    };
    public float barrelPos = 1.0f;
    public float prevBarrelPos = 1.0f;
    public int prevAmmoVal;

    public EntityTurretShotgun(World world) {
        super(world);
        this.targetProc = new MyTargetProc();
    }

    public EntityTurretShotgun(World world, boolean isUpsideDown, EntityPlayer player) {
        super(world, isUpsideDown, player);
        this.targetProc = new MyTargetProc();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(TurretAttributes.MAX_RELOAD_TICKS).func_111128_a(20.0);
    }

    @Override
    public void func_70071_h_() {
        this.prevBarrelPos = this.barrelPos;
        super.func_70071_h_();
        int currAmmoVal = this.targetProc.getAmmoCount();
        if (this.field_70170_p.field_72995_K) {
            this.barrelPos = this.barrelPos < 1.0f ? (this.barrelPos += 1.1999999f / (float)this.targetProc.getMaxShootTicks()) : 1.0f;
            if (this.prevAmmoVal > currAmmoVal) {
                this.barrelPos = 0.0f;
                TurretModRebirth.proxy.spawnParticle(EnumParticle.SHOTGUN_SHOT, this.field_70165_t, this.field_70163_u + 1.5, this.field_70161_v, (Tuple)Triplet.with((Object)Float.valueOf(this.field_70759_as), (Object)Float.valueOf(this.field_70125_A), (Object)this.isUpsideDown));
            }
        }
        this.prevAmmoVal = currAmmoVal;
    }

    @Override
    public ResourceLocation getStandardTexture() {
        return Resources.TURRET_T1_SHOTGUN.getResource();
    }

    @Override
    public ResourceLocation getGlowTexture() {
        return Resources.TURRET_T1_SHOTGUN_GLOW.getResource();
    }

    private class MyTargetProc
    extends TargetProcessor {
        public MyTargetProc() {
            super(EntityTurretShotgun.this);
        }

        @Override
        public double getRange() {
            return 16.0;
        }

        @Override
        public String getShootSound() {
            return "sapturretmod:shoot.shotgun";
        }

        @Override
        public String getLowAmmoSound() {
            return "random.click";
        }

        @Override
        public void shootProjectile() {
            if (this.hasAmmo()) {
                for (int i = 0; i < 6; ++i) {
                    Entity projectile = (Entity)this.getProjectile();
                    this.turret.field_70170_p.func_72838_d(projectile);
                    this.turret.field_70170_p.func_72956_a((Entity)this.turret, this.getShootSound(), 1.0f, 1.0f / (this.turret.func_70681_au().nextFloat() * 0.4f + 1.2f) + 0.5f);
                }
                --this.ammoCount;
            } else {
                this.turret.field_70170_p.func_72956_a((Entity)this.turret, this.getLowAmmoSound(), 1.0f, 1.0f / (this.turret.func_70681_au().nextFloat() * 0.4f + 1.2f) + 0.5f);
            }
        }
    }
}

