/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.entity.turret;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.entity.turret.TargetingListener;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import de.sanandrew.mods.turretmod.registry.ammo.AmmoRegistry;
import de.sanandrew.mods.turretmod.registry.ammo.TurretAmmo;
import de.sanandrew.mods.turretmod.registry.turret.TurretAttributes;
import de.sanandrew.mods.turretmod.util.PlayerList;
import de.sanandrew.mods.turretmod.util.TmrUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;

public abstract class TargetProcessor {
    protected static final Map<Class, Boolean> ENTITY_TARGET_LIST_STD = new HashMap<Class, Boolean>();
    protected final Map<Class, Boolean> entityTargetList = new HashMap<Class, Boolean>(ENTITY_TARGET_LIST_STD);
    protected final Map<UUID, Boolean> playerTargetList = new HashMap<UUID, Boolean>();
    protected int ammoCount;
    protected ItemStack ammoStack;
    protected int shootTicks;
    protected int initShootTicks;
    protected Entity entityToAttack;
    protected UUID entityToAttackUUID;
    protected EntityTurret turret;
    protected EntityTargetSelector selector;
    protected final SortedMap<Integer, List<TargetingListener>> tgtListeners;

    public TargetProcessor(EntityTurret turret) {
        this.turret = turret;
        this.selector = new EntityTargetSelector();
        this.tgtListeners = new TreeMap<Integer, List<TargetingListener>>();
        this.initShootTicks = 20;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addAmmo(ItemStack stack) {
        int maxCapacity;
        UUID currType;
        if (stack == null || !this.isAmmoApplicable(stack)) return false;
        TurretAmmo type = ItemRegistry.ammo.getAmmoType(stack);
        UUID uUID = currType = this.ammoStack == null ? null : ItemRegistry.ammo.getAmmoType(this.ammoStack).getTypeId();
        if (currType != null && !currType.equals(type.getTypeId())) {
            this.dropAmmo();
        }
        if ((maxCapacity = this.getMaxAmmoCapacity() - this.ammoCount) <= 0) return false;
        if (!this.hasAmmo()) {
            this.ammoStack = type.getStoringAmmoItem();
        } else if (!AmmoRegistry.INSTANCE.areAmmoItemsEqual(stack, this.ammoStack)) {
            return false;
        }
        int provided = type.getAmmoCapacity();
        int providedStack = stack.field_77994_a * provided;
        if (providedStack - maxCapacity > 0) {
            int stackSub = MathHelper.func_76128_c((double)((double)maxCapacity / (double)providedStack * (double)stack.field_77994_a));
            if (stackSub <= 0) return false;
            this.ammoCount += stackSub * provided;
            stack.field_77994_a -= stackSub;
            return true;
        } else {
            this.ammoCount += providedStack;
            stack.field_77994_a = 0;
        }
        return true;
    }

    public int getAmmoCount() {
        return this.ammoCount;
    }

    public ItemStack getAmmoStack() {
        if (this.ammoStack != null) {
            return this.ammoStack.func_77946_l();
        }
        return null;
    }

    public boolean hasAmmo() {
        return ItemStackUtils.isValidStack((ItemStack)this.ammoStack) && this.ammoCount > 0;
    }

    public void dropExcessAmmo() {
        int decrAmmo;
        if (this.hasAmmo() && (decrAmmo = this.ammoCount - this.getMaxAmmoCapacity()) > 0) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            TurretAmmo type = ItemRegistry.ammo.getAmmoType(this.ammoStack);
            int maxStackSize = this.ammoStack.func_77976_d();
            while (decrAmmo > 0 && type != null) {
                ItemStack stack = this.ammoStack.func_77946_l();
                stack.field_77994_a = Math.min(decrAmmo / type.getAmmoCapacity(), maxStackSize);
                decrAmmo -= stack.field_77994_a * type.getAmmoCapacity();
                if (stack.field_77994_a <= 0) break;
                items.add(stack);
            }
            this.ammoCount = this.getMaxAmmoCapacity();
            if (!items.isEmpty()) {
                for (ItemStack stack : items) {
                    EntityItem item = new EntityItem(this.turret.field_70170_p, this.turret.field_70165_t, this.turret.field_70163_u, this.turret.field_70161_v, stack);
                    this.turret.field_70170_p.func_72838_d((Entity)item);
                }
            }
        }
    }

    public void dropAmmo() {
        if (this.hasAmmo()) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            int maxStackSize = this.ammoStack.func_77976_d();
            TurretAmmo type = ItemRegistry.ammo.getAmmoType(this.ammoStack);
            while (this.ammoCount > 0 && type != null) {
                ItemStack stack = this.ammoStack.func_77946_l();
                stack.field_77994_a = Math.min(this.ammoCount / type.getAmmoCapacity(), maxStackSize);
                this.ammoCount -= stack.field_77994_a * type.getAmmoCapacity();
                if (stack.field_77994_a <= 0) {
                    this.ammoCount = 0;
                    break;
                }
                items.add(stack);
            }
            this.ammoStack = null;
            if (!items.isEmpty()) {
                for (ItemStack stack : items) {
                    EntityItem item = new EntityItem(this.turret.field_70170_p, this.turret.field_70165_t, this.turret.field_70163_u, this.turret.field_70161_v, stack);
                    this.turret.field_70170_p.func_72838_d((Entity)item);
                }
            }
        }
    }

    public void putAmmoInInventory(IInventory inventory) {
        if (this.hasAmmo()) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            int maxStackSize = this.ammoStack.func_77976_d();
            TurretAmmo type = ItemRegistry.ammo.getAmmoType(this.ammoStack);
            while (this.ammoCount > 0 && type != null) {
                ItemStack stack = this.ammoStack.func_77946_l();
                stack.field_77994_a = Math.min(this.ammoCount / type.getAmmoCapacity(), maxStackSize);
                this.ammoCount -= stack.field_77994_a * type.getAmmoCapacity();
                if (stack.field_77994_a <= 0) {
                    this.ammoCount = 0;
                    break;
                }
                items.add(stack);
            }
            this.ammoStack = null;
            if (!items.isEmpty()) {
                for (ItemStack stack : items) {
                    if ((stack = TmrUtils.addStackToInventory(stack, inventory)) == null) continue;
                    EntityItem item = new EntityItem(this.turret.field_70170_p, this.turret.field_70165_t, this.turret.field_70163_u, this.turret.field_70161_v, stack);
                    this.turret.field_70170_p.func_72838_d((Entity)item);
                }
            }
        }
    }

    public boolean isAmmoApplicable(ItemStack stack) {
        TurretAmmo stackType;
        if (stack != null && (stackType = ItemRegistry.ammo.getAmmoType(stack)) != null) {
            if (this.ammoStack == null || ItemRegistry.ammo.getAmmoType(this.ammoStack).getTypeId().equals(stackType.getTypeId())) {
                return this.ammoCount < this.getMaxAmmoCapacity();
            }
            List<TurretAmmo> types = AmmoRegistry.INSTANCE.getTypesForTurret(((Object)((Object)this.turret)).getClass());
            if (types.contains(stackType)) {
                return true;
            }
        }
        return false;
    }

    public final int getMaxAmmoCapacity() {
        return MathHelper.func_76143_f((double)this.turret.func_110148_a(TurretAttributes.MAX_AMMO_CAPACITY).func_111126_e());
    }

    public final int getMaxShootTicks() {
        return MathHelper.func_76143_f((double)this.turret.func_110148_a(TurretAttributes.MAX_RELOAD_TICKS).func_111126_e());
    }

    public final IProjectile getProjectile() {
        TurretAmmo ammo = ItemRegistry.ammo.getAmmoType(this.ammoStack);
        if (ammo != null) {
            return ammo.getEntity(this.turret);
        }
        return null;
    }

    public abstract double getRange();

    public abstract String getShootSound();

    public abstract String getLowAmmoSound();

    public void addTargetingListener(TargetingListener listener) {
        int p = listener.getPriority();
        List listenerList = TmrUtils.valueOrDefault(this.tgtListeners.get(p), new ArrayList());
        if (!listenerList.contains(listener)) {
            listenerList.add(listener);
        }
        this.tgtListeners.put(p, listenerList);
    }

    public boolean doAllowTarget(Entity e) {
        boolean ret = true;
        for (Map.Entry<Integer, List<TargetingListener>> listenerEntries : this.tgtListeners.entrySet()) {
            for (TargetingListener listener : listenerEntries.getValue()) {
                ret = listener.isTargetApplicable(this.turret, e, ret);
            }
        }
        return ret;
    }

    public void shootProjectile() {
        if (this.hasAmmo()) {
            Entity projectile = (Entity)this.getProjectile();
            this.turret.field_70170_p.func_72838_d(projectile);
            this.turret.field_70170_p.func_72956_a((Entity)this.turret, this.getShootSound(), 1.8f, 1.0f / (this.turret.func_70681_au().nextFloat() * 0.4f + 1.2f) + 0.5f);
            --this.ammoCount;
        } else {
            this.turret.field_70170_p.func_72956_a((Entity)this.turret, this.getLowAmmoSound(), 1.0f, 1.0f / (this.turret.func_70681_au().nextFloat() * 0.4f + 1.2f) + 0.5f);
        }
    }

    public void onTick() {
        boolean changed = false;
        if (this.shootTicks > 0) {
            --this.shootTicks;
        }
        if (this.entityToAttack == null && this.entityToAttackUUID != null) {
            this.entityToAttack = TmrUtils.getEntityByUUID(this.turret.field_70170_p, this.entityToAttackUUID);
        }
        double range = this.getRange();
        if (this.entityToAttack == null) {
            AxisAlignedBB aabb = this.turret.field_70121_D.func_72314_b(range, range, range);
            for (Object entityObj : this.turret.field_70170_p.func_94576_a((Entity)this.turret, aabb, (IEntitySelector)this.selector)) {
                EntityLivingBase livingBase = (EntityLivingBase)entityObj;
                boolean isEntityValid = this.turret.func_70685_l((Entity)livingBase) && livingBase.func_70089_S() && (double)this.turret.func_70032_d((Entity)livingBase) <= range;
                if (!isEntityValid || !this.doAllowTarget((Entity)livingBase)) continue;
                this.entityToAttack = livingBase;
                this.entityToAttackUUID = livingBase.func_110124_au();
                changed = true;
                break;
            }
        }
        if (this.entityToAttack != null) {
            boolean isPlayerValid;
            boolean isEntityValid = this.turret.func_70685_l(this.entityToAttack) && this.entityToAttack.func_70089_S() && (double)this.turret.func_70032_d(this.entityToAttack) <= range;
            boolean isTargetValid = Boolean.TRUE.equals(this.entityTargetList.get(this.entityToAttack.getClass()));
            boolean bl = isPlayerValid = Boolean.TRUE.equals(this.playerTargetList.get(this.entityToAttack.func_110124_au())) || Boolean.TRUE.equals(this.playerTargetList.get(PlayerList.EMPTY_UUID));
            if (isEntityValid && (isTargetValid || isPlayerValid) && this.doAllowTarget(this.entityToAttack)) {
                if (this.shootTicks == 0 && --this.initShootTicks <= 0) {
                    this.shootProjectile();
                    this.shootTicks = this.getMaxShootTicks();
                    changed = true;
                }
            } else {
                this.initShootTicks = 15;
                this.entityToAttack = null;
                this.entityToAttackUUID = null;
                changed = true;
            }
        }
        if (changed) {
            this.turret.updateState();
        }
    }

    public static void initialize() {
        for (Object clsObj : EntityList.field_75626_c.keySet()) {
            Class cls = (Class)clsObj;
            if (!EntityLiving.class.isAssignableFrom(cls) || EntityTurret.class.isAssignableFrom(cls) || EntityLiving.class.equals((Object)cls)) continue;
            ENTITY_TARGET_LIST_STD.put(cls, IMob.class.isAssignableFrom(cls));
        }
    }

    public EntityTurret getTurret() {
        return this.turret;
    }

    public boolean hasTarget() {
        return this.entityToAttack != null;
    }

    public Entity getTarget() {
        return this.entityToAttack;
    }

    public void writeToNbt(NBTTagCompound nbt) {
        nbt.func_74768_a("ammoCount", this.ammoCount);
        if (this.ammoStack != null) {
            NBTTagCompound stackTag = new NBTTagCompound();
            this.ammoStack.func_77955_b(stackTag);
            nbt.func_74782_a("ammoStack", (NBTBase)stackTag);
        }
        if (this.entityToAttackUUID != null) {
            nbt.func_74778_a("targetUUID", this.entityToAttackUUID.toString());
        }
        NBTTagList entityTargets = new NBTTagList();
        for (Class cls : this.getEnabledEntityTargets()) {
            entityTargets.func_74742_a((NBTBase)new NBTTagString(cls.getName()));
        }
        nbt.func_74782_a("entityTargets", (NBTBase)entityTargets);
        NBTTagList playerTargets = new NBTTagList();
        for (UUID uuid : this.getEnabledPlayerTargets()) {
            playerTargets.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
        }
        nbt.func_74782_a("playerTargets", (NBTBase)playerTargets);
    }

    public void readFromNbt(NBTTagCompound nbt) {
        this.ammoCount = nbt.func_74762_e("ammoCount");
        if (nbt.func_74764_b("ammoStack")) {
            this.ammoStack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("ammoStack"));
        }
        if (nbt.func_74764_b("targetUUID")) {
            this.entityToAttackUUID = UUID.fromString(nbt.func_74779_i("targetUUID"));
        }
        ArrayList entityTgt = new ArrayList();
        NBTTagList list = nbt.func_150295_c("entityTargets", 8);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            try {
                entityTgt.add(Class.forName(list.func_150307_f(i)));
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.updateEntityTargets(entityTgt.toArray(new Class[entityTgt.size()]));
        ArrayList<UUID> playerTgt = new ArrayList<UUID>();
        list = nbt.func_150295_c("playerTargets", 8);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            try {
                playerTgt.add(UUID.fromString(list.func_150307_f(i)));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.updatePlayerTargets(playerTgt.toArray(new UUID[playerTgt.size()]));
    }

    public Class[] getEnabledEntityTargets() {
        Set enabledClasses = Maps.filterEntries(this.entityTargetList, (Predicate)new Predicate<Map.Entry<Class, Boolean>>(){

            public boolean apply(Map.Entry<Class, Boolean> input) {
                return input != null && input.getValue() != false;
            }
        }).keySet();
        return enabledClasses.toArray(new Class[enabledClasses.size()]);
    }

    public UUID[] getEnabledPlayerTargets() {
        Set enabledUUIDs = Maps.filterEntries(this.playerTargetList, (Predicate)new Predicate<Map.Entry<UUID, Boolean>>(){

            public boolean apply(Map.Entry<UUID, Boolean> input) {
                return input != null && input.getValue() != false;
            }
        }).keySet();
        return enabledUUIDs.toArray(new UUID[enabledUUIDs.size()]);
    }

    public Map<Class, Boolean> getEntityTargets() {
        return new HashMap<Class, Boolean>(this.entityTargetList);
    }

    public Map<UUID, Boolean> getPlayerTargets() {
        return new HashMap<UUID, Boolean>(this.playerTargetList);
    }

    public void updateEntityTarget(Class cls, boolean active) {
        if (ENTITY_TARGET_LIST_STD.containsKey(cls)) {
            this.entityTargetList.put(cls, active);
        }
    }

    public void updatePlayerTarget(UUID uid, boolean active) {
        this.playerTargetList.put(uid, active);
    }

    public void updateEntityTargets(Class[] classes) {
        for (Map.Entry<Class, Boolean> entry : this.entityTargetList.entrySet()) {
            entry.setValue(false);
        }
        for (Class cls : classes) {
            if (cls == null || !ENTITY_TARGET_LIST_STD.containsKey(cls)) continue;
            this.entityTargetList.put(cls, true);
        }
    }

    public void updatePlayerTargets(UUID[] uuids) {
        for (Map.Entry<UUID, Boolean> entry : this.playerTargetList.entrySet()) {
            entry.setValue(false);
        }
        for (UUID uuid : uuids) {
            if (uuid == null) continue;
            this.playerTargetList.put(uuid, true);
        }
    }

    public void updateClientState(int targetId, int ammoCount, ItemStack ammoStack) {
        if (this.turret.field_70170_p.field_72995_K) {
            this.entityToAttack = targetId < 0 ? null : this.turret.field_70170_p.func_73045_a(targetId);
            this.ammoCount = ammoCount;
            this.ammoStack = ammoStack;
        }
    }

    public String getTargetName() {
        return this.hasTarget() ? EntityList.func_75621_b((Entity)this.entityToAttack) : "";
    }

    private class EntityTargetSelector
    implements IEntitySelector {
        private EntityTargetSelector() {
        }

        public boolean func_82704_a(Entity entity) {
            if (entity instanceof EntityLiving ? Boolean.TRUE.equals(TargetProcessor.this.entityTargetList.get(entity.getClass())) : entity instanceof EntityPlayer && (Boolean.TRUE.equals(TargetProcessor.this.playerTargetList.get(entity.func_110124_au())) || Boolean.TRUE.equals(TargetProcessor.this.playerTargetList.get(PlayerList.EMPTY_UUID)))) {
                return !entity.field_70128_L;
            }
            return false;
        }
    }
}

