/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.entity.turret;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import de.sanandrew.mods.turretmod.network.PacketRegistry;
import de.sanandrew.mods.turretmod.network.PacketUpdateUgradeSlot;
import de.sanandrew.mods.turretmod.registry.upgrades.TurretUpgrade;
import de.sanandrew.mods.turretmod.registry.upgrades.UpgradeRegistry;
import de.sanandrew.mods.turretmod.util.TmrUtils;
import java.util.UUID;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class UpgradeProcessor
implements IInventory {
    private ItemStack[] upgradeStacks = new ItemStack[36];
    private boolean hasChanged = false;
    private EntityTurret turret;

    public UpgradeProcessor(EntityTurret turret) {
        this.turret = turret;
    }

    public void onTick() {
        if (this.hasChanged) {
            EntityItem itm;
            TurretUpgrade upg;
            ItemStack invStack;
            int i;
            for (i = 0; i < this.upgradeStacks.length; ++i) {
                TurretUpgrade dep;
                invStack = this.upgradeStacks[i];
                if (invStack == null || (upg = UpgradeRegistry.INSTANCE.getUpgrade(invStack)) == null || (dep = upg.getDependantOn()) == null || this.hasUpgrade(dep)) continue;
                if (!this.turret.field_70170_p.field_72995_K) {
                    EntityItem itm2 = new EntityItem(this.turret.field_70170_p, this.turret.field_70165_t, this.turret.field_70163_u, this.turret.field_70161_v, invStack);
                    this.turret.field_70170_p.func_72838_d((Entity)itm2);
                }
                upg.onRemove(this.turret);
                this.upgradeStacks[i] = null;
            }
            if (!this.hasUpgrade(UpgradeRegistry.UPG_STORAGE_III)) {
                for (i = 27; i < this.upgradeStacks.length; ++i) {
                    invStack = this.upgradeStacks[i];
                    if (invStack == null) continue;
                    if (!this.turret.field_70170_p.field_72995_K) {
                        itm = new EntityItem(this.turret.field_70170_p, this.turret.field_70165_t, this.turret.field_70163_u, this.turret.field_70161_v, invStack);
                        this.turret.field_70170_p.func_72838_d((Entity)itm);
                    }
                    if ((upg = UpgradeRegistry.INSTANCE.getUpgrade(invStack)) != null) {
                        upg.onRemove(this.turret);
                    }
                    this.upgradeStacks[i] = null;
                }
            }
            if (!this.hasUpgrade(UpgradeRegistry.UPG_STORAGE_II)) {
                for (i = 18; i < 27; ++i) {
                    invStack = this.upgradeStacks[i];
                    if (invStack == null) continue;
                    if (!this.turret.field_70170_p.field_72995_K) {
                        itm = new EntityItem(this.turret.field_70170_p, this.turret.field_70165_t, this.turret.field_70163_u, this.turret.field_70161_v, invStack);
                        this.turret.field_70170_p.func_72838_d((Entity)itm);
                    }
                    if ((upg = UpgradeRegistry.INSTANCE.getUpgrade(invStack)) != null) {
                        upg.onRemove(this.turret);
                    }
                    this.upgradeStacks[i] = null;
                }
            }
            if (!this.hasUpgrade(UpgradeRegistry.UPG_STORAGE_I)) {
                for (i = 9; i < 18; ++i) {
                    invStack = this.upgradeStacks[i];
                    if (invStack == null) continue;
                    if (!this.turret.field_70170_p.field_72995_K) {
                        itm = new EntityItem(this.turret.field_70170_p, this.turret.field_70165_t, this.turret.field_70163_u, this.turret.field_70161_v, invStack);
                        this.turret.field_70170_p.func_72838_d((Entity)itm);
                    }
                    if ((upg = UpgradeRegistry.INSTANCE.getUpgrade(invStack)) != null) {
                        upg.onRemove(this.turret);
                    }
                    this.upgradeStacks[i] = null;
                }
            }
        }
    }

    public boolean hasUpgrade(UUID uuid) {
        ItemStack upgItemStack = UpgradeRegistry.INSTANCE.getUpgradeItem(uuid);
        return TmrUtils.isStackInArray(upgItemStack, this.upgradeStacks);
    }

    public boolean hasUpgrade(TurretUpgrade upg) {
        ItemStack upgItemStack = UpgradeRegistry.INSTANCE.getUpgradeItem(upg);
        return TmrUtils.isStackInArray(upgItemStack, this.upgradeStacks);
    }

    public int func_70302_i_() {
        return this.upgradeStacks.length;
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= 0 && slot < this.upgradeStacks.length ? this.upgradeStacks[slot] : null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.upgradeStacks[slot] != null) {
            if (this.upgradeStacks[slot].field_77994_a <= amount) {
                TurretUpgrade upg;
                if (!this.turret.field_70170_p.field_72995_K && (upg = UpgradeRegistry.INSTANCE.getUpgrade(this.upgradeStacks[slot])) != null) {
                    upg.onRemove(this.turret);
                }
                ItemStack itemstack = this.upgradeStacks[slot];
                this.upgradeStacks[slot] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.upgradeStacks[slot].func_77979_a(amount);
            if (this.upgradeStacks[slot].field_77994_a == 0) {
                this.upgradeStacks[slot] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.upgradeStacks[slot] != null) {
            ItemStack itemstack = this.upgradeStacks[slot];
            this.upgradeStacks[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (!this.turret.field_70170_p.field_72995_K) {
            TurretUpgrade upg;
            if (this.upgradeStacks[slot] != null && stack == null) {
                TurretUpgrade upg2 = UpgradeRegistry.INSTANCE.getUpgrade(this.upgradeStacks[slot]);
                if (upg2 != null) {
                    upg2.onRemove(this.turret);
                }
            } else if (this.upgradeStacks[slot] == null && stack != null && (upg = UpgradeRegistry.INSTANCE.getUpgrade(stack)) != null) {
                upg.onApply(this.turret);
            }
        }
        this.upgradeStacks[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "Upgrades";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
        this.hasChanged = true;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot >= 9 && !this.hasUpgrade(UpgradeRegistry.UPG_STORAGE_I)) {
            return false;
        }
        if (slot >= 18 && !this.hasUpgrade(UpgradeRegistry.UPG_STORAGE_II)) {
            return false;
        }
        if (slot >= 27 && !this.hasUpgrade(UpgradeRegistry.UPG_STORAGE_III)) {
            return false;
        }
        if (this.upgradeStacks[slot] != null) {
            return false;
        }
        if (stack != null) {
            if (stack.func_77973_b() == ItemRegistry.turretUpgrade) {
                TurretUpgrade upg = UpgradeRegistry.INSTANCE.getUpgrade(stack);
                if (this.hasUpgrade(UpgradeRegistry.INSTANCE.getUpgradeUUID(upg))) {
                    return false;
                }
                if (upg != null) {
                    TurretUpgrade dep = upg.getDependantOn();
                    return dep == null || this.hasUpgrade(dep);
                }
            }
        } else {
            return true;
        }
        return false;
    }

    public boolean tryApplyUpgrade(ItemStack upgStack) {
        TurretUpgrade dep;
        TurretUpgrade upg = UpgradeRegistry.INSTANCE.getUpgrade(upgStack);
        if (upg != null && !this.hasUpgrade(upg) && ((dep = upg.getDependantOn()) == null || this.hasUpgrade(dep))) {
            for (int i = 0; i < this.upgradeStacks.length; ++i) {
                if (!this.func_94041_b(i, upgStack)) continue;
                this.func_70299_a(i, upgStack);
                PacketRegistry.sendToAllAround((IMessage)new PacketUpdateUgradeSlot(this.turret, i, upgStack), this.turret.field_71093_bK, this.turret.field_70165_t, this.turret.field_70163_u, this.turret.field_70161_v, 64.0);
                return true;
            }
        }
        return false;
    }

    public void dropUpgrades() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70304_b(i);
            if (!ItemStackUtils.isValidStack((ItemStack)stack)) continue;
            float xOff = TmrUtils.RNG.nextFloat() * 0.8f + 0.1f;
            float yOff = TmrUtils.RNG.nextFloat() * 0.8f + 0.1f;
            float zOff = TmrUtils.RNG.nextFloat() * 0.8f + 0.1f;
            EntityItem entityitem = new EntityItem(this.turret.field_70170_p, this.turret.field_70165_t + (double)xOff, this.turret.field_70163_u + (double)yOff, this.turret.field_70161_v + (double)zOff, stack);
            float motionSpeed = 0.05f;
            entityitem.field_70159_w = (float)TmrUtils.RNG.nextGaussian() * motionSpeed;
            entityitem.field_70181_x = (float)TmrUtils.RNG.nextGaussian() * motionSpeed + 0.2f;
            entityitem.field_70179_y = (float)TmrUtils.RNG.nextGaussian() * motionSpeed;
            this.turret.field_70170_p.func_72838_d((Entity)entityitem);
        }
    }

    public void writeToNbt(NBTTagCompound nbt) {
        nbt.func_74782_a("upgInventory", (NBTBase)TmrUtils.writeItemStacksToTag(this.upgradeStacks, 1, this, "callbackWriteUpgStack"));
    }

    public void readFromNbt(NBTTagCompound nbt) {
        TmrUtils.readItemStacksFromTag(this.upgradeStacks, nbt.func_150295_c("upgInventory", 10), this, "callbackReadUpgStack");
    }

    public void callbackWriteUpgStack(ItemStack upgStack, NBTTagCompound nbt) {
        TurretUpgrade upg;
        if (upgStack != null && (upg = UpgradeRegistry.INSTANCE.getUpgrade(upgStack)) != null) {
            upg.onSave(this.turret, nbt);
        }
    }

    public void callbackReadUpgStack(ItemStack upgStack, NBTTagCompound nbt) {
        TurretUpgrade upg;
        if (upgStack != null && (upg = UpgradeRegistry.INSTANCE.getUpgrade(upgStack)) != null) {
            upg.onLoad(this.turret, nbt);
        }
    }
}

