/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.sanandrew.mods.turretmod.registry.ammo.AmmoRegistry;
import de.sanandrew.mods.turretmod.registry.ammo.TurretAmmo;
import de.sanandrew.mods.turretmod.util.TmrCreativeTabs;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class ItemAmmo
extends Item {
    @SideOnly(value=Side.CLIENT)
    private Map<UUID, IIcon> iconMap;

    public ItemAmmo() {
        this.func_77637_a(TmrCreativeTabs.TURRETS);
        this.func_77655_b("sapturretmod:turret_ammo");
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public String func_77667_c(ItemStack stack) {
        TurretAmmo type = this.getAmmoType(stack);
        return String.format("%s.%s", super.func_77667_c(stack), type == null ? "unknown" : type.getName());
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        TurretAmmo type = this.getAmmoType(stack);
        if (type != null) {
            return this.iconMap.get(type.getId());
        }
        return super.getIcon(stack, pass);
    }

    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        List<TurretAmmo> types = AmmoRegistry.INSTANCE.getRegisteredTypes();
        this.iconMap = new HashMap<UUID, IIcon>(types.size());
        for (TurretAmmo type : types) {
            this.iconMap.put(type.getId(), iconRegister.func_94245_a(String.format("%s:ammo/%s", "sapturretmod", type.getIcon())));
        }
    }

    public TurretAmmo getAmmoType(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("ammoType")) {
            String typeUUID = nbt.func_74779_i("ammoType");
            try {
                return AmmoRegistry.INSTANCE.getType(UUID.fromString(typeUUID));
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }
        return null;
    }

    public ItemStack getAmmoItem(int stackSize, TurretAmmo type) {
        if (type == null) {
            throw new IllegalArgumentException("Cannot get ammo item with NULL type!");
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("ammoType", type.getId().toString());
        ItemStack stack = new ItemStack((Item)this, stackSize);
        stack.func_77982_d(nbt);
        return stack;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (TurretAmmo type : AmmoRegistry.INSTANCE.getRegisteredTypes()) {
            list.add(this.getAmmoItem(1, type));
        }
    }
}

