/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.sanandrew.mods.turretmod.registry.medpack.RepairKitRegistry;
import de.sanandrew.mods.turretmod.registry.medpack.TurretRepairKit;
import de.sanandrew.mods.turretmod.util.TmrCreativeTabs;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class ItemRepairKit
extends Item {
    @SideOnly(value=Side.CLIENT)
    private Map<UUID, IIcon> iconMap;

    public ItemRepairKit() {
        this.func_77637_a(TmrCreativeTabs.MISC);
        this.func_77655_b("sapturretmod:turret_repair_kit");
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public String func_77667_c(ItemStack stack) {
        TurretRepairKit type = this.getRepKitType(stack);
        return String.format("%s.%s", super.func_77667_c(stack), type == null ? "unknown" : type.getName());
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        TurretRepairKit type = this.getRepKitType(stack);
        if (type != null) {
            return this.iconMap.get(type.getUUID());
        }
        return super.getIcon(stack, pass);
    }

    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        List<TurretRepairKit> types = RepairKitRegistry.INSTANCE.getRegisteredTypes();
        this.iconMap = new HashMap<UUID, IIcon>(types.size());
        for (TurretRepairKit type : types) {
            this.iconMap.put(type.getUUID(), iconRegister.func_94245_a(String.format("%s:repair_kits/%s", "sapturretmod", type.getIcon())));
        }
    }

    public TurretRepairKit getRepKitType(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("repKitType")) {
            String typeUUID = nbt.func_74779_i("repKitType");
            try {
                return RepairKitRegistry.INSTANCE.getRepairKit(UUID.fromString(typeUUID));
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }
        return null;
    }

    public ItemStack getRepKitItem(int stackSize, TurretRepairKit type) {
        if (type == null) {
            throw new IllegalArgumentException("Cannot get ammo item with NULL type!");
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("repKitType", type.getUUID().toString());
        ItemStack stack = new ItemStack((Item)this, stackSize);
        stack.func_77982_d(nbt);
        return stack;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (TurretRepairKit type : RepairKitRegistry.INSTANCE.getRegisteredTypes()) {
            list.add(this.getRepKitItem(1, type));
        }
    }
}

